/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Readers;

public class WordTemplateContentToMarkdownConverter {
    private static final String PARAGRAPH_TAG_WITH_ATTRS = "<w:p ";
    private static final String PARAGRAPH_TAG_EMPTY = "<w:p/>";
    private static final String PARAGRAPH_TAG = "<w:p>";
    private static final CharSequence[] PARAGRAPH_TAGS = new CharSequence[]{"<w:p ", "<w:p>", "</w:p>", "</w:body>"};
    private static final Pattern internalAttributeElementsPattern = Pattern.compile("<((\\w+:)?(\\w+))(\\s+.*?)((/>)|(>(.*?)</\\1>))", 42);
    private static final Pattern proofErrTagKiller = Pattern.compile("</?w:proofErr.*?/?>");
    private static final int NAMESPACE_GROUP = 2;
    private static final int ELEMENT_NAME_GROUP = 3;
    private static final int ATTRIBUTE_BLOCK_GROUP = 4;
    private static final int CONTENT_GROUP = 8;
    private static final String HEADER_REGEX = "Heading[1-9]";
    private static final String RUN_TEXT_REGEX = "(?s)<w:r.*?>(?:(<w:br/>)|(.*?)<w:(?:pict|t)>(.*?)</w:(?:pict|t)>)</w:r>";
    private static final String NORMALWEB_REGEX = "NormalWeb";
    private static final String BOLD_INDICATOR = "<w:rPr><w:b/></w:rPr>";
    private static final String BOLD_COMPLEX_INDICATOR = "<w:rPr><w:b/><w:b-cs/></w:rPr>";
    private static final String ITALICS_INDICATOR = "<w:rPr><w:i/></w:rPr>";
    private static final String V_SHAPE_REGEX = "(?s)<v:shape.*?>(.*?)</v:shape.*?>";
    private static final String BULLET_INDICATOR = "Bullet point";
    private static final String NO_PROOF_INDICATOR = "<w:rPr><w:noProof/>.*?</w:rPr>";
    private static final String BREAK_INDICATOR = "<w:br/>";
    private static final String IMAGE_INDICATOR = ".png";
    private static final String IMAGE_LOCATION_INDICATOR = "href=\"(.*?.png.*?)\"";
    private String markdownContent = "";
    private String paragraphStyle = "";

    private void parseParagraphNormalContents(CharSequence content) {
        Pattern regex = Pattern.compile(RUN_TEXT_REGEX);
        Matcher matcher = regex.matcher(content);
        while (matcher.find()) {
            if (matcher.group(1) == null) {
                content = matcher.group(3);
                if (matcher.group(2).equals(BREAK_INDICATOR)) {
                    this.markdownContent = String.valueOf(this.markdownContent) + "\n";
                    this.markdownContent = String.valueOf(this.markdownContent) + content;
                    continue;
                }
                if (matcher.group(2).equals(BOLD_INDICATOR) || matcher.group(2).equals(BOLD_COMPLEX_INDICATOR)) {
                    if (((String)content).startsWith(" ")) {
                        this.markdownContent = String.valueOf(this.markdownContent) + " **" + ((String)content).substring(1) + "**";
                        continue;
                    }
                    this.markdownContent = String.valueOf(this.markdownContent) + "**" + content + "**";
                    continue;
                }
                if (matcher.group(2).equals(ITALICS_INDICATOR)) {
                    if (((String)content).startsWith(" ")) {
                        this.markdownContent = String.valueOf(this.markdownContent) + " *" + ((String)content).substring(1) + "*";
                        continue;
                    }
                    this.markdownContent = String.valueOf(this.markdownContent) + "*" + content + "*";
                    continue;
                }
                if (matcher.group(2).matches(NO_PROOF_INDICATOR)) {
                    if (matcher.group(3).contains(BULLET_INDICATOR) && matcher.group(3).matches(V_SHAPE_REGEX)) {
                        this.markdownContent = String.valueOf(this.markdownContent) + "* ";
                        continue;
                    }
                    if (!matcher.group(3).contains(IMAGE_INDICATOR)) continue;
                    Pattern imageRegex = Pattern.compile(IMAGE_LOCATION_INDICATOR);
                    Matcher imageLocMatcher = imageRegex.matcher(matcher.group(3));
                    while (imageLocMatcher.find()) {
                        this.markdownContent = String.valueOf(this.markdownContent) + imageLocMatcher.group(1);
                    }
                    continue;
                }
                this.markdownContent = String.valueOf(this.markdownContent) + content;
                continue;
            }
            if (!matcher.group(1).equals(BREAK_INDICATOR)) continue;
            this.markdownContent = String.valueOf(this.markdownContent) + "\n";
        }
    }

    public String run(String wordXML) {
        wordXML = "<w:body>" + wordXML + "</w:body>";
        BufferedReader reader = null;
        try {
            CharSequence element;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(wordXML.getBytes());
            reader = new BufferedReader(new InputStreamReader(inputStream));
            if (Readers.forward((Reader)reader, (CharSequence[])new CharSequence[]{"<w:body>"}) == null) {
                this.handleFormatError("no start of body tag");
            }
            StringBuilder content = new StringBuilder(2000);
            while ((element = Readers.forward((Reader)reader, (CharSequence[])PARAGRAPH_TAGS)) != null) {
                if (element == "</w:body>") {
                    return this.markdownContent;
                }
                content.setLength(0);
                content.append(element);
                boolean emptyTagWithAttrs = false;
                if (element == PARAGRAPH_TAG_WITH_ATTRS) {
                    if (Readers.forward((Reader)reader, (Appendable)content, (CharSequence[])new CharSequence[]{">"}) == null) {
                        this.handleFormatError("did not find expected end of tag");
                    }
                    emptyTagWithAttrs = content.toString().endsWith("/>");
                }
                if (element == PARAGRAPH_TAG || !emptyTagWithAttrs && element == PARAGRAPH_TAG_WITH_ATTRS) {
                    Readers.xmlForward((Reader)reader, (Appendable)content, (CharSequence)"w:p");
                } else if (element != PARAGRAPH_TAG_WITH_ATTRS && element != PARAGRAPH_TAG_EMPTY) {
                    throw new IllegalStateException("Unexpected element returned");
                }
                content = new StringBuilder(proofErrTagKiller.matcher(content).replaceAll(""));
                this.paragraphStyle = null;
                this.parseParagraphAttributes(content, new Stack<String>());
                if (this.paragraphStyle == null) {
                    this.parseParagraphNormalContents(content);
                } else if (this.paragraphStyle.matches(HEADER_REGEX)) {
                    this.parseParagraphHeaderContents(content);
                } else if (this.paragraphStyle.matches(NORMALWEB_REGEX)) {
                    this.parseParagraphNormalContents(content);
                }
                this.markdownContent = String.valueOf(this.markdownContent) + "\n\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(this.markdownContent) + "... - ERROR CONVERTING WORD TEMPLATE CONTENT TO MARKDOWN";
    }

    private int calcHeaderLevel(CharSequence content) {
        String[] parts = ((String)content).split("\\.");
        return parts.length;
    }

    private void parseParagraphHeaderContents(CharSequence content) {
        int level;
        Pattern regex = Pattern.compile(RUN_TEXT_REGEX);
        Matcher matcher = regex.matcher(content);
        if (matcher.find()) {
            content = matcher.group(3);
        }
        if ((level = this.calcHeaderLevel(content)) > 0) {
            int i = 0;
            while (i < level) {
                this.markdownContent = String.valueOf(this.markdownContent) + "#";
                ++i;
            }
            this.markdownContent = String.valueOf(this.markdownContent) + " ";
        }
        this.markdownContent = String.valueOf(this.markdownContent) + content;
    }

    private void parseParagraphAttributes(CharSequence content, Stack<String> parentElementNames) {
        Matcher matcher = internalAttributeElementsPattern.matcher(content);
        while (matcher.find()) {
            String elementContent;
            String elementName = matcher.group(3);
            matcher.group(2);
            String elementAttributes = matcher.group(4) == null ? "" : matcher.group(4);
            String string = elementContent = matcher.group(8) == null ? "" : matcher.group(8);
            if ("pStyle".equals(elementName)) {
                this.paragraphStyle = WordTemplateContentToMarkdownConverter.getAttributeValue("w:val", elementAttributes);
            }
            parentElementNames.push(elementName);
            this.parseParagraphAttributes(elementContent, parentElementNames);
            parentElementNames.pop();
        }
    }

    private static final String getAttributeValue(String attributeName, String attributeStorage) {
        int startIndex;
        attributeName = String.valueOf(attributeName) + "=\"";
        String attribute = "";
        int index = attributeStorage.indexOf(attributeName);
        if (index != -1 && (startIndex = index + attributeName.length()) < attributeStorage.length()) {
            attribute = attributeStorage.substring(startIndex, attributeStorage.indexOf(34, startIndex)).trim();
        }
        return attribute;
    }

    private void handleFormatError(String message) {
        throw new OseeStateException("File format error: %s in file [%s]", new Object[]{message});
    }
}

