/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import org.eclipse.osee.define.rest.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.importing.parsers.DoorsArtifactBuilder;
import org.eclipse.osee.define.rest.importing.parsers.DoorsArtifactExtractor;
import org.eclipse.osee.define.rest.importing.parsers.DoorsColumnType;
import org.eclipse.osee.define.rest.importing.parsers.DoorsDataType;
import org.eclipse.osee.define.rest.importing.parsers.DoorsTableRow;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class DoorsTableRowCollector {
    private final DoorsArtifactExtractor extractor;
    private final ArrayList<DoorsTableRow> rawRows = Lists.newArrayList();
    private final HashMap<DoorsColumnType, Integer> columns = Maps.newHashMap();
    private final Stack<DoorsTableRow> stack = new Stack();
    private static final String UNKNOWN_STRING = "unknown";

    public DoorsTableRowCollector(DoorsArtifactExtractor extractor) {
        this.extractor = extractor;
    }

    public void addRawRow(Node row) {
        DoorsTableRow newRow = new DoorsTableRow();
        newRow.fill(row);
        if (this.rawRows.size() == 0) {
            this.initColumns(newRow);
        }
        this.rawRows.add(newRow);
    }

    public Collection<DoorsTableRow> getTableRows() {
        return this.rawRows;
    }

    public DoorsTableRow getTableRow(int index) {
        return this.rawRows.get(index);
    }

    private void initColumns(DoorsTableRow first) {
        int i = 0;
        for (Element colHeadElement : first.getRows()) {
            if (!"th".equals(colHeadElement.tagName())) {
                throw new OseeArgumentException("must be a table heading", new Object[]{colHeadElement});
            }
            String value = colHeadElement.ownText();
            DoorsColumnType dcte = DoorsColumnType.fromString(value);
            this.columns.put(dcte, i);
            ++i;
        }
    }

    public void createArtifacts(OrcsApi orcsApi, RoughArtifactCollector collector) {
        this.analyzeRows();
        LinkedList<DoorsTableRow> queue = new LinkedList<DoorsTableRow>();
        DoorsArtifactBuilder dab = new DoorsArtifactBuilder(orcsApi, collector.getParentRoughArtifact().getResults(), this.extractor, this);
        for (DoorsTableRow dr : this.getTableRows()) {
            switch (dr.getType()) {
                case SINGLE: {
                    collector.addRoughArtifact(dab.populateArtifact(dr));
                    break;
                }
                case MULTI_START: {
                    queue.clear();
                    queue.add(dr);
                    break;
                }
                case MULTI_MID: {
                    queue.add(dr);
                    break;
                }
                case MULTI_END: {
                    queue.add(dr);
                    collector.addRoughArtifact(dab.populateArtifact(queue));
                    break;
                }
                case FIRST_ROW: {
                    break;
                }
                default: {
                    throw new OseeStateException("Unhandled enumeration", new Object[]{dr});
                }
            }
        }
    }

    private DoorsDataType getDataTypeValue(DoorsTableRow dr) {
        int index = this.columns.get((Object)DoorsColumnType.DATA_TYPE);
        String s = dr.getElement(index).ownText();
        return DoorsDataType.fromString(s);
    }

    public String getPreferredName(DoorsTableRow dr) {
        int secondary;
        Conditions.checkNotNull((Object)dr, (String)"Doors Table Row");
        int index = this.getColumns().get((Object)DoorsColumnType.PARAGRAPH_HEADING);
        String toReturn = dr.getElement(index).ownText();
        if (toReturn.isEmpty() && (toReturn = dr.getElement(secondary = this.columns.get((Object)DoorsColumnType.ID).intValue()).ownText()).isEmpty()) {
            toReturn = UNKNOWN_STRING;
        }
        return toReturn;
    }

    public String getSimpleText(DoorsTableRow dr, DoorsColumnType dte) {
        Conditions.checkNotNull((Object)dr, (String)"Doors Table Row");
        Element e = dr.getElement(this.getColumns().get((Object)dte));
        if (e == null) {
            throw new OseeStateException("Unknown Column type in Doors Table Row", new Object[]{dr, dte});
        }
        return e.ownText();
    }

    public String getHTML(DoorsTableRow dr, DoorsColumnType dte) {
        Conditions.checkNotNull((Object)dr, (String)"Doors Table Row");
        Element e = dr.getElement(this.getColumns().get((Object)dte));
        if (e == null) {
            throw new OseeStateException("Unknown Column type in Doors Table Row", new Object[]{dr, dte});
        }
        return e.html();
    }

    private void analyzeRows() {
        if (this.rawRows.size() < 2) {
            throw new OseeStateException("Not enough rows to analyze", new Object[]{this.rawRows});
        }
        this.rawRows.get(0).setRowType(DoorsTableRow.RowType.FIRST_ROW);
        int i = 1;
        while (i < this.rawRows.size()) {
            DoorsTableRow current = this.rawRows.get(i);
            DoorsDataType dte = this.getDataTypeValue(current);
            current.setDataType(dte);
            if (dte.isSingle().booleanValue()) {
                this.setStack(current, DoorsTableRow.RowType.SINGLE);
            } else {
                this.setStack(current, DoorsTableRow.RowType.MULTI_START);
            }
            ++i;
        }
        this.cleanupStack();
    }

    private DoorsTableRow getFirstRow() {
        DoorsTableRow toReturn = null;
        if (this.rawRows.size() > 0) {
            toReturn = this.rawRows.get(0);
        }
        return toReturn;
    }

    private void setStack(DoorsTableRow current, DoorsTableRow.RowType rt) {
        if (this.stack.empty()) {
            this.stack.push(current);
        }
        DoorsTableRow.RowType stackTop = this.stack.peek().getType();
        switch (stackTop) {
            case SINGLE: {
                this.handleSingle(current, rt);
                break;
            }
            case MULTI_START: 
            case MULTI_MID: {
                this.handleMulti(current, rt);
                break;
            }
            case MULTI_END: {
                break;
            }
            case FIRST_ROW: {
                break;
            }
            default: {
                throw new OseeStateException("Unhandled enumeration", new Object[]{current});
            }
        }
    }

    private void handleSingle(DoorsTableRow current, DoorsTableRow.RowType rt) {
        switch (rt) {
            case SINGLE: {
                this.stack.pop();
                this.stack.push(current);
                break;
            }
            case MULTI_START: {
                this.stack.peek().setRowType(DoorsTableRow.RowType.MULTI_START);
                current.setRowType(DoorsTableRow.RowType.MULTI_MID);
                this.stack.push(current);
                break;
            }
            case MULTI_MID: 
            case MULTI_END: {
                break;
            }
            case FIRST_ROW: {
                break;
            }
            default: {
                throw new OseeStateException("Unhandled enumeration", new Object[]{current});
            }
        }
    }

    private void handleMulti(DoorsTableRow current, DoorsTableRow.RowType rt) {
        switch (rt) {
            case SINGLE: {
                this.stack.peek().setRowType(DoorsTableRow.RowType.MULTI_END);
                this.stack.clear();
                this.stack.push(current);
                break;
            }
            case MULTI_START: {
                current.setRowType(DoorsTableRow.RowType.MULTI_MID);
                this.stack.push(current);
                break;
            }
            case MULTI_MID: 
            case MULTI_END: {
                break;
            }
            case FIRST_ROW: {
                break;
            }
            default: {
                throw new OseeStateException("Unhandled enumeration", new Object[]{current});
            }
        }
    }

    private void cleanupStack() {
        if (!this.stack.empty()) {
            DoorsTableRow.RowType stackTop = this.stack.peek().getType();
            switch (stackTop) {
                case SINGLE: {
                    break;
                }
                case MULTI_START: {
                    this.stack.peek().setRowType(DoorsTableRow.RowType.SINGLE);
                    break;
                }
                case MULTI_MID: {
                    this.stack.peek().setRowType(DoorsTableRow.RowType.MULTI_END);
                    break;
                }
                case MULTI_END: {
                    break;
                }
                case FIRST_ROW: {
                    break;
                }
                default: {
                    throw new OseeStateException("Unhandled enumeration", new Object[]{stackTop});
                }
            }
            this.stack.clear();
        }
    }

    private HashMap<DoorsColumnType, Integer> getColumns() {
        if (this.columns.isEmpty()) {
            throw new OseeStateException("Doors Table Row Collector is empty", new Object[]{this});
        }
        return this.columns;
    }

    private void outputHTML(String file) throws FileNotFoundException, UnsupportedEncodingException {
        String outputfile = String.format("%s%s.html", file, Lib.getDateTimeString());
        try (PrintWriter writer = new PrintWriter(outputfile, "UTF-8");){
            this.outputHTML(writer);
        }
    }

    public void outputHTML(PrintWriter writer) {
        writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<title> Testing reading requirements and outputting them </title>");
        writer.println("</head>");
        writer.println("<body  bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#EE0000\" alink=\"#808080\" vlink=\"#808080\">");
        writer.println("<table border=\"\">");
        writer.println("<tbody>");
        for (DoorsTableRow dr : this.rawRows) {
            writer.println("<tr>");
            for (Element e : dr.getRows()) {
                writer.println(e.toString());
            }
            if (dr == this.getFirstRow()) {
                writer.println("<th width=\"100\" align=\"Left\">Combination</th>");
            } else {
                writer.println(String.format("<td>%s</td>", dr.getType().toString()));
            }
            writer.println("</tr>");
        }
        writer.println("</tbody>");
        writer.println("</table>");
        writer.println("</body>");
        writer.println("</html>");
    }
}

