/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.net.URI;
import java.util.Collection;
import java.util.Queue;
import org.eclipse.osee.define.rest.api.importing.RoughArtifact;
import org.eclipse.osee.define.rest.api.importing.RoughArtifactKind;
import org.eclipse.osee.define.rest.importing.parsers.DoorsArtifactExtractor;
import org.eclipse.osee.define.rest.importing.parsers.DoorsColumnType;
import org.eclipse.osee.define.rest.importing.parsers.DoorsDataType;
import org.eclipse.osee.define.rest.importing.parsers.DoorsTableRow;
import org.eclipse.osee.define.rest.importing.parsers.DoorsTableRowCollector;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;

public class DoorsArtifactBuilder {
    private final DoorsTableRowCollector rowCollector;
    private final DoorsArtifactExtractor extractor;
    private final OrcsApi orcsApi;
    private final XResultData results;

    public DoorsArtifactBuilder(OrcsApi orcsApi, XResultData results, DoorsArtifactExtractor extractor, DoorsTableRowCollector rowCollector) {
        this.rowCollector = rowCollector;
        this.extractor = extractor;
        this.orcsApi = orcsApi;
        this.results = results;
    }

    public RoughArtifact populateArtifact(DoorsTableRow dr) {
        Conditions.checkNotNull((Object)dr, (String)"Table Row");
        RoughArtifact toReturn = this.initRoughArtifact(dr);
        this.translateRequirementsColumn(dr, toReturn);
        this.translateIDColumn(dr, toReturn);
        this.translateSubsystemColumn(dr, toReturn);
        this.translateEffectivityColumn(dr, toReturn);
        this.translateVerificationCriteriaColumn(dr, toReturn);
        return toReturn;
    }

    public RoughArtifact populateArtifact(Queue<DoorsTableRow> queue) {
        Conditions.checkNotNullOrEmpty(queue, (String)"Queue");
        RoughArtifact combined = this.populateArtifact(queue.remove());
        while (!queue.isEmpty()) {
            this.combineDoorsArtifacts(combined, this.populateArtifact(queue.remove()));
        }
        return combined;
    }

    private RoughArtifact initRoughArtifact(DoorsTableRow dr) {
        String guidString;
        RoughArtifactKind rk = this.kindFromDataType(dr);
        RoughArtifact toReturn = new RoughArtifact(this.orcsApi, this.results, rk, this.rowCollector.getPreferredName(dr));
        String paragraph = this.rowCollector.getSimpleText(dr, DoorsColumnType.OBJECT_NUMBER);
        toReturn.setSectionNumber(paragraph);
        toReturn.addAttribute((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, paragraph);
        if (rk == RoughArtifactKind.SECONDARY) {
            toReturn.setPrimaryArtifactType(CoreArtifactTypes.HeadingHtml);
        }
        if (!GUID.isValid((CharSequence)(guidString = this.rowCollector.getSimpleText(dr, DoorsColumnType.GUID))) && dr.isMainRow()) {
            guidString = GUID.create();
        }
        if (GUID.isValid((CharSequence)guidString)) {
            toReturn.setGuid(guidString);
        }
        return toReturn;
    }

    private void translateRequirementsColumn(DoorsTableRow dr, RoughArtifact ra) {
        String reqTextHTML = this.rowCollector.getHTML(dr, DoorsColumnType.REQUIREMENTS);
        if (dr.getDataType() == DoorsDataType.LIST) {
            reqTextHTML = this.extractor.processList(reqTextHTML);
        }
        this.extractor.handleRequirement(reqTextHTML, ra);
    }

    private void translateIDColumn(DoorsTableRow dr, RoughArtifact ra) {
        String id = this.rowCollector.getSimpleText(dr, DoorsColumnType.ID);
        ra.addAttribute((AttributeTypeToken)CoreAttributeTypes.LegacyId, id);
    }

    private boolean isValidForTranslation(String s) {
        return Strings.isValid((String)s) && !s.equalsIgnoreCase("<br></br>") && !s.equalsIgnoreCase("<br />");
    }

    private void translateSubsystemColumn(DoorsTableRow dr, RoughArtifact ra) {
        String subsystem = this.rowCollector.getSimpleText(dr, DoorsColumnType.SUBSYSTEM);
        if (this.isValidForTranslation(subsystem)) {
            ra.addAttribute((AttributeTypeToken)CoreAttributeTypes.Subsystem, subsystem);
        }
    }

    private void translateEffectivityColumn(DoorsTableRow dr, RoughArtifact ra) {
        String effectivity = this.rowCollector.getSimpleText(dr, DoorsColumnType.EFFECTIVITY);
        if (this.isValidForTranslation(effectivity)) {
            ra.addAttribute((AttributeTypeToken)CoreAttributeTypes.Effectivity, effectivity);
        }
    }

    private void translateVerificationCriteriaColumn(DoorsTableRow dr, RoughArtifact ra) {
        String criteria = this.rowCollector.getSimpleText(dr, DoorsColumnType.VERIFICATION_CRITERIA);
        if (this.isValidForTranslation(criteria)) {
            this.extractor.processVerification(this.orcsApi, criteria, ra);
        }
    }

    private RoughArtifactKind kindFromDataType(DoorsTableRow dr) {
        RoughArtifactKind kind = null;
        DoorsDataType dt = dr.getDataType();
        switch (dt) {
            case HEADING: 
            case HEADER: {
                kind = RoughArtifactKind.SECONDARY;
                break;
            }
            default: {
                kind = RoughArtifactKind.PRIMARY;
            }
        }
        return kind;
    }

    private void combineDoorsArtifacts(RoughArtifact combined, RoughArtifact add) {
        Conditions.checkNotNull((Object)combined, (String)"Combining artifact");
        Conditions.checkNotNull((Object)add, (String)"Artifact to combine");
        this.mergeArtifactKind(combined, add);
        this.mergeImages(combined, add);
        this.mergeAttribute(combined, add, CoreAttributeTypes.LegacyId.getName(), ",");
        this.mergeAttribute(combined, add, CoreAttributeTypes.HtmlContent.getName(), "<br>");
        this.mergeAttribute(combined, add, CoreAttributeTypes.QualificationMethod.getName(), ",");
        this.mergeAttribute(combined, add, CoreAttributeTypes.VerificationEvent.getName(), ",");
        this.mergeAttribute(combined, add, CoreAttributeTypes.VerificationLevel.getName(), ",");
        this.mergeAttribute(combined, add, CoreAttributeTypes.VerificationAcceptanceCriteria.getName(), ",");
    }

    private void mergeArtifactKind(RoughArtifact combined, RoughArtifact add) {
        if (add.getRoughArtifactKind().equals((Object)RoughArtifactKind.PRIMARY)) {
            combined.setPrimaryArtifactType(CoreArtifactTypes.HtmlArtifact);
            combined.setRoughArtifactKind(RoughArtifactKind.PRIMARY);
        }
    }

    private void mergeImages(RoughArtifact combined, RoughArtifact add) {
        Collection requirementUri = add.getURIAttributes();
        if (requirementUri.size() > 0) {
            for (URI uri : requirementUri) {
                combined.addAttribute(CoreAttributeTypes.ImageContent.getName(), uri);
            }
        }
    }

    private void mergeAttribute(RoughArtifact combined, RoughArtifact add, String attrName, String joiner) {
        String addendum = add.getRoughAttribute(attrName);
        String current = combined.getRoughAttribute(attrName);
        String result = this.combineStrings(current, addendum, joiner);
        if (Strings.isValid((String)result)) {
            combined.setAttribute(attrName, result);
        }
    }

    private String combineStrings(String result, String addendum, String joiner) {
        if (result == null && addendum == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (result == null) {
            sb.append(addendum);
        } else if (addendum == null) {
            sb.append(result);
        } else {
            sb.append(result);
            sb.append(joiner);
            sb.append(addendum);
        }
        return sb.toString();
    }
}

