/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.operations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.define.rest.api.importing.IArtifactExtractor;
import org.eclipse.osee.define.rest.api.importing.RoughArtifact;
import org.eclipse.osee.define.rest.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.importing.resolvers.IArtifactImportResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.orcs.OrcsApi;

public class RoughToRealVerificationOperation {
    private final OrcsApi orcsApi;
    private final BranchId branchId;
    private final XResultData results;
    private final RoughArtifactCollector rawData;
    private final IArtifactImportResolver artifactResolver;
    private final Map<RoughArtifact, ArtifactReadable> roughToRealArtifacts;
    private final ArtifactReadable destinationArtifact;

    public RoughToRealVerificationOperation(OrcsApi orcsApi, BranchId branchId, XResultData results, ArtifactReadable destinationArtifact, RoughArtifactCollector rawData, IArtifactImportResolver artifactResolver, boolean deleteUnmatchedArtifacts, IArtifactExtractor extractor) {
        this.results = results;
        this.orcsApi = orcsApi;
        this.branchId = branchId;
        this.rawData = rawData;
        this.artifactResolver = artifactResolver;
        this.destinationArtifact = destinationArtifact;
        this.roughToRealArtifacts = new HashMap<RoughArtifact, ArtifactReadable>();
        this.roughToRealArtifacts.put(rawData.getParentRoughArtifact(), destinationArtifact);
    }

    public void doWork() {
        for (RoughArtifact roughArtifact : this.rawData.getRoughArtifacts()) {
            ArtifactId art = this.artifactResolver.resolve(roughArtifact, this.branchId, (ArtifactId)this.destinationArtifact, (ArtifactId)this.destinationArtifact);
            if (art != null) continue;
            this.results.errorf("Artifact %s with Doors ID %s not found", new Object[]{roughArtifact.getName(), roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsId.getName())});
        }
    }
}

