/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.identifier;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierFactoryType;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTracker;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTrackerCounting;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTrackerPatternMatching;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;

public class IdentifierFactory {
    IdentifierFactoryType identifierFactoryType;
    private final EnumMap<IdentifierType, IdentifierTracker> identifierTrackerMap;

    public IdentifierFactory(IdentifierFactoryType identifierFactoryType) {
        this.identifierFactoryType = Objects.requireNonNull(identifierFactoryType, "IdentifierFactory::new, parameter \"identifierFactoryType\" is null.");
        this.identifierTrackerMap = new EnumMap(IdentifierType.class);
        Function<IdentifierType, IdentifierTracker> identifierTrackerFactory = identifierFactoryType == IdentifierFactoryType.COUNTING ? IdentifierTrackerCounting::new : IdentifierTrackerPatternMatching::new;
        Arrays.stream(IdentifierType.values()).forEach(identifierType -> {
            IdentifierTracker identifierTracker = this.identifierTrackerMap.put((IdentifierType)identifierType, (IdentifierTracker)identifierTrackerFactory.apply((IdentifierType)identifierType));
        });
    }

    public @NonNull Identifier createIdentifier(IdentifierType identifierType) {
        if (this.identifierFactoryType != IdentifierFactoryType.COUNTING) {
            throw new IllegalStateException();
        }
        return this.identifierTrackerMap.get(identifierType).create(null);
    }

    public @NonNull Identifier createIdentifier(IdentifierType identifierType, String foreignIdentifier) {
        if (this.identifierFactoryType != IdentifierFactoryType.PATTERN_MATCHING) {
            throw new IllegalStateException();
        }
        return this.identifierTrackerMap.get(identifierType).create(foreignIdentifier);
    }

    public Optional<Identifier> getPrimaryIdentifierByForeignIdentifierString(IdentifierType identifierType, String foreignIdentifierString) {
        if (this.identifierFactoryType != IdentifierFactoryType.PATTERN_MATCHING) {
            throw new IllegalStateException();
        }
        IdentifierTracker identifierTracker = this.identifierTrackerMap.get(identifierType);
        return identifierTracker.getPrimaryIdentifierByForeignIdentifierString(foreignIdentifierString);
    }
}

