/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.templatemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.define.operations.api.publisher.templatemanager.TemplateManagerOperations;
import org.eclipse.osee.define.operations.publisher.templatemanager.PublishingTemplate;
import org.eclipse.osee.define.operations.publisher.templatemanager.PublishingTemplateCache;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateKeyGroups;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateKeyType;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.publishing.DataAccessOperations;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;

public class TemplateManagerOperationsImpl
implements TemplateManagerOperations {
    private static TemplateManagerOperationsImpl templateManagerOperationsImpl = null;
    private final JdbcService jdbcService;
    protected PublishingTemplateCache publishingTemplateCache;

    public static synchronized TemplateManagerOperationsImpl create(JdbcService jdbcService, Log logger, DataAccessOperations dataAccessOperations, OrcsTokenService orcsTokenService) {
        return Objects.isNull(templateManagerOperationsImpl) ? (templateManagerOperationsImpl = new TemplateManagerOperationsImpl(Objects.requireNonNull(jdbcService), Objects.requireNonNull(logger), Objects.requireNonNull(dataAccessOperations), Objects.requireNonNull(orcsTokenService))) : templateManagerOperationsImpl;
    }

    public static synchronized void free() {
        PublishingTemplateCache.free();
        templateManagerOperationsImpl = null;
    }

    private TemplateManagerOperationsImpl(JdbcService jdbcService, Log logger, DataAccessOperations dataAccessOperations, OrcsTokenService orcsTokenService) {
        this.jdbcService = jdbcService;
        this.publishingTemplateCache = PublishingTemplateCache.create(logger, dataAccessOperations, orcsTokenService);
    }

    public void deleteCache() {
        this.publishingTemplateCache.deleteCache();
    }

    private List<String> getPossibleTemplateNamesOrderedBySpecialization(PublishingTemplateRequest publishingTemplateRequest, boolean isNoTags) {
        String isNoTagsString;
        String rendererId = publishingTemplateRequest.getRendererId();
        String presentationType = publishingTemplateRequest.getPresentationType();
        String publishArtifactTypeName = publishingTemplateRequest.getPublishArtifactTypeName();
        String option = publishingTemplateRequest.getOption();
        if (Objects.isNull(rendererId) || Objects.isNull(presentationType)) {
            throw new OseeArgumentException("Invalid renderer[%s] or presentationType[%s]", new Object[]{rendererId == null ? "null" : rendererId, presentationType == null ? "null" : presentationType});
        }
        ArrayList<String> list = new ArrayList<String>();
        String string = isNoTagsString = isNoTags ? " NO TAGS" : "";
        if (Objects.nonNull(publishArtifactTypeName) && Objects.nonNull(option)) {
            list.add(String.valueOf(rendererId) + " " + publishArtifactTypeName + " " + presentationType + " " + option + isNoTagsString);
        }
        if (Objects.nonNull(publishArtifactTypeName)) {
            list.add(String.valueOf(rendererId) + " " + publishArtifactTypeName + " " + presentationType + isNoTagsString);
        }
        if (Objects.nonNull(option)) {
            list.add(String.valueOf(rendererId) + " " + presentationType + " " + option + isNoTagsString);
        }
        list.add(String.valueOf(rendererId) + " " + presentationType + isNoTagsString);
        return list;
    }

    public org.eclipse.osee.framework.core.publishing.PublishingTemplate getPublishingTemplate(PublishingTemplateRequest publishingTemplateRequest) {
        Conditions.require((Object)publishingTemplateRequest, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"publishingTemplateRequest", (String)"cannot be null", Objects::isNull, NullPointerException::new, (String)"publishing template request is valid", p -> !p.isValid(), IllegalArgumentException::new);
        boolean isNoTags = Boolean.valueOf(OseeInfo.getValue((JdbcClient)this.jdbcService.getClient(), (String)"osee.publish.no.tags"));
        org.eclipse.osee.framework.core.publishing.PublishingTemplate publishingTemplateBean = (publishingTemplateRequest.isByOptions() ? this.publishingTemplateCache.findFirstTemplate(PublishingTemplateKeyType.NAME, publishingTemplateRequest.getOption()).or(() -> this.publishingTemplateCache.findFirstTemplateByMatchCriteria(this.getPossibleTemplateNamesOrderedBySpecialization(publishingTemplateRequest, isNoTags))) : this.publishingTemplateCache.findFirstTemplate(PublishingTemplateKeyType.IDENTIFIER, publishingTemplateRequest.getTemplateId())).map(publishingTemplate -> publishingTemplate.getBean(publishingTemplateRequest.getFormatIndicator())).orElse(org.eclipse.osee.framework.core.publishing.PublishingTemplate.SENTINEL);
        return publishingTemplateBean;
    }

    public String getPublishingTemplateStatus(PublishingTemplateRequest publishingTemplateRequest) {
        Conditions.require((Object)publishingTemplateRequest, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"publishingTemplateRequest", (String)"cannot be null", Objects::isNull, NullPointerException::new, (String)"publishing template request is valid", p -> !p.isValid(), IllegalArgumentException::new);
        boolean isNoTags = Boolean.valueOf(OseeInfo.getValue((JdbcClient)this.jdbcService.getClient(), (String)"osee.publish.no.tags"));
        return (publishingTemplateRequest.isByOptions() ? this.publishingTemplateCache.findFirstTemplate(PublishingTemplateKeyType.NAME, publishingTemplateRequest.getOption()).or(() -> this.publishingTemplateCache.findFirstTemplateByMatchCriteria(this.getPossibleTemplateNamesOrderedBySpecialization(publishingTemplateRequest, isNoTags))) : this.publishingTemplateCache.findFirstTemplate(PublishingTemplateKeyType.IDENTIFIER, publishingTemplateRequest.getTemplateId())).map(PublishingTemplate::getStatus).orElse("NOT FOUND");
    }

    public PublishingTemplateKeyGroups getPublishingTemplateKeyGroups(@NonNull String filterBySafeName) {
        ArrayList publishingTemplateKeyGroupList = new ArrayList(this.publishingTemplateCache.getPublishingTemplateKeyGroups().getPublishingTemplateKeyGroupList());
        Collections.sort(publishingTemplateKeyGroupList);
        PublishingTemplateKeyGroups publishingTemplateSafeNames = new PublishingTemplateKeyGroups(publishingTemplateKeyGroupList);
        PublishingTemplateKeyGroups filteredList = Strings.isValidAndNonBlank((String)filterBySafeName) ? new PublishingTemplateKeyGroups(publishingTemplateSafeNames.getPublishingTemplateKeyGroupList().stream().filter(key -> Strings.containsIgnoreCase((String)key.getSafeName().getKey(), (String)filterBySafeName)).collect(Collectors.toList())) : publishingTemplateSafeNames;
        return filteredList;
    }
}

