/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.publishing;

import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;

public class UserNotAuthorizedForPublishingException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static int NOT_LOGIN_USER = 1;
    public static int NOT_ACTIVE_USER = 2;
    public static int NOT_IN_PUBLISHING_GROUP = 4;

    public UserNotAuthorizedForPublishingException(int causeFlags, UserToken user) {
        super(UserNotAuthorizedForPublishingException.buildMessage(causeFlags, user));
    }

    public static String buildMessage(int causeFlags, UserToken user) {
        String indent1 = IndentedString.indentString((int)1);
        String indent2 = IndentedString.indentString((int)2);
        StringBuilder message = new StringBuilder(1024).append("\n").append("User not authorized for access to publishing REST APIs.").append("\n").append(indent1).append("Reasons follow:").append("\n");
        if ((NOT_LOGIN_USER & causeFlags) > 0) {
            message.append(indent2).append("User is not a login user.").append("\n");
        }
        if ((NOT_ACTIVE_USER & causeFlags) > 0) {
            message.append(indent2).append("User is not an active user.").append("\n");
        }
        if ((NOT_IN_PUBLISHING_GROUP & causeFlags) > 0) {
            message.append(indent2).append("User is not in the publishing group.").append("\n");
        }
        message.append(indent2).append("User:    ").append(user.getName()).append("\n").append(indent2).append("User Id: ").append(user.getUserId()).append("\n").append("\n");
        return message.toString();
    }
}

