/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.dataaccess;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.osee.define.operations.publisher.dataaccess.DataAccessOperationsBase;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.publishing.Cause;
import org.eclipse.osee.framework.core.publishing.DataAccessException;
import org.eclipse.osee.framework.core.publishing.IncludeDeleted;
import org.eclipse.osee.framework.jdk.core.type.Result;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class DataAccessOperationsImplArtifactReadOnlyImpl
extends DataAccessOperationsBase {
    private static DataAccessOperationsImplArtifactReadOnlyImpl dataAccessOperationsImplArtifactReadOnlyImpl = null;

    public static synchronized DataAccessOperationsImplArtifactReadOnlyImpl create(OrcsApi orcsApi) {
        return Objects.isNull(dataAccessOperationsImplArtifactReadOnlyImpl) ? (dataAccessOperationsImplArtifactReadOnlyImpl = new DataAccessOperationsImplArtifactReadOnlyImpl(Objects.requireNonNull(orcsApi))) : dataAccessOperationsImplArtifactReadOnlyImpl;
    }

    public static synchronized void free() {
        dataAccessOperationsImplArtifactReadOnlyImpl = null;
    }

    private DataAccessOperationsImplArtifactReadOnlyImpl(OrcsApi orcsApi) {
        super(orcsApi);
    }

    public Result<List<ArtifactReadable>, DataAccessException> getArtifactReadables(BranchSpecification branchSpecification, Collection<ArtifactId> artifactIdentifiers, Collection<String> guids, String artifactName, ArtifactTypeToken artifactTypeToken, TransactionId transactionId, IncludeDeleted includeDeleted) {
        try {
            QueryBuilder query = this.getBranchQuery(branchSpecification);
            if (Objects.nonNull(artifactIdentifiers) && !artifactIdentifiers.isEmpty()) {
                query = query.andIds(artifactIdentifiers);
            }
            if (Objects.nonNull(guids) && !guids.isEmpty()) {
                query = query.andGuids(guids);
            }
            if (includeDeleted.yes()) {
                query = query.includeDeletedArtifacts().includeDeletedAttributes();
            }
            if (Strings.isValidAndNonBlank((String)artifactName)) {
                query = query.andNameEquals(artifactName);
            }
            if (artifactTypeToken.isValid()) {
                query = query.andIsOfType(new ArtifactTypeToken[]{artifactTypeToken});
            }
            if (transactionId.isValid()) {
                query = query.fromTransaction(transactionId);
            }
            Result result = Result.ofValue((Object)query.getResults().getList());
            return result;
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }

    public Result<List<ArtifactReadable>, DataAccessException> getArtifactReadablesListOfParents(BranchSpecification branchSpecification, ArtifactId childArtifactId) {
        try {
            Result result = Result.ofValue((Object)this.getBranchQuery(branchSpecification).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Child, childArtifactId).getResults().getList());
            return result;
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }
}

