/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.dataaccess;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactSpecification;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.publishing.Cause;
import org.eclipse.osee.framework.core.publishing.DataAccessException;
import org.eclipse.osee.framework.core.publishing.DataAccessOperations;
import org.eclipse.osee.framework.core.publishing.IncludeDeleted;
import org.eclipse.osee.framework.core.publishing.ProcessRecursively;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.Result;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public abstract class DataAccessOperationsBase
implements DataAccessOperations {
    protected final OrcsTokenService orcsTokenService;
    protected final QueryFactory queryFactory;

    protected DataAccessOperationsBase(OrcsApi orcsApi) {
        Objects.requireNonNull(orcsApi);
        this.queryFactory = Objects.requireNonNull(orcsApi.getQueryFactory());
        this.orcsTokenService = Objects.requireNonNull(orcsApi.tokenService());
    }

    protected QueryBuilder getBranchQuery(BranchSpecification branchSpecification) {
        return branchSpecification.hasView() ? this.queryFactory.fromBranch(branchSpecification.getBranchId(), branchSpecification.getViewId()) : this.queryFactory.fromBranch(branchSpecification.getBranchId());
    }

    public Result<Map<String, List<String>>, DataAccessException> getApplicabilityNamedViewMap(BranchSpecification branchSpecification) {
        try {
            Result result = Result.ofValue((Object)this.queryFactory.applicabilityQuery().getNamedViewApplicabilityMap(BranchId.valueOf((Long)branchSpecification.getBranchId().getId()), branchSpecification.getViewId()));
            return result;
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }

    public Result<Map<ApplicabilityId, ApplicabilityToken>, DataAccessException> getApplicabilityTokenMap(BranchSpecification branchSpecification) {
        try {
            Result result = Result.ofValue(this.queryFactory.applicabilityQuery().getApplicabilityTokens(branchSpecification.getBranchId()).entrySet().stream().collect(Collectors.toMap(entrySet -> ApplicabilityId.valueOf((Long)((Long)entrySet.getKey())), Map.Entry::getValue)));
            return result;
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }

    public Result<List<ArtifactId>, DataAccessException> getArtifactIdentifiers(BranchSpecification branchSpecification, AttributeTypeId attributeTypeId, String attributeValue, TransactionId transactionId, IncludeDeleted includeDeleted) {
        try {
            QueryBuilder query = this.getBranchQuery(branchSpecification);
            switch ((Objects.nonNull(attributeTypeId) && attributeTypeId.isValid() ? 1 : 0) + (Objects.nonNull(attributeValue) ? 2 : 0)) {
                case 1: {
                    query = query.andExists(new AttributeTypeToken[]{AttributeTypeToken.valueOf((Long)attributeTypeId.getId())});
                    break;
                }
                case 3: {
                    query = query.andAttributeIs(AttributeTypeToken.valueOf((Long)attributeTypeId.getId()), attributeValue);
                }
            }
            if (includeDeleted.yes()) {
                query = query.includeDeletedArtifacts().includeDeletedAttributes();
            }
            if (transactionId.isValid()) {
                query = query.fromTransaction(transactionId);
            }
            Result result = Result.ofValue((Object)query.asArtifactIds());
            return result;
        }
        catch (ItemDoesNotExist e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.NOT_FOUND, (Throwable)e)));
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }

    public Result<List<ArtifactId>, DataAccessException> getArtifactIdentifiersFilterByTxCommentForChange(BranchSpecification branchSpecification) {
        try {
            Result result = Result.ofValue((Object)this.getBranchQuery(branchSpecification).andTxComment("(E|P)R\\s?\\d{5}", CoreAttributeTypes.NameWord).asArtifactIds());
            return result;
        }
        catch (ItemDoesNotExist e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.NOT_FOUND, (Throwable)e)));
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }

    public Result<ArtifactReadable, DataAccessException> getArtifactReadableByIdentifier(ArtifactSpecification artifactSpecification) {
        return this.getArtifactReadables((BranchSpecification)artifactSpecification, List.of(artifactSpecification.getArtifactId()), List.of(), "", ArtifactTypeToken.SENTINEL, TransactionId.SENTINEL, IncludeDeleted.NO).filterValue(Predicate.not(List::isEmpty)).mapValue(artifacts -> (ArtifactReadable)artifacts.get(0)).orWhenEmpty(() -> Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.NOT_FOUND))));
    }

    public Result<List<ArtifactToken>, DataAccessException> getArtifactTokens(BranchSpecification branchSpecification, Collection<ArtifactId> artifactIdentifiers, ArtifactTypeToken artifactTypeToken, RelationTypeSide relationTypeSide) {
        try {
            QueryBuilder query = this.queryFactory.fromBranch(BranchId.valueOf((Long)branchSpecification.getBranchId().getId()));
            if (Objects.nonNull(artifactIdentifiers) && !artifactIdentifiers.isEmpty()) {
                query = query.andIds(artifactIdentifiers);
            }
            if (artifactTypeToken.isValid()) {
                query = query.andTypeEquals(new ArtifactTypeToken[]{artifactTypeToken});
            }
            if (relationTypeSide.isValid()) {
                query = query.andRelationExists(relationTypeSide);
            }
            Result result = Result.ofValue((Object)query.asArtifactTokens());
            return result;
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }

    public Result<Branch, DataAccessException> getBranchByIdentifier(BranchId branchId) {
        try {
            Result result = Result.ofValue((Object)((Branch)((BranchQuery)this.queryFactory.branchQuery().andId(branchId)).getResults().getExactlyOne()));
            return result;
        }
        catch (MultipleItemsExist e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.MORE_THAN_ONE, (Throwable)e)));
        }
        catch (ItemDoesNotExist e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.NOT_FOUND, (Throwable)e)));
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }

    public Result<List<ArtifactId>, DataAccessException> getBranchViewsForApplicability(BranchSpecification branchSpecification, ApplicabilityId applicabilityId) {
        try {
            return Result.ofValue((Object)this.queryFactory.applicabilityQuery().getBranchViewsForApplicability(branchSpecification.getBranchId(), applicabilityId));
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }

    public Result<List<ArtifactId>, DataAccessException> getParentArtifactIdentifiers(BranchSpecification branchSpecification, ArtifactId artifactId, ProcessRecursively processRecursively) {
        try {
            QueryBuilder query = this.getBranchQuery(branchSpecification);
            query = processRecursively.yes() ? query.andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Parent, artifactId) : query.andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, artifactId);
            Result result = Result.ofValue((Object)query.asArtifactIds());
            return result;
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }

    public Result<List<ArtifactId>, DataAccessException> getChildrenArtifactIdentifiers(BranchSpecification branchSpecification, ArtifactId parent, ArtifactTypeToken artifactTypeToken, AttributeTypeId attributeTypeId, String value, ProcessRecursively processRecursively) {
        try {
            QueryBuilder query = this.getBranchQuery(branchSpecification);
            if (artifactTypeToken.isValid()) {
                query = query.andIsOfType(new ArtifactTypeToken[]{artifactTypeToken});
            }
            if (attributeTypeId.isValid() && Strings.isValidAndNonBlank((String)value)) {
                query = query.andAttributeIs(AttributeTypeToken.valueOf((Long)attributeTypeId.getId()), value);
            }
            query = processRecursively.yes() ? query.andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, parent) : query.andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, parent);
            Result result = Result.ofValue((Object)query.asArtifactIds());
            return result;
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }

    public Result<List<ArtifactId>, DataAccessException> getWorkFlowArtifactIdentifiers(ArtifactId artifactId) {
        try {
            Result result = Result.ofValue((Object)this.queryFactory.fromBranch((BranchId)CoreBranches.COMMON).andRelatedTo(AtsRelationTypes.Goal_Goal, artifactId).asArtifactIds());
            return result;
        }
        catch (Exception e) {
            return Result.ofError((Object)((Object)new DataAccessException((CharSequence)new Object(){}.getClass().getEnclosingMethod().getName(), Cause.ERROR, (Throwable)e)));
        }
    }
}

