/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.predicate;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.search.artifact.PredicateHandler;
import org.eclipse.osee.orcs.rest.internal.search.artifact.predicate.PredicateHandlerUtil;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMethod;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class ExistenceTypePredicateHandler
implements PredicateHandler {
    @Override
    public QueryBuilder handle(OrcsApi orcsApi, QueryBuilder builder, Predicate predicate) {
        block10: {
            String existsType;
            List values;
            List typeParameters;
            OrcsTokenService tokenService;
            block11: {
                tokenService = orcsApi.tokenService();
                if (!predicate.getType().isOfType(new SearchMethod[]{SearchMethod.EXISTS_TYPE, SearchMethod.NOT_EXISTS_TYPE})) {
                    throw new OseeArgumentException("This predicate handler only supports [%s] and [%s]", new Object[]{SearchMethod.EXISTS_TYPE, SearchMethod.NOT_EXISTS_TYPE});
                }
                typeParameters = predicate.getTypeParameters();
                values = predicate.getValues();
                Conditions.checkNotNullOrEmpty((Collection)typeParameters, (String)"typeParameters");
                Conditions.checkNotNull((Object)values, (String)"values");
                if (typeParameters.size() < 1) break block10;
                existsType = (String)typeParameters.get(0);
                if (!"attrType".equals(existsType)) break block11;
                Collection<AttributeTypeToken> attributeTypes = PredicateHandlerUtil.getAttributeTypes(values);
                if (attributeTypes.isEmpty()) break block10;
                if (this.checkExists(predicate.getType())) {
                    builder.andExists(attributeTypes);
                } else {
                    builder.andNotExists(attributeTypes);
                }
                break block10;
            }
            if ("relType".equals(existsType)) {
                for (RelationTypeToken rt : PredicateHandlerUtil.getIRelationTypes(values, tokenService)) {
                    if (this.checkExists(predicate.getType())) {
                        builder.andRelationExists(rt);
                        continue;
                    }
                    builder.andRelationNotExists(rt);
                }
            } else if ("relTypeSide".equals(existsType)) {
                RelationSide side = ((String)typeParameters.get(1)).equals("A") ? RelationSide.SIDE_A : RelationSide.SIDE_B;
                for (RelationTypeToken rt : PredicateHandlerUtil.getIRelationTypes(values, tokenService)) {
                    RelationTypeSide relationTypeSide = new RelationTypeSide(rt, side);
                    if (this.checkExists(predicate.getType())) {
                        builder.andRelationExists(relationTypeSide);
                        continue;
                    }
                    builder.andRelationNotExists(rt);
                }
            }
        }
        return builder;
    }

    private boolean checkExists(SearchMethod method) {
        return method == SearchMethod.EXISTS_TYPE;
    }
}

