/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthLog;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthUtils;

public class RemoteHealthLog {
    private final String remoteServerName;
    private final String appServerDir;
    private final String serverUri;
    private final OrcsApi orcsApi;
    private HealthLog healthLog;
    private String errorMsg = "";

    public RemoteHealthLog(String remoteServerName, String appServerDir, String serverUri, OrcsApi orcsApi) {
        this.remoteServerName = remoteServerName;
        this.appServerDir = appServerDir;
        this.serverUri = serverUri;
        this.orcsApi = orcsApi;
    }

    public void fetchRemoteHealthLog() {
        String logUrl = String.valueOf(this.remoteServerName) + "/health/log?appServerDir=" + this.appServerDir + "&serverUri=" + this.serverUri;
        this.healthLog = HealthUtils.makeHttpRequest(logUrl, (String)this.orcsApi.userService().getUser().getLoginIds().get(0), HealthLog.class, new HealthLog());
        this.errorMsg = HealthUtils.getErrorMsg();
    }

    public HealthLog getHealthLog() {
        return this.healthLog;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }
}

