/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthUtils;

public class HealthJava {
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private final OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
    private JdbcClient jdbcClient;
    private String auth = "";
    private String vmName = "";
    private String vmVendor = "";
    private String vmVersion = "";
    private String vmSpecVersion = "";
    private String classPath = "";
    private String libraryPath = "";
    private String osName = "";
    private String osVersion = "";
    private String osArch = "";
    private final List<String> processArgs = new ArrayList<String>();
    private final List<String> processes = new ArrayList<String>();

    public HealthJava() {
    }

    public HealthJava(JdbcClient jdbcClient, OrcsApi orcsApi) {
        this.jdbcClient = jdbcClient;
        this.auth = (String)orcsApi.userService().getUser().getLoginIds().get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setJavaInfo() {
        this.vmName = this.runtimeMXBean.getVmName();
        this.vmVendor = this.runtimeMXBean.getVmVendor();
        this.vmVersion = this.runtimeMXBean.getVmVersion();
        this.vmSpecVersion = this.runtimeMXBean.getSpecVersion();
        this.classPath = this.runtimeMXBean.getClassPath();
        this.libraryPath = this.runtimeMXBean.getLibraryPath();
        this.osName = this.osMXBean.getName();
        this.osVersion = this.osMXBean.getVersion();
        this.osArch = this.osMXBean.getArch();
        List<String> inputArguments = this.runtimeMXBean.getInputArguments();
        Iterator<String> iterator = inputArguments.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (!Lib.isWindows()) break;
                String psResults = "";
                if (HealthUtils.isCurlServerSet(this.jdbcClient)) {
                    psResults = HealthUtils.runCurlExecFromCurlServer("ps%20-ef", this.jdbcClient, this.auth);
                }
                if (Strings.isInValid((String)psResults)) {
                    psResults = "ps -ef command is not available for windows \n";
                }
                this.processes.add(psResults);
                return;
            }
            String arg = iterator.next();
            this.processArgs.add(arg);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("ps", "-ef");
        try {
            Process process;
            block20: {
                process = processBuilder.start();
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    InputStream inputStream = process.getInputStream();
                    try {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                if (!line.contains("java")) continue;
                                this.processes.add(line);
                            }
                        }
                        if (inputStream == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            process.waitFor();
            process.destroy();
            return;
        }
        catch (Exception e) {
            this.processes.add("Error executing ps -ef: " + e.getMessage());
        }
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public String getVmSpecVersion() {
        return this.vmSpecVersion;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public List<String> getProcessArgs() {
        return this.processArgs;
    }

    public List<String> getProcesses() {
        return this.processes;
    }
}

