/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.metrics;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.rest.metrics.DevProgressItemId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;

public final class DevProgressMetrics
implements StreamingOutput {
    private final AtsApi atsApi;
    private String programVersion;
    private final String targetVersion;
    private final Date startDate;
    private final Date endDate;
    private final boolean allTime;
    private final Pattern noArtifactRegex = Pattern.compile("(?:Test|Code)\\s\"([^\"]+)\"\\sfor\\s([^\"\\n]+)");
    private final List<ArtifactTypeToken> validMetricsTypes = Arrays.asList(CoreArtifactTypes.SoftwareRequirementMsWord, CoreArtifactTypes.SoftwareRequirementPlainText, CoreArtifactTypes.SoftwareRequirementFunctionMsWord, CoreArtifactTypes.SoftwareRequirementProcedureMsWord, CoreArtifactTypes.ImplementationDetailsMsWord, CoreArtifactTypes.ImplementationDetailsPlainText, CoreArtifactTypes.ImplementationDetailsProcedureMsWord, CoreArtifactTypes.ImplementationDetailsFunctionMsWord);
    private ExcelXmlWriter writer;
    private BranchId baselineBranch;
    Pattern UI_DELETED = Pattern.compile("^.*\\(Deleted\\)$");
    Pattern UI_NAME = Pattern.compile("\\{.*\\}");
    private final DevProgressItemId[] actionColumns = new DevProgressItemId[]{DevProgressItemId.ACT, DevProgressItemId.ActionName, DevProgressItemId.Program, DevProgressItemId.Build, DevProgressItemId.Date, DevProgressItemId.Created, DevProgressItemId.WorkType, DevProgressItemId.TW, DevProgressItemId.State, DevProgressItemId.Analyze, DevProgressItemId.Authorize, DevProgressItemId.Implement, DevProgressItemId.Verify, DevProgressItemId.Demonstrate, DevProgressItemId.Complete, DevProgressItemId.Cancelled, DevProgressItemId.TotalCount, DevProgressItemId.CompletedCount, DevProgressItemId.CancelledCount, DevProgressItemId.TotalAddModCount, DevProgressItemId.CompletedAddModCount, DevProgressItemId.CancelledAddModCount, DevProgressItemId.TotalDeletedCount, DevProgressItemId.CompletedDeletedCount, DevProgressItemId.CancelledDeletedCount};

    public DevProgressMetrics(AtsApi atsApi, String targetVersion, Date startDate, Date endDate, boolean allTime) {
        this.atsApi = atsApi;
        this.programVersion = null;
        this.targetVersion = targetVersion;
        this.startDate = startDate;
        this.endDate = endDate;
        this.allTime = allTime;
    }

    public void write(OutputStream output) {
        try {
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            this.writeReport();
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            try {
                this.writer.endWorkbook();
            }
            catch (IOException ex1) {
                throw new WebApplicationException((Throwable)ex1);
            }
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeReport() throws IOException {
        List<IAtsAction> actionableItems = this.getDatedWorkflows();
        if (!actionableItems.isEmpty()) {
            this.writer.startSheet("Non-Periodic Data", this.actionColumns.length);
            this.fillActionableData(actionableItems, this.actionColumns.length);
        }
    }

    private List<IAtsAction> getDatedWorkflows() {
        ArtifactToken versionId = this.atsApi.getQueryService().getArtifactFromTypeAndAttribute(AtsArtifactTypes.Version, (AttributeTypeToken)CoreAttributeTypes.Name, this.targetVersion, (BranchId)this.atsApi.getAtsBranch());
        Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)versionId);
        this.baselineBranch = version.getBaselineBranch();
        Collection workflowArts = this.atsApi.getVersionService().getTargetedForTeamWorkflows((IAtsVersion)version);
        ArrayList<IAtsAction> actionableItems = new ArrayList<IAtsAction>();
        for (IAtsTeamWorkflow workflow : workflowArts) {
            try {
                if (actionableItems.contains(workflow.getParentAction()) || !workflow.isWorkType(WorkType.Requirements) && !workflow.isWorkType(WorkType.Code) && !workflow.isWorkType(WorkType.Test)) continue;
                if (this.allTime) {
                    actionableItems.add(workflow.getParentAction());
                    continue;
                }
                if (!workflow.getCreatedDate().before(this.endDate) || workflow.getStateDefinition().getName().equals("Demonstrate") && workflow.getCreatedDate().before(this.startDate) || workflow.isCompleted() && workflow.getCompletedDate() != null && workflow.getCompletedDate().before(this.startDate) || workflow.isCancelled() && workflow.getCancelledDate() != null && workflow.getCreatedDate().before(this.startDate)) continue;
                actionableItems.add(workflow.getParentAction());
            }
            catch (Exception exception) {}
        }
        this.programVersion = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition).getName();
        return actionableItems;
    }

    private void fillActionableData(List<IAtsAction> actionableItems, int numColumns) throws IOException {
        Object[] buffer = new Object[numColumns];
        int i = 0;
        while (i < numColumns) {
            buffer[i] = this.actionColumns[i].getDisplayName();
            ++i;
        }
        this.writer.writeRow(buffer);
        for (IAtsAction actionItem : actionableItems) {
            buffer[0] = actionItem.getAtsId();
            buffer[1] = actionItem.getName();
            buffer[2] = this.programVersion;
            buffer[3] = this.targetVersion;
            buffer[4] = this.endDate;
            Date createdDate = new Date();
            for (IAtsTeamWorkflow teamWorkflow : actionItem.getTeamWorkflows()) {
                if (!teamWorkflow.getCreatedDate().before(createdDate)) continue;
                createdDate = teamWorkflow.getCreatedDate();
            }
            buffer[5] = createdDate;
            this.fillTeamWfData(buffer, this.endDate, actionItem);
        }
        if (actionableItems.isEmpty()) {
            buffer[0] = String.format("No Actions Found for Program: [%s], Target Version: [%s]", this.programVersion, this.targetVersion);
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        this.writer.endSheet();
    }

    private void fillTeamWfData(Object[] buffer, Date rowDate, IAtsAction actionItem) {
        IAtsTeamWorkflow testWorkflow;
        IAtsTeamWorkflow codeWorkflow;
        Collection allTeamWorkflows = actionItem.getTeamWorkflows();
        ArrayList<IAtsTeamWorkflow> reqWorkflows = new ArrayList<IAtsTeamWorkflow>();
        for (IAtsTeamWorkflow teamWf : allTeamWorkflows) {
            if (!teamWf.isWorkType(WorkType.Requirements) || !teamWf.isValid() || teamWf.isCancelled()) continue;
            reqWorkflows.add(teamWf);
        }
        for (IAtsTeamWorkflow reqWorkflow : reqWorkflows) {
            codeWorkflow = IAtsTeamWorkflow.SENTINEL;
            testWorkflow = IAtsTeamWorkflow.SENTINEL;
            allTeamWorkflows.remove(reqWorkflow);
            Collection derivedTo = this.atsApi.getRelationResolver().getRelated((IAtsObject)reqWorkflow, AtsRelationTypes.Derive_To);
            for (ArtifactToken subWorkflows : derivedTo) {
                IAtsTeamWorkflow teamWf = this.atsApi.getWorkItemService().getTeamWf(subWorkflows);
                if (teamWf.isWorkType(WorkType.Code) && teamWf.isValid() && !teamWf.isCancelled()) {
                    codeWorkflow = teamWf;
                    allTeamWorkflows.remove(codeWorkflow);
                    continue;
                }
                if (!teamWf.isWorkType(WorkType.Test) || !teamWf.isValid() || teamWf.isCancelled()) continue;
                testWorkflow = teamWf;
                allTeamWorkflows.remove(testWorkflow);
            }
            this.writeCodeWf(buffer, rowDate, codeWorkflow);
            this.writeTestReqWf(buffer, rowDate, testWorkflow, reqWorkflow);
        }
        for (IAtsTeamWorkflow teamWf : allTeamWorkflows) {
            codeWorkflow = IAtsTeamWorkflow.SENTINEL;
            testWorkflow = IAtsTeamWorkflow.SENTINEL;
            if (teamWf.isWorkType(WorkType.Code) && teamWf.isValid() && !teamWf.isCancelled()) {
                codeWorkflow = teamWf;
                this.writeCodeWf(buffer, rowDate, codeWorkflow);
                continue;
            }
            if (!teamWf.isWorkType(WorkType.Test) || !teamWf.isValid() || teamWf.isCancelled()) continue;
            testWorkflow = teamWf;
            this.writeTestReqWf(buffer, rowDate, testWorkflow, IAtsTeamWorkflow.SENTINEL);
        }
    }

    private void writeCodeWf(Object[] buffer, Date rowDate, IAtsTeamWorkflow codeWorkflow) {
        if (!codeWorkflow.equals(IAtsTeamWorkflow.SENTINEL) && !this.getStateAtDate((IAtsWorkItem)codeWorkflow, rowDate).isEmpty()) {
            double scale = Math.pow(10.0, 2.0);
            Collection<IAtsTask> tasks = this.getTaskList(codeWorkflow, rowDate);
            double[] deletedCounts = this.getDeletedTaskCount(codeWorkflow, rowDate, tasks);
            buffer[6] = "Code";
            this.calculateStates(buffer, codeWorkflow, rowDate);
            double tasksCompleted = this.getTaskCompleted(codeWorkflow, rowDate, tasks);
            int tasksCancelled = this.getTaskCancelled(codeWorkflow, rowDate, tasks);
            double addModStat = (double)tasks.size() - deletedCounts[0];
            double addModComp = tasksCompleted - deletedCounts[1];
            double addModCanc = (double)tasksCancelled - deletedCounts[2];
            buffer[16] = tasks.size();
            buffer[17] = (double)Math.round(tasksCompleted * scale) / scale;
            buffer[18] = tasksCancelled;
            buffer[19] = (double)Math.round(addModStat * scale) / scale;
            buffer[20] = (double)Math.round(addModComp * scale) / scale;
            buffer[21] = (double)Math.round(addModCanc * scale) / scale;
            buffer[22] = deletedCounts[0];
            buffer[23] = deletedCounts[1];
            buffer[24] = deletedCounts[2];
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
    }

    private void writeTestReqWf(Object[] buffer, Date rowDate, IAtsTeamWorkflow testWorkflow, IAtsTeamWorkflow reqWorkflow) {
        double scale = Math.pow(10.0, 2.0);
        int reqTasks = 0;
        double reqAddModTasks = 0.0;
        double reqDeletedTasks = 0.0;
        if (!testWorkflow.equals(IAtsTeamWorkflow.SENTINEL) && !this.getStateAtDate((IAtsWorkItem)testWorkflow, rowDate).isEmpty()) {
            Collection<IAtsTask> tasks = this.getTaskList(testWorkflow, rowDate);
            double[] deletedCounts = this.getDeletedTaskCount(testWorkflow, rowDate, tasks);
            buffer[6] = "Test";
            this.calculateStates(buffer, testWorkflow, rowDate);
            reqTasks = tasks.size();
            reqAddModTasks = (double)tasks.size() - deletedCounts[0];
            reqDeletedTasks = deletedCounts[0];
            double tasksCompleted = this.getTaskCompleted(testWorkflow, rowDate, tasks);
            int tasksCancelled = this.getTaskCancelled(testWorkflow, rowDate, tasks);
            double addModStat = (double)tasks.size() - deletedCounts[0];
            double addModComp = tasksCompleted - deletedCounts[1];
            double addModCanc = (double)tasksCancelled - deletedCounts[2];
            buffer[16] = tasks.size();
            buffer[17] = tasksCompleted;
            buffer[18] = tasksCancelled;
            buffer[19] = (double)Math.round(addModStat * scale) / scale;
            buffer[20] = (double)Math.round(addModComp * scale) / scale;
            buffer[21] = (double)Math.round(addModCanc * scale) / scale;
            buffer[22] = deletedCounts[0];
            buffer[23] = deletedCounts[1];
            buffer[24] = deletedCounts[2];
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        if (!reqWorkflow.equals(IAtsTeamWorkflow.SENTINEL) && !this.getStateAtDate((IAtsWorkItem)reqWorkflow, rowDate).isEmpty()) {
            String stateAtDate = this.getStateAtDate((IAtsWorkItem)reqWorkflow, rowDate);
            buffer[6] = "Requirements";
            this.calculateStates(buffer, reqWorkflow, rowDate);
            buffer[16] = reqTasks;
            buffer[19] = reqAddModTasks;
            buffer[22] = reqDeletedTasks;
            if (stateAtDate.contains("Complete")) {
                buffer[17] = reqTasks;
                buffer[18] = 0;
                buffer[20] = reqAddModTasks;
                buffer[21] = 0;
                buffer[23] = reqDeletedTasks;
                buffer[24] = 0;
            } else if (stateAtDate.equals("Cancelled")) {
                buffer[17] = 0;
                buffer[18] = reqTasks;
                buffer[20] = 0;
                buffer[21] = reqAddModTasks;
                buffer[23] = 0;
                buffer[24] = reqDeletedTasks;
            } else {
                buffer[17] = 0;
                buffer[18] = 0;
                buffer[20] = 0;
                buffer[21] = 0;
                buffer[23] = 0;
                buffer[24] = 0;
            }
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void calculateStates(Object[] buffer, IAtsTeamWorkflow workflow, Date rowDate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[16] lbl130 : CaseStatement: default:\u000a, @NONE, blocks:[16] lbl130 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getStateAtDate(IAtsWorkItem teamWf, Date iterationDate) {
        if (this.allTime) {
            return teamWf.getCurrentStateName();
        }
        String stateName = teamWf.getCurrentStateName();
        Date stateStartDate = new GregorianCalendar(1916, 7, 15).getTime();
        try {
            Date newStateStartDate = this.atsApi.getWorkItemService().getStateStartedData(teamWf, stateName).getDate();
            if (newStateStartDate.after(iterationDate)) {
                for (String visitedState : teamWf.getLog().getVisitedStateNames()) {
                    newStateStartDate = this.atsApi.getWorkItemService().getStateStartedData(teamWf, visitedState).getDate();
                    if (!newStateStartDate.before(iterationDate) || !newStateStartDate.after(stateStartDate)) continue;
                    stateName = visitedState;
                    stateStartDate = newStateStartDate;
                }
            }
        }
        catch (Exception exception) {}
        return stateName;
    }

    private Date getStateStartedDate(IAtsWorkItem teamWf, Date iterationDate, String stateName) {
        try {
            IAtsLogItem stateStartedData = this.atsApi.getWorkItemService().getStateStartedData(teamWf, stateName);
            if (stateStartedData.getDate().before(iterationDate)) {
                return stateStartedData.getDate();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private Date getStateStartedDate(IAtsWorkItem teamWf, String stateName) {
        try {
            IAtsLogItem stateStartedData = this.atsApi.getWorkItemService().getStateStartedData(teamWf, stateName);
            return stateStartedData.getDate();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Collection<IAtsTask> getTaskList(IAtsTeamWorkflow teamWorkflow, Date iterationDate) {
        ArrayList<IAtsTask> tasks = new ArrayList<IAtsTask>();
        ArrayList<String> taskUINames = new ArrayList<String>();
        for (IAtsTask task : this.atsApi.getTaskService().getTasks(teamWorkflow)) {
            Matcher matcher;
            String taskUIName;
            block6: {
                taskUIName = task.getName();
                if (taskUIName.contains("Unknown Name") || !task.getCreatedDate().before(iterationDate) || taskUINames.contains(taskUIName)) continue;
                ArtifactId artRef = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactReference, (Object)ArtifactId.SENTINEL);
                if (artRef.isValid()) {
                    try {
                        ArtifactTypeToken artifactType = this.atsApi.getQueryService().getArtifact(artRef, this.baselineBranch, DeletionFlag.INCLUDE_DELETED).getArtifactType();
                        if (this.validMetricsTypes.contains(artifactType)) {
                            taskUINames.add(taskUIName);
                            tasks.add(task);
                            continue;
                        }
                        if (artifactType.isValid()) {
                        }
                        break block6;
                    }
                    catch (Exception exception) {
                        Matcher m = this.UI_NAME.matcher(taskUIName);
                        if (!m.find()) continue;
                        taskUINames.add(taskUIName);
                        tasks.add(task);
                    }
                    continue;
                }
            }
            if (!(matcher = this.noArtifactRegex.matcher(taskUIName)).find()) continue;
            taskUINames.add(taskUIName);
            tasks.add(task);
        }
        return tasks;
    }

    private double[] getDeletedTaskCount(IAtsTeamWorkflow teamWorkflow, Date iterationDate, Collection<IAtsTask> tasks) {
        double[] deletedCounts = new double[3];
        double deletedCount = 0.0;
        double deletedCompleteCount = 0.0;
        double deletedCancelledCount = 0.0;
        for (IAtsTask task : tasks) {
            Matcher m;
            if (task.getCreatedDate().after(iterationDate) || !(m = this.UI_DELETED.matcher(task.getName())).find()) continue;
            try {
                deletedCount += 1.0;
                StateDefinition state = this.stateNameToDefinition((IAtsWorkItem)task, iterationDate);
                if (state.getRecommendedPercentComplete() != null && state.getRecommendedPercentComplete() > 0) {
                    deletedCompleteCount += (double)(state.getRecommendedPercentComplete() / 100);
                    continue;
                }
                if (task.isCompleted() && (this.allTime || task.getCompletedDate().before(iterationDate))) {
                    deletedCompleteCount += 1.0;
                    continue;
                }
                if (!task.isCancelled() || !this.allTime && !task.getCancelledDate().before(iterationDate)) continue;
                deletedCancelledCount += 1.0;
            }
            catch (Exception exception) {}
        }
        deletedCounts[0] = deletedCount;
        deletedCounts[1] = deletedCompleteCount;
        deletedCounts[2] = deletedCancelledCount;
        return deletedCounts;
    }

    private double getTaskCompleted(IAtsTeamWorkflow teamWorkflow, Date iterationDate, Collection<IAtsTask> tasks) {
        double completedTasks = 0.0;
        for (IAtsTask task : tasks) {
            try {
                StateDefinition state = this.stateNameToDefinition((IAtsWorkItem)task, iterationDate);
                if (state == null) {
                    throw new OseeCoreException("In DevProgressMetrics.getTaskCompleted, the local variable \"state\" is null which is dereferenced", new Object[0]);
                }
                if (state.getRecommendedPercentComplete() != null && state.getRecommendedPercentComplete() > 0 && !state.getName().equals("Cancelled")) {
                    completedTasks += (double)state.getRecommendedPercentComplete().intValue() / 100.0;
                    continue;
                }
                if ((!task.isCompleted() || !task.getCompletedDate().before(iterationDate)) && !state.getName().equals("No_Change")) continue;
                completedTasks += 1.0;
            }
            catch (Exception exception) {}
        }
        return completedTasks;
    }

    private StateDefinition stateNameToDefinition(IAtsWorkItem item, Date iterationDate) {
        if (this.allTime) {
            return item.getStateDefinition();
        }
        String stateAtDate = this.getStateAtDate(item, iterationDate);
        if (stateAtDate.equals(item.getCurrentStateName())) {
            return item.getStateDefinition();
        }
        for (StateDefinition state : item.getWorkDefinition().getStates()) {
            if (!state.getName().equals(stateAtDate)) continue;
            return state;
        }
        return null;
    }

    private int getTaskCancelled(IAtsTeamWorkflow teamWorkflow, Date iterationDate, Collection<IAtsTask> tasks) {
        ArrayList<IAtsTask> iterationTasks = new ArrayList<IAtsTask>();
        for (IAtsTask task : tasks) {
            try {
                if (!task.isCancelled() || !task.getCancelledDate().before(iterationDate)) continue;
                iterationTasks.add(task);
            }
            catch (Exception exception) {}
        }
        return iterationTasks.size();
    }
}

