/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreColumn;
import org.eclipse.osee.ats.api.column.AtsCoreColumnToken;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.AtsWorldEndpointApi;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.api.workflow.world.WorldResults;
import org.eclipse.osee.ats.core.workflow.util.AtsWorkItemAtsIdSorter;
import org.eclipse.osee.ats.rest.AtsApiServer;
import org.eclipse.osee.ats.rest.internal.world.AtsWorldResultRowOperation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.result.ResultRows;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

@Path(value="world")
public class AtsWorldEndpointImpl
implements AtsWorldEndpointApi {
    private final AtsApiServer atsApiServer;
    private final AtsApi atsApi;
    public static final List<String> namespaces = Arrays.asList("WorldXViewer", "BacklogXViewer", "SprintXViewer", "GoalXViewer", "TaskXViewer");

    public AtsWorldEndpointImpl(AtsApiServer atsApiServer) {
        this.atsApiServer = atsApiServer;
        this.atsApi = atsApiServer;
    }

    @GET
    @Path(value="column")
    @Produces(value={"application/json"})
    public Collection<AtsCoreColumn> getColumns() {
        Collection columns = this.atsApi.getColumnService().getColumns();
        return columns;
    }

    @GET
    @Path(value="columnjson")
    @Produces(value={"application/json"})
    public String getColumnsJson() {
        return this.atsApi.getColumnService().getColumnsJson();
    }

    @GET
    @Path(value="cust/global")
    @Produces(value={"application/json"})
    public Collection<CustomizeData> getCustomizationsGlobal() {
        LinkedList<CustomizeData> datas = new LinkedList<CustomizeData>();
        for (String namespace : namespaces) {
            datas.addAll(this.atsApi.getStoreService().getCustomizationsGlobal(namespace));
        }
        return datas;
    }

    @GET
    @Path(value="cust")
    @Produces(value={"application/json"})
    public Collection<CustomizeData> getCustomizations() {
        LinkedList<CustomizeData> datas = new LinkedList<CustomizeData>();
        for (String namespace : namespaces) {
            datas.addAll(this.atsApi.getStoreService().getCustomizations(namespace));
        }
        return datas;
    }

    @GET
    @Path(value="my/{userArtId}")
    @Produces(value={"application/json"})
    public Collection<IAtsWorkItem> getMyWorld(@PathParam(value="userArtId") ArtifactId userArtId) {
        ArtifactReadable userArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(userArtId);
        AtsUser userById = this.atsApiServer.getUserService().getUserByUserId((String)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserId));
        Collection myWorldItems = this.atsApiServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAssignee(new AtsUser[]{userById}).getItems(IAtsWorkItem.class);
        return myWorldItems;
    }

    @GET
    @Path(value="my/{userArtId}/ui")
    @Produces(value={"text/html"})
    public String getMyWorldUI(@PathParam(value="userArtId") ArtifactId userArtId) {
        StringBuilder sb = new StringBuilder();
        ArtifactReadable userArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(userArtId);
        AtsUser userById = this.atsApiServer.getUserService().getUserByUserId((String)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserId));
        Collection myWorldItems = this.atsApiServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAssignee(new AtsUser[]{userById}).getItems(IAtsWorkItem.class);
        this.getDefaultUiTable(sb, "My World - " + userById.getName(), myWorldItems);
        return sb.toString();
    }

    @GET
    @Path(value="my/{userArtId}/ui/{customizeGuid}")
    @Produces(value={"text/html"})
    public String getMyWorldUICustomized(@PathParam(value="userArtId") ArtifactId userArtId, @PathParam(value="customizeGuid") String customizeGuid) {
        ArtifactReadable userArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(userArtId);
        AtsUser userById = this.atsApiServer.getUserService().getUserByUserId((String)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserId));
        Conditions.checkNotNull((Object)userById, (String)("User by Id " + userArtId));
        CustomizeData customization = this.atsApiServer.getStoreService().getCustomizationByGuid(customizeGuid);
        if (customization == null) {
            return AHTML.simplePage((String)String.format("No customization found with id [%s]", customizeGuid));
        }
        Collection myWorldItems = this.atsApiServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAssignee(new AtsUser[]{userById}).getItems(IAtsWorkItem.class);
        String table = AtsWorldEndpointImpl.getCustomizedTable(this.atsApiServer, "MY World - " + userById.getName() + " - Customization: " + customization.getName(), customization, myWorldItems);
        return table;
    }

    @GET
    @Path(value="coll/{collectorId}")
    @Produces(value={"application/json"})
    public Collection<IAtsWorkItem> getCollection(@PathParam(value="collectorId") ArtifactId collectorId) {
        ArtifactReadable collectorArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(collectorId);
        return this.getCollection(collectorArt);
    }

    private List<IAtsWorkItem> getCollection(ArtifactReadable collectorArt) {
        ArrayList<IAtsWorkItem> myWorldItems = new ArrayList<IAtsWorkItem>();
        if (collectorArt != null) {
            if (collectorArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                myWorldItems.addAll(this.atsApiServer.getWorkItemService().getWorkItems((Collection)collectorArt.getRelated(AtsRelationTypes.Goal_Member).getList()));
            } else if (collectorArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
                myWorldItems.addAll(this.atsApiServer.getWorkItemService().getWorkItems((Collection)collectorArt.getRelated(AtsRelationTypes.AgileSprintToItem_AtsItem).getList()));
            }
        }
        return myWorldItems;
    }

    @GET
    @Path(value="coll/{collectorId}/json/{customizeGuid}")
    @Produces(value={"application/json"})
    public WorldResults getCollectionJsonCustomized(@PathParam(value="collectorId") ArtifactId collectorId, @PathParam(value="customizeGuid") String customizeGuid) {
        CustomizeData customization = this.atsApiServer.getStoreService().getCustomizationByGuid(customizeGuid);
        ArtifactReadable collectorArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(collectorId);
        List<IAtsWorkItem> collectorItems = this.getCollection(collectorArt);
        Collections.sort(collectorItems, new AtsWorkItemAtsIdSorter());
        WorldResults wr = new WorldResults();
        wr.setCollectorArt(collectorArt.getToken());
        wr.setAtsId(this.atsApi.getAtsId((ArtifactToken)collectorArt));
        XResultData rd = wr.getRd();
        rd.logf("Collector: %s", new Object[]{collectorArt.toStringWithId()});
        if (customization == null) {
            rd.errorf("Customization %s does not exist", new Object[]{customizeGuid});
        } else {
            rd.logf("Customization: %s - %s", new Object[]{customization.getName(), customization.getGuid()});
            rd.log("Retrieved world json data live from collector artifact with customization");
            AtsWorldEndpointImpl.getCustomizedJsonTable(this.atsApiServer, customization, collectorItems, wr, rd);
        }
        return wr;
    }

    @GET
    @Path(value="coll/{collectorId}/worldresults")
    @Produces(value={"application/json"})
    public WorldResults getCollectionJsonCustomizedPublished(@PathParam(value="collectorId") ArtifactId collectorId) {
        WorldResults wr = new WorldResults();
        ArtifactReadable collectorArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(collectorId);
        if (collectorArt == null) {
            wr.getRd().errorf("No Collector Artifact Found", new Object[0]);
        } else {
            wr.setCollectorArt(collectorArt.getToken());
            wr.setAtsId(this.atsApi.getAtsId((ArtifactToken)collectorArt));
            String json = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((ArtifactId)collectorArt, (AttributeTypeToken)AtsAttributeTypes.WorldResultsJson, "");
            if (Strings.isValid((String)json)) {
                wr = (WorldResults)JsonUtil.readValue((String)json, WorldResults.class);
                wr.getRd().log("Retrieved worldresults json from collector artifact");
            } else {
                wr.getRd().error("No World Results Found");
            }
        }
        return wr;
    }

    @PUT
    @Path(value="coll/{collectorId}/json/{customizeGuid}/publish")
    @Produces(value={"application/json"})
    public WorldResults getCollectionJsonCustomizedPublish(@PathParam(value="collectorId") ArtifactId collectorId, @PathParam(value="customizeGuid") String customizeGuid) {
        WorldResults wr = this.getCollectionJsonCustomized(collectorId, customizeGuid);
        XResultData rd = wr.getRd();
        if (rd.isSuccess()) {
            try {
                ArtifactReadable collectorArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(collectorId);
                String jsonStr = JsonUtil.toJson((Object)wr);
                IAtsChangeSet changes = this.atsApi.createChangeSet("Persist json view");
                changes.setSoleAttributeFromString((ArtifactId)collectorArt, (AttributeTypeGeneric)AtsAttributeTypes.WorldResultsJson, jsonStr);
                TransactionToken tx = changes.executeIfNeeded();
                wr.setTx(tx);
            }
            catch (Exception ex) {
                rd.errorf("Exception publishing %s", new Object[]{Lib.exceptionToString((Exception)ex)});
            }
        }
        return wr;
    }

    @GET
    @Path(value="coll/{collectorId}/export")
    @Produces(value={"text/html"})
    public String getCollectionExportAsHtml(@PathParam(value="collectorId") ArtifactId collectorId) {
        WorldResults wr = this.getCollectionJsonCustomizedPublished(collectorId);
        StringBuilder sb = new StringBuilder();
        sb.append(AHTML.beginMultiColumnTableWithTableSortFilter((int)99, (int)2, (String)"BLACK"));
        sb.append(AHTML.addHeaderRowMultiColumnTable((List)wr.getOrderedHeaders()));
        List rows = wr.getRows();
        for (Map row : rows) {
            ArrayList<String> rowCells = new ArrayList<String>();
            for (String colHead : wr.getOrderedHeaders()) {
                rowCells.add((String)row.get(colHead));
            }
            sb.append(AHTML.addRowMultiColumnTableCollection(rowCells));
        }
        sb.append(AHTML.endMultiColumnTable());
        String title = String.format("OSEE Goal: %s - %s", wr.getAtsId(), wr.getCollectorArt().getName());
        String html = AHTML.simplePageWithTableSortFilter((String)title, (String)sb.toString());
        return html;
    }

    public static WorldResults getCustomizedJsonTable(AtsApi atsApi, CustomizeData customization, Collection<IAtsWorkItem> workItems, WorldResults wr, XResultData rd) {
        Conditions.checkNotNull((Object)customization, (String)("Customization " + customization + " "));
        ArrayList<XViewerColumn> headers = new ArrayList<XViewerColumn>();
        for (XViewerColumn col : customization.getColumnData().getColumns()) {
            if (!col.isShow()) continue;
            headers.add(col);
            wr.getOrderedHeaders().add(col.getName());
        }
        AtsConfigurations configurations = atsApi.getConfigService().getConfigurations();
        for (IAtsWorkItem workItem : workItems) {
            HashMap<String, String> cells = new HashMap<String, String>();
            wr.getRows().add(cells);
            for (XViewerColumn header : headers) {
                String text = "";
                if (Strings.isValid((String)header.getId())) {
                    if (header.getId().contains("created")) {
                        System.err.println("here");
                    }
                    text = atsApi.getColumnService().getColumnText(configurations, header.getId(), (IAtsObject)workItem);
                }
                cells.put(header.getName(), text);
            }
        }
        return wr;
    }

    @GET
    @Path(value="coll/{collectorId}/ui")
    @Produces(value={"text/html"})
    public String getCollectionUI(@PathParam(value="collectorId") ArtifactId collectorId) {
        StringBuilder sb = new StringBuilder();
        ArtifactReadable collectorArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(collectorId);
        if (collectorArt == null) {
            return AHTML.simplePage((String)("Collector Art Does Not Exist " + collectorId));
        }
        this.getDefaultUiTable(sb, "Collection: " + collectorArt.getName(), this.getCollection(collectorId));
        return sb.toString();
    }

    @GET
    @Path(value="coll/{collectorId}/ui/{customizeGuid}")
    @Produces(value={"text/html"})
    public String getCollectionUICustomized(@PathParam(value="collectorId") ArtifactId collectorId, @PathParam(value="customizeGuid") String customizeGuid) {
        CustomizeData customization = this.atsApiServer.getStoreService().getCustomizationByGuid(customizeGuid);
        if (customization == null) {
            return AHTML.simplePage((String)String.format("No customization found with id [%s]", customizeGuid));
        }
        ArtifactReadable collectorArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(collectorId);
        if (collectorArt == null) {
            return AHTML.simplePage((String)String.format("No collector found with id [%s]", collectorId));
        }
        List<IAtsWorkItem> collectorItems = this.getCollection(collectorArt);
        String table = AtsWorldEndpointImpl.getCustomizedTable(this.atsApiServer, "Collector: " + collectorArt.getName() + " - Customization: " + customization.getName(), customization, collectorItems);
        return table;
    }

    public static String getCustomizedTable(AtsApi atsApi, String title, CustomizeData customization, Collection<IAtsWorkItem> workItems) {
        Conditions.checkNotNull((Object)customization, (String)("Customization " + customization + " "));
        StringBuilder sb = new StringBuilder();
        sb.append(AHTML.heading((int)2, (String)title));
        sb.append(AHTML.beginMultiColumnTable((int)97, (int)1));
        ArrayList<String> headers = new ArrayList<String>();
        for (XViewerColumn col : customization.getColumnData().getColumns()) {
            if (!col.isShow()) continue;
            headers.add(col.getName());
        }
        headers.add("Link");
        sb.append(AHTML.addHeaderRowMultiColumnTable(headers));
        AtsConfigurations configurations = atsApi.getConfigService().getConfigurations();
        for (IAtsWorkItem workItem : workItems) {
            ArrayList<String> rowStrs = new ArrayList<String>();
            ArrayList<String> colOptions = new ArrayList<String>();
            for (XViewerColumn col : customization.getColumnData().getColumns()) {
                if (!col.isShow()) continue;
                String text = "";
                if (Strings.isValid((String)col.getId())) {
                    text = atsApi.getColumnService().getColumnText(configurations, col.getId(), (IAtsObject)workItem);
                }
                rowStrs.add(text);
                colOptions.add("");
            }
            rowStrs.add(AHTML.getHyperlinkNewTab((String)("/ats/ui/action/" + workItem.getAtsId()), (String)"open"));
            colOptions.add("");
            sb.append(AHTML.addRowMultiColumnTable((String[])rowStrs.toArray(new String[rowStrs.size()]), null));
        }
        sb.append(AHTML.endMultiColumnTable());
        return sb.toString();
    }

    private void getDefaultUiTable(StringBuilder sb, String tableName, Collection<IAtsWorkItem> workItems) {
        List<AtsCoreColumnToken> columns = Arrays.asList(AtsColumnTokensDefault.TeamColumn, AtsColumnTokensDefault.StateColumn, AtsColumnTokensDefault.PriorityColumn, AtsColumnTokensDefault.ChangeTypeColumn, AtsColumnTokensDefault.AssigneeColumn, AtsColumnTokensDefault.TitleColumn, AtsColumnTokensDefault.ActionableItemsColumn, AtsColumnTokensDefault.CreatedDateColumn, AtsColumnTokensDefault.TargetedVersionColumn, AtsColumnTokensDefault.NotesColumn, AtsColumnTokensDefault.AtsIdColumn);
        sb.append(AHTML.heading((int)2, (String)tableName));
        sb.append(AHTML.beginMultiColumnTable((int)97, (int)1));
        sb.append(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Team", "State", "Priority", "Change Type", "Assignee", "Title", "AI", "Created", "Targted Version", "Notes", "ID")));
        for (IAtsWorkItem workItem : workItems) {
            LinkedList<String> values = new LinkedList<String>();
            for (AtsCoreColumnToken columnId : columns) {
                values.add(this.atsApiServer.getColumnService().getColumnText(columnId, (IAtsObject)workItem));
            }
            sb.append(AHTML.addRowMultiColumnTable((String[])values.toArray(new String[values.size()])));
        }
        sb.append(AHTML.endMultiColumnTable());
    }

    public ResultRows search(AtsSearchData atsSearchData) {
        AtsWorldResultRowOperation op = new AtsWorldResultRowOperation(this.atsApi, atsSearchData);
        ResultRows rows = op.run();
        return rows;
    }

    public ResultRows searchNew(AtsSearchData atsSearchData) {
        AtsWorldResultRowOperation op = new AtsWorldResultRowOperation(this.atsApi, atsSearchData);
        op.setNew(true);
        ResultRows rows = op.run();
        return rows;
    }
}

