/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.task.track;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.task.track.TaskTrackItem;
import org.eclipse.osee.ats.api.task.track.TaskTrackItems;
import org.eclipse.osee.ats.api.task.track.TaskTrackingData;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TeamWorkFlowManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TaskTrackingOperation {
    public static final ArtifactToken OseeProductTesting = ArtifactToken.valueOf((long)8006047L, (String)"OSEE Product Testing.xml", (ArtifactTypeToken)CoreArtifactTypes.GeneralDocument);
    private final AtsApi atsApi;
    private final TaskTrackingData trackData;
    private final XResultData rd;

    public TaskTrackingOperation(TaskTrackingData trackData, AtsApi atsApi) {
        this.trackData = trackData;
        this.rd = trackData.getResults();
        this.atsApi = atsApi;
    }

    public TaskTrackingData run() {
        NewTaskSet createTasks;
        ArtifactToken teamWfArt = this.atsApi.getQueryService().getArtifactByNameOrSentinel(AtsArtifactTypes.TeamWorkflow, this.trackData.getTitle());
        IAtsTeamWorkflow teamWf = null;
        Date createDate = new Date();
        AtsUser asUser = this.atsApi.getUserService().getUserByToken(SystemUser.OseeSystem);
        if (Strings.isValid((String)this.trackData.getAsUserArtId())) {
            asUser = this.atsApi.getUserService().getUserById(ArtifactId.valueOf((String)this.trackData.getAsUserArtId()));
        }
        teamWf = teamWfArt.isValid() ? this.atsApi.getWorkItemService().getTeamWf(teamWfArt) : this.createNewTeamWorkflow(teamWf, asUser, createDate);
        if (this.rd.isErrors()) {
            return this.trackData;
        }
        this.trackData.setTeamWf(teamWf.getArtifactToken());
        String txComment = this.trackData.getTransactionComment();
        if (Strings.isInValid((String)txComment)) {
            txComment = "Create/Update Tracking Review";
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet(txComment);
        NewTaskSet newTaskSet = NewTaskSet.create((String)txComment, (AtsUser)asUser);
        NewTaskData newTaskData = NewTaskData.create((NewTaskSet)newTaskSet, (IAtsTeamWorkflow)teamWf);
        this.createUpdateTaskItems(teamWf, asUser, createDate, newTaskData, this.trackData.getTrackItems());
        try {
            String taskTrackArtId = this.trackData.getTaskTrackArtId();
            if (Strings.isNumeric((String)taskTrackArtId)) {
                ArtifactToken staticTaskArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(taskTrackArtId));
                String taskTrackItemsJson = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)staticTaskArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)"");
                TaskTrackItems taskTrackItems = (TaskTrackItems)JsonUtil.readValue((String)taskTrackItemsJson, TaskTrackItems.class);
                if (Strings.isValid((String)taskTrackItemsJson)) {
                    this.createUpdateTaskItems(teamWf, asUser, createDate, newTaskData, taskTrackItems);
                }
            }
        }
        catch (Exception ex) {
            this.rd.errorf("Exception loading/processing staticTaskArt data [%s]: %s", new Object[]{this.trackData.getTaskTrackArtId(), Lib.exceptionToString((Exception)ex)});
        }
        for (IAtsTask task : this.atsApi.getTaskService().getTasks(teamWf)) {
            if (!task.isInWork()) continue;
            for (AtsUser assignee : task.getAssignees()) {
                changes.addAssignee((IAtsWorkItem)teamWf, assignee);
            }
        }
        changes.executeIfNeeded();
        if (!((NewTaskData)newTaskSet.getNewTaskDatas().iterator().next()).getTasks().isEmpty() && (createTasks = this.atsApi.getTaskService().createTasks(newTaskSet)).isErrors()) {
            this.rd.merge(createTasks.getResults());
        }
        return this.trackData;
    }

    private IAtsTeamWorkflow createNewTeamWorkflow(IAtsTeamWorkflow teamWf, AtsUser asUser, Date createDate) {
        ActionableItem ai = this.atsApi.getActionableItemService().getActionableItemById(ArtifactId.valueOf((String)this.trackData.getAiArtId()));
        if (ai == null) {
            this.rd.errorf("Invalid Actionable Item [%s]", new Object[]{this.trackData.getAiArtId()});
            return null;
        }
        if (Strings.isInvalid((String)this.trackData.getTitle())) {
            this.rd.errorf("Invalid Action title [%s]", new Object[]{this.trackData.getTitle()});
            return null;
        }
        String txComment = this.trackData.getTransactionComment();
        if (Strings.isInValid((String)txComment)) {
            txComment = "Create/Update Tracking Review";
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet(txComment);
        if (teamWf == null) {
            ActionResult result = this.atsApi.getActionService().createAction(null, this.trackData.getTitle(), this.trackData.getDescription(), this.trackData.getChangeType(), this.trackData.getPriority(), false, null, Arrays.asList(ai), createDate, asUser, null, changes);
            teamWf = this.atsApi.getWorkItemService().getFirstTeam((Object)result);
        }
        if (teamWf == null) {
            this.rd.errorf("Unable to create/get team workflow\n", new Object[0]);
            return null;
        }
        if (Strings.isValid((String)this.trackData.getTransitionTo())) {
            String[] stringArray = this.trackData.getTransitionTo().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                TeamWorkFlowManager workflowMgr = new TeamWorkFlowManager(teamWf, this.atsApi, new TransitionOption[0]);
                String stateName = stringArray[n2];
                Result result = workflowMgr.transitionToState(false, teamWf, (IStateToken)TeamState.valueOf((String)stateName), (Collection)teamWf.getAssignees(), changes, this.atsApi);
                if (result.isFalse()) {
                    this.rd.error(result.toString());
                    return null;
                }
                ++n2;
            }
        }
        changes.execute();
        return teamWf;
    }

    private void createUpdateTaskItems(IAtsTeamWorkflow teamWf, AtsUser asUser, Date createDate, NewTaskData newTaskData, TaskTrackItems taskTrackItems) {
        for (TaskTrackItem taskItem : taskTrackItems.getTasks()) {
            IAtsTask taskArt = this.getValidateTask(teamWf, taskItem.getTitle());
            if (taskArt != null) continue;
            JaxAtsTask createJaxTask = JaxAtsTask.create((NewTaskData)newTaskData, (String)taskItem.getTitle(), (AtsUser)asUser, (Date)createDate);
            createJaxTask.setDescription(taskItem.getDescription());
            IAtsTeamWorkflow supportingTeamWf = null;
            if (Strings.isValid((String)taskItem.getSupportingAtsId())) {
                ArtifactToken supportTeamWfArt = this.atsApi.getQueryService().getArtifactByAtsId(taskItem.getSupportingAtsId());
                if (supportTeamWfArt == null) {
                    this.rd.errorf("Invalid supporting TeamWf [%s]", new Object[]{taskItem.getSupportingAtsId()});
                } else {
                    supportingTeamWf = this.atsApi.getWorkItemService().getTeamWf(supportTeamWfArt);
                    createJaxTask.addRelation(CoreRelationTypes.SupportingInfo_IsSupportedBy, new long[]{supportingTeamWf.getId()});
                }
            }
            LinkedList<String> assigneeUserIds = new LinkedList<String>();
            if (Strings.isValid((String)taskItem.getAssigneesArtIds())) {
                String[] stringArray = taskItem.getAssigneesArtIds().split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String assigneeArtId = stringArray[n2];
                    AtsUser user = this.atsApi.getUserService().getUserById(ArtifactId.valueOf((String)assigneeArtId));
                    if (user != null && !assigneeUserIds.contains(user.getUserId())) {
                        assigneeUserIds.add(user.getUserId());
                    }
                    ++n2;
                }
            }
            if (assigneeUserIds.isEmpty() && supportingTeamWf != null) {
                for (AtsUser assignee : supportingTeamWf.getAssignees()) {
                    assigneeUserIds.add(assignee.getUserId());
                }
                AtsUser completedUser = supportingTeamWf.getCompletedBy();
                if (completedUser != null && !completedUser.getUserId().equals(AtsCoreUsers.SYSTEM_USER.getUserId())) {
                    assigneeUserIds.add(completedUser.getUserId());
                }
            }
            createJaxTask.setAssigneeUserIds(assigneeUserIds);
        }
    }

    private IAtsTask getValidateTask(IAtsTeamWorkflow teamWf, String taskName) {
        for (IAtsTask task : this.atsApi.getTaskService().getTasks(teamWf)) {
            if (!task.getName().equals(taskName)) continue;
            return task;
        }
        return null;
    }
}

