/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsProductLineEndpointApi;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.Attribute;
import org.eclipse.osee.ats.rest.internal.workitem.operations.ActionOperations;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSelected;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranchCategoryTokens;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.TransactionQuery;

public final class AtsProductLineEndpointImpl
implements AtsProductLineEndpointApi {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;

    public AtsProductLineEndpointImpl(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public List<BranchToken> getBranches(BranchType type, String workType, BranchCategoryToken category, BranchCategoryToken excludeCategory, String filter, long pageNum, long pageSize) {
        BranchQuery query = this.getBranchQuery(type, workType, category, excludeCategory, filter, pageNum, pageSize);
        return query.getResultsAsId().getList();
    }

    private BranchQuery getBranchQuery(BranchType type, String workType, BranchCategoryToken category, BranchCategoryToken excludeCategory, String filter, long pageNum, long pageSize) {
        ArrayList<Pair> artAttrPairs = new ArrayList<Pair>();
        if (!WorkType.valueOfOrNone((String)workType).equals((Object)WorkType.None)) {
            artAttrPairs.add(new Pair((Object)AtsArtifactTypes.TeamDefinition, (Object)AtsAttributeTypes.WorkType));
            artAttrPairs.add(new Pair((Object)AtsArtifactTypes.TeamWorkflow, (Object)AtsAttributeTypes.TeamDefinitionReference));
        }
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        if (category.isValid()) {
            query = (BranchQuery)query.andIsOfCategory(category);
        }
        if (excludeCategory.isValid()) {
            query = (BranchQuery)query.andIsNotOfCategory(excludeCategory);
        }
        query = (BranchQuery)((BranchQuery)query.includeArchived(false)).includeDeleted(false);
        query = type.getId() > -1L ? (BranchQuery)query.andIsOfType(new BranchType[]{type}) : query;
        query = (BranchQuery)query.orderByName();
        query = !filter.equals("") ? (BranchQuery)query.andNameLike(filter) : query;
        query = pageNum > 0L && pageSize > 0L ? (BranchQuery)query.isOnPage(pageNum, pageSize) : query;
        query = (BranchQuery)query.andStateIs(new BranchState[]{BranchState.MODIFIED, BranchState.CREATED});
        query = type.equals((Object)BranchType.WORKING) && !WorkType.valueOfOrNone((String)workType).equals((Object)WorkType.None) ? (BranchQuery)query.mapAssocArtIdToRelatedAttributes(workType, (BranchId)CoreBranches.COMMON, artAttrPairs) : query;
        return query;
    }

    private List<Branch> getBranchesWithDetails(BranchType type, String workType, BranchCategoryToken category, String filter, long pageNum, long pageSize) {
        ArrayList<Pair> artAttrPairs = new ArrayList<Pair>();
        if (!WorkType.valueOfOrNone((String)workType).equals((Object)WorkType.None)) {
            artAttrPairs.add(new Pair((Object)AtsArtifactTypes.TeamDefinition, (Object)AtsAttributeTypes.WorkType));
            artAttrPairs.add(new Pair((Object)AtsArtifactTypes.TeamWorkflow, (Object)AtsAttributeTypes.TeamDefinitionReference));
        }
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        query = category.isValid() ? (BranchQuery)query.andIsOfCategory(category) : query;
        query = (BranchQuery)query.andIsNotOfCategory(CoreBranchCategoryTokens.PR);
        query = (BranchQuery)((BranchQuery)query.includeArchived(false)).includeDeleted(false);
        query = type.getId() > -1L ? (BranchQuery)query.andIsOfType(new BranchType[]{type}) : query;
        query = (BranchQuery)query.orderByName();
        query = !filter.equals("") ? (BranchQuery)query.andNameLike(filter) : query;
        query = pageNum > 0L && pageSize > 0L ? (BranchQuery)query.isOnPage(pageNum, pageSize) : query;
        query = (BranchQuery)query.andStateIs(new BranchState[]{BranchState.MODIFIED, BranchState.CREATED});
        query = type.equals((Object)BranchType.WORKING) && !WorkType.valueOfOrNone((String)workType).equals((Object)WorkType.None) ? (BranchQuery)query.mapAssocArtIdToRelatedAttributes(workType, (BranchId)CoreBranches.COMMON, artAttrPairs) : query;
        return query.getResults().getList();
    }

    public List<BranchSelected> getPeerReviewWorkingBranchListAll(BranchType type, String workType, BranchCategoryToken category, BranchId peerReviewBranchId, String filter, long pageNum, long pageSize) {
        ArrayList<BranchSelected> peerReviewBranchList = new ArrayList<BranchSelected>();
        List txs = new ArrayList();
        Branch prBranch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(peerReviewBranchId)).getResults().getAtMostOneOrDefault((Object)Branch.SENTINEL);
        if (prBranch.isValid()) {
            txs = ((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andBranch(new BranchId[]{peerReviewBranchId})).getResults().getList();
        }
        List commitArtIds = txs.stream().filter(a -> a.getCommitArt().getId() > 0L && a.getCommitArt().getId() > prBranch.getBaselineTx().getId()).map(b -> b.getCommitArt()).collect(Collectors.toList());
        for (Branch branch : this.getBranchesWithDetails(type, workType, category, filter, pageNum, pageSize)) {
            if (commitArtIds.contains(branch.getAssociatedArtifact())) {
                peerReviewBranchList.add(new BranchSelected((BranchToken)branch, true));
                continue;
            }
            if (!branch.getBranchState().isModified()) continue;
            peerReviewBranchList.add(new BranchSelected((BranchToken)branch, false));
        }
        return peerReviewBranchList;
    }

    public XResultData checkPlarbApproval(String id) {
        XResultData rd = new XResultData();
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(id);
        ActionOperations ops = new ActionOperations(workItem, this.atsApi, this.orcsApi);
        Attribute approval = ops.getActionAttributeValues((AttributeTypeToken)AtsAttributeTypes.ProductLineApprovedBy, workItem);
        if (approval.getValues().isEmpty()) {
            rd.error("Working branch has not yet been approved by PLARB");
        }
        return rd;
    }

    public XResultData setPlarbApproval(String id) {
        XResultData rd = new XResultData();
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(id);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Plarb approval user");
        Date resultDate = new Date(System.currentTimeMillis());
        UserToken account = this.orcsApi.userService().getUser();
        if (account.isInvalid()) {
            rd.error("Account Id not passed properly.  See Admin for help.");
        }
        changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.ProductLineApprovedBy, account.getIdString());
        changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ProductLineApprovedDate, (Object)resultDate);
        changes.execute();
        return rd;
    }

    public int getBranchCount(BranchType type, String workType, BranchCategoryToken category, BranchCategoryToken excludeCategory, String filter) {
        BranchQuery query = this.getBranchQuery(type, workType, category, excludeCategory, filter, 0L, 0L);
        return query.getCount();
    }
}

