/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.notify;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.osee.ats.rest.internal.notify.ExportClassLoader;
import org.eclipse.osee.ats.rest.internal.notify.ServiceUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.util.OseeEmail;
import org.eclipse.osee.orcs.OrcsApi;

public class OseeEmailServer
extends OseeEmail {
    private OseeEmailServer() {
    }

    private OseeEmailServer(Collection<String> toAddresses, String fromAddress, String replyToAddress, String subject, String body, OseeEmail.BodyType bodyType, Collection<String> toAbridgedAddresses, String abridgedSubject) {
        super(toAddresses, fromAddress, replyToAddress, subject, body, bodyType, toAbridgedAddresses, abridgedSubject);
    }

    private OseeEmailServer(String fromEmail, String toAddress, String subject, String body, OseeEmail.BodyType bodyType, String toAbridgedAddress, String abridgedSubject) {
        super(fromEmail, toAddress, subject, body, bodyType, toAbridgedAddress, abridgedSubject);
    }

    public void setClassLoader() {
        Thread.currentThread().setContextClassLoader(new ExportClassLoader(ServiceUtil.getPackageAdmin()));
    }

    public static OseeEmailServer create() {
        OseeEmailServer.loadDefaultMailServer();
        return new OseeEmailServer();
    }

    public static OseeEmailServer create(Collection<String> toAddresses, String fromAddress, String replyToAddress, String subject, String body, OseeEmail.BodyType bodyType, Collection<String> toAbridgedAddresses, String abridgedSubject) {
        OseeEmailServer.loadDefaultMailServer();
        return new OseeEmailServer(toAddresses, fromAddress, replyToAddress, subject, body, bodyType, toAbridgedAddresses, abridgedSubject);
    }

    public static OseeEmailServer create(String fromEmail, String toAddress, String subject, String body, OseeEmail.BodyType bodyType, String toAbridgedAddress, String abridgedSubject) {
        OseeEmailServer.loadDefaultMailServer();
        return new OseeEmailServer(fromEmail, toAddress, subject, body, bodyType, toAbridgedAddress, abridgedSubject);
    }

    private static void loadDefaultMailServer() {
        if (defaultMailServer == null) {
            OrcsApi orcsApi = ServiceUtil.getOrcsApi();
            ArtifactReadable globalArt = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)CoreArtifactTokens.GlobalPreferences).getArtifactOrSentinal();
            defaultMailServer = (String)globalArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DefaultMailServer, (Object)"");
        }
    }

    protected OseeEmail createAbridgedEmail(OseeEmail email) {
        return OseeEmailServer.create(email.getToAbridgedAddresses(), email.getFromAddress(), email.getReplyToAddress(), email.getAbridgedSubject(), this.getAbridgedBodyText(), email.getBodyType(), Collections.emptyList(), "");
    }
}

