/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.agile;

import java.util.Date;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.agile.AgileSprintData;
import org.eclipse.osee.ats.api.agile.AgileSprintDateData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;

public class SprintDataTableBuilder {
    private static final String N_A = "0";
    private final AgileSprintData burn;

    public SprintDataTableBuilder(AgileSprintData burn) {
        this.burn = burn;
    }

    public String getHtml() {
        Date today = new Date();
        StringBuilder sb = new StringBuilder();
        sb.append(AHTML.beginMultiColumnTable((int)95, (int)1));
        sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{"Team", this.burn.getAgileTeamName(), "Sprint", this.burn.getSprintName(), "Report Date", DateUtil.getMMDDYYHHMM()}));
        sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{"Start", DateUtil.get((Date)this.burn.getStartDateAsDate(), (String)"MM/dd/yyyy"), "End", DateUtil.get((Date)this.burn.getStartDateAsDate(), (String)"MM/dd/yyyy"), "", "Days", String.valueOf(this.burn.getDates().size()), "Planned", this.getPlannedPoints(), "Un-Planned", this.getUnPlannedPoints()}));
        LinkedList<String> holidays = new LinkedList<String>();
        holidays.add("Holidays");
        for (Date holiday : this.burn.getHolidays()) {
            holidays.add(DateUtil.get((Date)holiday, (String)"MM/dd/yyyy"));
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])holidays.toArray(new String[holidays.size()])));
        LinkedList<String> strs = new LinkedList<String>();
        strs.add("");
        int count = 1;
        while (count <= this.burn.getDates().size()) {
            strs.add(String.valueOf(count));
            ++count;
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])strs.toArray(new String[strs.size()])));
        strs = new LinkedList();
        strs.add("");
        for (AgileSprintDateData date : this.burn.getDates()) {
            strs.add(DateUtil.get((Date)date.getDate(), (String)"MM/dd/yyyy"));
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])strs.toArray(new String[strs.size()])));
        strs = new LinkedList();
        strs.add("Total Points");
        count = 1;
        while (count <= this.burn.getDates().size()) {
            strs.add(String.valueOf(this.burn.getPlannedPoints() + this.burn.getUnPlannedPoints()));
            ++count;
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])strs.toArray(new String[strs.size()])));
        strs = new LinkedList();
        strs.add("Goal");
        for (AgileSprintDateData date : this.burn.getDates()) {
            strs.add(String.valueOf(date.getGoalPoints()));
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])strs.toArray(new String[strs.size()])));
        strs = new LinkedList();
        strs.add("Planned Complete");
        for (AgileSprintDateData date : this.burn.getDates()) {
            if (date.getDate().after(today)) {
                strs.add(N_A);
                continue;
            }
            strs.add(String.valueOf(date.getCompletedPlannedPoints()));
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])strs.toArray(new String[strs.size()])));
        strs = new LinkedList();
        strs.add("Planned Remaining");
        for (AgileSprintDateData date : this.burn.getDates()) {
            if (date.getCompletedPlannedPoints() == null) {
                strs.add(N_A);
                continue;
            }
            strs.add(String.valueOf((double)this.burn.getPlannedPoints().intValue() - date.getCompletedPlannedPoints()));
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])strs.toArray(new String[strs.size()])));
        strs = new LinkedList();
        strs.add("UnPlanned Complete");
        for (AgileSprintDateData date : this.burn.getDates()) {
            if (date.getCompletedUnPlannedPoints() == null) {
                strs.add(N_A);
                continue;
            }
            strs.add(String.valueOf(date.getCompletedUnPlannedPoints()));
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])strs.toArray(new String[strs.size()])));
        strs = new LinkedList();
        strs.add("UnPlanned Incomplete");
        for (AgileSprintDateData date : this.burn.getDates()) {
            if (date.getInCompletedUnPlannedPoints() == null) {
                strs.add(N_A);
                continue;
            }
            strs.add(String.valueOf(date.getInCompletedUnPlannedPoints()));
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])strs.toArray(new String[strs.size()])));
        strs = new LinkedList();
        strs.add("Total Completed");
        for (AgileSprintDateData date : this.burn.getDates()) {
            if (date.getCompletedPoints() == null) {
                strs.add(N_A);
                continue;
            }
            strs.add(String.valueOf(date.getCompletedPoints()));
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])strs.toArray(new String[strs.size()])));
        strs = new LinkedList();
        strs.add("Total Remaining");
        for (AgileSprintDateData date : this.burn.getDates()) {
            double remaining = (double)this.burn.getPlannedPoints().intValue() - date.getCompletedPlannedPoints() - date.getInCompletedUnPlannedPoints();
            strs.add(String.valueOf(remaining));
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])strs.toArray(new String[strs.size()])));
        sb.append(AHTML.endMultiColumnTable());
        return AHTML.titledPage((String)(String.valueOf(this.burn.getAgileTeamName()) + " - " + this.burn.getSprintName() + " - Data Table"), (String)AHTML.simplePage((String)sb.toString()));
    }

    private String getPlannedPoints() {
        if (this.burn.getPlannedPoints() != null) {
            return String.valueOf(this.burn.getPlannedPoints().toString());
        }
        return N_A;
    }

    private String getUnPlannedPoints() {
        if (this.burn.getUnPlannedPoints() != null) {
            return String.valueOf(this.burn.getUnPlannedPoints().toString());
        }
        return N_A;
    }
}

