/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer.data;

import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.framework.resource.management.StandardOptions;
import org.eclipse.osee.orcs.core.ds.IndexedResource;

public class IndexerDataSourceImpl
extends ByteSource
implements IndexedResource {
    private final IResourceManager resourceManager;
    private final AttributeId id;
    private final AttributeTypeToken attributeType;
    private final GammaId gammaId;
    private final String value;
    private final String uri;

    public IndexerDataSourceImpl(IResourceManager resourceManager, AttributeId id, AttributeTypeToken attributeType, GammaId gammaId, String value, String uri) {
        this.resourceManager = resourceManager;
        this.id = id;
        this.attributeType = attributeType;
        this.gammaId = gammaId;
        this.value = value;
        this.uri = uri;
    }

    public GammaId getGammaId() {
        return this.gammaId;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    private String getStringValue() {
        return this.value;
    }

    private String getUri() {
        return this.uri;
    }

    private boolean isUriValid() {
        boolean toReturn = false;
        try {
            URI uri;
            String value = this.getUri();
            if (Strings.isValid((String)value) && (uri = new URI(value)).toASCIIString().startsWith("attr")) {
                toReturn = true;
            }
        }
        catch (Exception exception) {}
        return toReturn;
    }

    public InputStream getResourceInput() throws IOException {
        return this.openStream();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.gammaId.hashCode();
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream openStream() throws IOException {
        void var1_4;
        Object var1_1 = null;
        if (this.isUriValid()) {
            try {
                PropertyStore options = new PropertyStore();
                options.put(StandardOptions.DecompressOnAquire.name(), true);
                IResourceLocator locator = this.resourceManager.getResourceLocator(this.getUri());
                IResource resource = this.resourceManager.acquire(locator, options);
                if (resource == null) return var1_4;
                InputStream inputStream = resource.getContent();
                return var1_4;
            }
            catch (OseeCoreException ex) {
                throw new IOException(ex);
            }
        } else {
            if (!Strings.isValid((String)this.getStringValue())) return var1_4;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getStringValue().getBytes("UTF-8"));
        }
        return var1_4;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IndexedResource) {
            IndexedResource other = (IndexedResource)obj;
            return !this.getGammaId().notEqual((Id)other.getGammaId());
        }
        return false;
    }

    public String toString() {
        return "IndexerDataSourceImpl [id=" + this.id + ", typeUuid=" + this.attributeType + ", gammaId=" + this.gammaId + ", uri=" + this.uri + ", value=" + this.value + "]";
    }
}

