/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.IndexerData;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexerCollectorNotifier;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexingTaskConsumer;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.DeleteTagSetDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.IndexerDatabaseStatisticsCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.PurgeAllTagsDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.producer.IndexAllInQueueCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.producer.IndexBranchesDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.producer.IndexerDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.IndexerCollector;

public class QueryEngineIndexerImpl
implements QueryEngineIndexer {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final IndexingTaskConsumer consumer;
    private final IndexerCollectorNotifier systemCollector;

    public QueryEngineIndexerImpl(Log logger, JdbcClient jdbcClient, SqlJoinFactory joinFactory, IndexingTaskConsumer indexingConsumer) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.consumer = indexingConsumer;
        this.systemCollector = new IndexerCollectorNotifier(logger);
    }

    public CancellableCallable<Integer> deleteIndexByQueryId(OrcsSession session, int queueId) {
        return new DeleteTagSetDatabaseTxCallable(this.logger, session, this.jdbcClient, queueId);
    }

    public CancellableCallable<Integer> purgeAllIndexes(OrcsSession session) {
        return new PurgeAllTagsDatabaseCallable(this.logger, session, this.jdbcClient);
    }

    public CancellableCallable<IndexerData> getIndexerData(OrcsSession session) {
        return new IndexerDatabaseStatisticsCallable(this.logger, session, this.jdbcClient);
    }

    public CancellableCallable<Integer> indexBranches(OrcsSession session, OrcsTokenService tokenService, Set<Branch> branches, boolean indexOnlyMissing, IndexerCollector ... collector) {
        return new IndexBranchesDatabaseCallable(this.logger, session, this.jdbcClient, this.joinFactory, tokenService, this.consumer, this.merge(collector), branches, indexOnlyMissing);
    }

    public CancellableCallable<Integer> indexAllFromQueue(OrcsSession session, OrcsTokenService tokenService, IndexerCollector ... collector) {
        return new IndexAllInQueueCallable(this.logger, session, this.jdbcClient, this.joinFactory, tokenService, this.consumer, this.merge(collector));
    }

    public CancellableCallable<List<Future<?>>> indexResources(OrcsSession session, OrcsTokenService tokenService, Iterable<Long> datas, IndexerCollector ... collector) {
        return new IndexerDatabaseCallable(this.logger, session, this.jdbcClient, this.joinFactory, tokenService, this.consumer, this.merge(collector), false, 1000, datas);
    }

    public void indexAttrTypeIds(OrcsSession session, OrcsTokenService tokenService, Iterable<Long> attrTypeIds) {
        String GAMMAS_BY_TYPE = "select gamma_id from osee_attribute where attr_type_id = ?";
        LinkedList<Long> gammaIds = new LinkedList<Long>();
        for (Long attributeType : attrTypeIds) {
            Throwable throwable = null;
            Object var9_11 = null;
            try (JdbcStatement chStmt = this.jdbcClient.getStatement();){
                chStmt.runPreparedQueryWithMaxFetchSize(GAMMAS_BY_TYPE, new Object[]{attributeType});
                while (chStmt.next()) {
                    gammaIds.add(chStmt.getLong("gamma_id"));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            try {
                new IndexerDatabaseCallable(this.logger, session, this.jdbcClient, this.joinFactory, tokenService, this.consumer, null, false, 1000, gammaIds).call();
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            System.out.println(String.format("Processed %d gammas for type %d", gammaIds.size(), attributeType));
            gammaIds.clear();
        }
    }

    public void indexAttrTypeMissingOnly(OrcsTokenService tokenService, Iterable<Long> attrTypeIds) {
        String MISSING_GAMMAS_BY_TYPE = "SELECT DISTINCT att.gamma_id FROM OSEE_ATTRIBUTE att, osee_txs txs WHERE attr_type_id IN (" + Collections.toString((String)",", attrTypeIds) + ") AND att.GAMMA_ID = txs.gamma_id AND txs.tx_current = 1 AND NOT EXISTS (SELECT 1 FROM osee_search_tags tag WHERE tag.gamma_id = att.gamma_id) AND length(value) > 1";
        LinkedList<Long> gammaIds = new LinkedList<Long>();
        Throwable throwable = null;
        Object var6_8 = null;
        try (JdbcStatement chStmt = this.jdbcClient.getStatement();){
            chStmt.runPreparedQueryWithMaxFetchSize(MISSING_GAMMAS_BY_TYPE, new Object[0]);
            while (chStmt.next()) {
                gammaIds.add(chStmt.getLong("gamma_id"));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        System.out.println("Found gammas to tag: " + gammaIds.size());
        try {
            new IndexerDatabaseCallable(this.logger, null, this.jdbcClient, this.joinFactory, tokenService, this.consumer, null, false, 1000, gammaIds).call();
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    private IndexerCollector merge(IndexerCollector ... collectors) {
        IndexerCollectorNotifier toReturn = this.systemCollector;
        if (collectors != null && collectors.length > 0) {
            IndexerCollectorNotifier notifier = new IndexerCollectorNotifier(this.logger);
            notifier.addCollector(this.systemCollector);
            IndexerCollector[] indexerCollectorArray = collectors;
            int n = collectors.length;
            int n2 = 0;
            while (n2 < n) {
                IndexerCollector collector = indexerCollectorArray[n2];
                notifier.addCollector(collector);
                ++n2;
            }
        }
        return toReturn;
    }

    public void addCollector(IndexerCollector collector) {
        this.systemCollector.addCollector(collector);
    }

    public void removeCollector(IndexerCollector collector) {
        this.systemCollector.removeCollector(collector);
    }
}

