/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.MapEntryDataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.Storage;
import org.eclipse.osee.orcs.db.internal.proxy.UriDataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.VarCharDataProxy;

public class AttributeDataProxyFactory {
    private final IResourceManager resourceManager;
    private final Log logger;

    public AttributeDataProxyFactory(IResourceManager resourceManager, Log logger) {
        this.resourceManager = resourceManager;
        this.logger = logger;
    }

    public <T> DataProxy<T> createProxy(AttributeTypeToken attributeTypeToken, T value, String uri) {
        Object checkedValue = this.intern(attributeTypeToken, value);
        if (attributeTypeToken.isUri()) {
            UriDataProxy uriDataProxy = new UriDataProxy();
            uriDataProxy.setLogger(this.logger);
            uriDataProxy.setStorage(new Storage(this.resourceManager, uriDataProxy));
            uriDataProxy.setData(checkedValue, uri);
            return uriDataProxy;
        }
        if (attributeTypeToken.isMapEntry()) {
            MapEntryDataProxy mapEntryDataProxy = new MapEntryDataProxy();
            mapEntryDataProxy.setLogger(this.logger);
            mapEntryDataProxy.setStorage(new Storage(this.resourceManager, mapEntryDataProxy));
            mapEntryDataProxy.setDataByObject(checkedValue, uri);
            MapEntryDataProxy dataProxy = mapEntryDataProxy;
            return dataProxy;
        }
        VarCharDataProxy<Object> varCharDataProxy = new VarCharDataProxy<Object>();
        varCharDataProxy.setLogger(this.logger);
        varCharDataProxy.setStorage(new Storage(this.resourceManager, varCharDataProxy));
        varCharDataProxy.setData(checkedValue, uri);
        return varCharDataProxy;
    }

    private Object intern(AttributeTypeToken attributeType, Object original) {
        Object value = original;
        if (attributeType.isEnumerated() && value instanceof String) {
            value = Strings.intern((String)((String)value));
        }
        return value;
    }
}

