/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing.relation.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableAppender;

public class HtmlRelationTableAppender
implements RelationTableAppender {
    private StringBuilder htmlContent = new StringBuilder();
    private List<String> columnHeaders = new ArrayList<String>();

    @Override
    public void startTable() {
        this.htmlContent.append("<br><table border='1'>");
    }

    @Override
    public void appendTableHeader(String relationTypeName, String relationTypeSideName, int columnCount) {
        this.htmlContent.append("<tr>").append("<th colspan='").append(columnCount).append("' style='text-align:center; padding: 8px;'>").append(relationTypeName).append(" relation to ").append(relationTypeSideName).append("</th>").append("</tr>");
    }

    @Override
    public void appendColumnHeaders(List<String> columns) {
        this.columnHeaders = columns;
        if (!this.columnHeaders.isEmpty()) {
            this.htmlContent.append("<tr>");
            for (String column : this.columnHeaders) {
                if (column.contains(".")) {
                    column = column.substring(column.indexOf(46) + 1);
                }
                this.htmlContent.append("<th>").append(column).append("</th>");
            }
            this.htmlContent.append("</tr>");
        }
    }

    @Override
    public void appendRow(List<String> cellValues) {
        this.htmlContent.append("<tr>");
        for (String value : cellValues) {
            this.htmlContent.append("<td>").append(value).append("</td>");
        }
        this.htmlContent.append("</tr>");
    }

    @Override
    public void endTable() {
        this.htmlContent.append("</table>");
    }

    @Override
    public String getTable() {
        return this.htmlContent.toString();
    }
}

