/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing.artifactacceptor;

import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.publishing.artifactacceptor.ArtifactAcceptorImpls;

@FunctionalInterface
public interface ArtifactAcceptor {
    public static ArtifactAcceptor and(ArtifactAcceptor ... artifactAcceptors) {
        if (artifactAcceptors == null || artifactAcceptors.length == 0) {
            return ArtifactAcceptorImpls.ok;
        }
        final LinkedList<ArtifactAcceptor> validArtifactAcceptorList = new LinkedList<ArtifactAcceptor>();
        ArtifactAcceptor[] artifactAcceptorArray = artifactAcceptors;
        int n = artifactAcceptors.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactAcceptor artifactAcceptor = artifactAcceptorArray[n2];
            if (artifactAcceptor != null && artifactAcceptor != ArtifactAcceptorImpls.ok) {
                if (artifactAcceptor == ArtifactAcceptorImpls.ko) {
                    return ArtifactAcceptorImpls.ko;
                }
                validArtifactAcceptorList.add(artifactAcceptor);
            }
            ++n2;
        }
        if (validArtifactAcceptorList.isEmpty()) {
            return ArtifactAcceptorImpls.ok;
        }
        return new ArtifactAcceptor(){

            @Override
            public boolean isOk(ArtifactReadable artifactReadable) {
                for (ArtifactAcceptor artifactAcceptor : validArtifactAcceptorList) {
                    if (artifactAcceptor.isOk(artifactReadable)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ArtifactAcceptor ko() {
        return ArtifactAcceptorImpls.ko;
    }

    public static ArtifactAcceptor not(ArtifactAcceptor baseArtifactAcceptor) {
        if (baseArtifactAcceptor == null) {
            return ArtifactAcceptorImpls.ko;
        }
        if (baseArtifactAcceptor == ArtifactAcceptorImpls.ok) {
            return ArtifactAcceptorImpls.ko;
        }
        if (baseArtifactAcceptor == ArtifactAcceptorImpls.ko) {
            return ArtifactAcceptorImpls.ok;
        }
        return t -> !baseArtifactAcceptor.isOk(t);
    }

    public static ArtifactAcceptor ok() {
        return ArtifactAcceptorImpls.ok;
    }

    public boolean isOk(ArtifactReadable var1);
}

