/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.publishing.PublishOptions;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableOptions;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class PublishingTemplate
implements ToMessage {
    public static final PublishingTemplate SENTINEL;
    private String identifier;
    private String name;
    private PublishOptions publishingOptions;
    private String templateContent;
    private RelationTableOptions relationTableOptions;

    static {
        PublishingTemplate sentinelPublishingTemplate = new PublishingTemplate();
        sentinelPublishingTemplate.sentinel();
        SENTINEL = sentinelPublishingTemplate;
    }

    public PublishingTemplate() {
        this.identifier = null;
        this.name = null;
        this.publishingOptions = null;
        this.templateContent = null;
        this.relationTableOptions = null;
    }

    public PublishingTemplate(@NonNull String identifier, @NonNull String name, @NonNull PublishOptions publishingOptions, @Nullable String templateContent, @NonNull RelationTableOptions relationTableOptions) {
        this.identifier = (String)Conditions.requireNonNull((Object)identifier, (String)"identifier");
        this.name = (String)Conditions.requireNonNull((Object)name, (String)"name");
        this.publishingOptions = (PublishOptions)Conditions.requireNonNull((Object)publishingOptions, (String)"publishingOptions");
        this.templateContent = Objects.nonNull(templateContent) ? templateContent : "";
        this.relationTableOptions = Objects.requireNonNull(relationTableOptions, "relationTableOptions");
    }

    @JsonIgnore
    public void defaults() {
        if (Objects.isNull(this.identifier)) {
            this.sentinel();
            return;
        }
        if (Objects.isNull(this.name)) {
            this.sentinel();
            return;
        }
        if (Objects.isNull(this.publishingOptions)) {
            this.publishingOptions = new PublishOptions();
        }
        this.publishingOptions.defaults();
        if (Objects.isNull(this.templateContent)) {
            this.templateContent = "";
        }
        if (Objects.isNull(this.relationTableOptions)) {
            this.relationTableOptions = new RelationTableOptions();
        }
    }

    public String getIdentifier() {
        if (Objects.isNull(this.identifier)) {
            throw new IllegalStateException("PublishingTemplate::getIdentifier, the member \"identifier\" has not been set.");
        }
        return this.identifier;
    }

    public String getName() {
        if (Objects.isNull(this.name)) {
            throw new IllegalStateException("PublishingTemplate::getName, the member \"name\" has not been set.");
        }
        return this.name;
    }

    public PublishOptions getPublishOptions() {
        if (Objects.isNull(this.publishingOptions)) {
            throw new IllegalStateException("PublishingTemplate::getPublishOptions, the member \"publishOptions\" has not been set.");
        }
        return this.publishingOptions;
    }

    public String getTemplateContent() {
        if (Objects.isNull(this.templateContent)) {
            throw new IllegalStateException("PublishingTemplate::getTemplateContent, the member \"templateContent\" has not been set.");
        }
        return this.templateContent;
    }

    public RelationTableOptions getRelationTableOptions() {
        if (Objects.isNull(this.templateContent)) {
            throw new IllegalStateException("PublishingTemplate::getRelationTableOptions, the member \"relationTableOptions\" has not been set.");
        }
        return this.relationTableOptions;
    }

    @JsonIgnore
    public boolean isSentinel() {
        return this == SENTINEL || "SENTINEL".equals(this.identifier) || "SENTINEL".equals(this.name);
    }

    @JsonIgnore
    public boolean isNotSentinel() {
        return !this.isSentinel();
    }

    @JsonIgnore
    public boolean isValid() {
        return Objects.nonNull(this.identifier) && !this.identifier.isBlank() && Objects.nonNull(this.name) && !this.name.isBlank() && Objects.nonNull(this.publishingOptions) && this.publishingOptions.isValid() && Objects.nonNull(this.templateContent);
    }

    @JsonIgnore
    private void sentinel() {
        this.identifier = "SENTINEL";
        this.name = "SENTINEL";
        this.publishingOptions = new PublishOptions();
        this.publishingOptions.defaults();
        this.templateContent = "";
    }

    public void setIdentifier(String identifier) {
        if (Objects.nonNull(this.identifier)) {
            throw new IllegalStateException("PublishingTemplate::setIdentifier, member \"identifier\" has already been set.");
        }
        this.identifier = Objects.requireNonNull(identifier, "PublishingTemplate::setIdentifier, parameter \"identifier\" cannot be null.");
    }

    public void setName(String name) {
        if (Objects.nonNull(this.name)) {
            throw new IllegalStateException("PublishingTemplate::setName, member \"name\" has already been set.");
        }
        this.name = Objects.requireNonNull(name, "PublishingTemplate::setName, parameter \"name\" cannot be null.");
    }

    public void setPublishOptions(PublishOptions publishOptions) {
        if (Objects.nonNull(this.publishingOptions)) {
            throw new IllegalStateException("PublishingTemplate::setPublishOptions, member \"publishOptions\" has already been set.");
        }
        this.publishingOptions = Objects.requireNonNull(publishOptions, "PublishingTemplate::setPublishOptions, parameter \"publishOptions\" cannot be null.");
    }

    public void setTemplateContent(String templateContent) {
        if (Objects.nonNull(this.templateContent)) {
            throw new IllegalStateException("PublishingTemplate::setTemplateContent, member \"templateContent\" has already been set.");
        }
        this.templateContent = Objects.requireNonNull(templateContent, "PublishingTemplate::setTemplateContent, parameter \"templateContent\" cannot be null.");
    }

    @JsonIgnore
    public void update(Function<CharSequence, CharSequence> updater) {
        this.templateContent = updater.apply(this.templateContent).toString();
    }

    @JsonIgnore
    public boolean test(Predicate<CharSequence> tester) {
        return tester.test(this.templateContent);
    }

    @JsonIgnore
    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Publishing Template").indentInc().segment((CharSequence)"Identifier", (Object)this.identifier).segment((CharSequence)"Name", (Object)this.name).toMessage((ToMessage)this.publishingOptions).title((CharSequence)"Template Content").indentInc().block((CharSequence)this.templateContent).indentDec().indentDec();
        return outMessage;
    }

    @JsonIgnore
    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

