/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public interface PublishingArtifact
extends ArtifactReadable,
ToMessage {
    public static final PublishingArtifact SENTINEL = new PublishingArtifactSentinel();

    public boolean areChildrenCached();

    public boolean branchHasView();

    public void clearApplicable();

    public void clearBookmarked();

    public void clearBranchView();

    public void clearEndOfSection();

    public void clearHyperlinkFrom(PublishingArtifact var1);

    public void clearHyperlinkTo(PublishingArtifact var1);

    public void clearProcessed();

    public void clearStartOfSection();

    public List<PublishingArtifact> getChildrenAsPublishingArtifacts();

    public List<Integer> getHierarchyPosition();

    public int getOutlineLevel();

    @Override
    public PublishingArtifact getParent();

    public Optional<String> getPublishingContent();

    public boolean hasAttributeContent(AttributeTypeToken var1);

    public void incrementRenderedAttributeCount();

    public Applicability isApplicable();

    public boolean isBookmarked();

    public boolean isChanged();

    public boolean isEndOfSection();

    public boolean isFound();

    public boolean isHierarchyPositionSet();

    public boolean isHyperlinked();

    public boolean isHyperlinkedFrom(PublishingArtifact var1);

    public boolean isHyperlinkedTo(PublishingArtifact var1);

    public boolean isProcessed();

    public boolean isPublished();

    public boolean isPublishingContentCached();

    public TryReload isReloadable();

    public boolean isStartOfSection();

    public void pushHierarchyPosition(Integer var1);

    public void setApplicable();

    public void setBookmarked();

    public void setBranchView(BranchSpecification var1);

    public void setChanged();

    public void setChildrenLoadedAndCached();

    public void setEndOfSection();

    public void setHierarchyPosition();

    public void setHierarchyPosition(List<Integer> var1);

    public void setHyperlinkFrom(PublishingArtifact var1);

    public void setHyperlinkTo(PublishingArtifact var1);

    public void setOutlineLevel(int var1);

    public void setProcessed();

    public void setPublishingContent(String var1);

    public void setStartOfSection();

    public Stream<PublishingArtifact> streamHyperlinkedFrom();

    public Stream<PublishingArtifact> streamHyperlinkedTo();

    public static enum Applicability {
        NO,
        UNKNOWN,
        YES;


        public boolean no() {
            return this == NO;
        }

        public boolean unknown() {
            return this == UNKNOWN;
        }

        public boolean yes() {
            return this == YES;
        }
    }

    public static class PublishingArtifactNotFound
    extends PublishingArtifactSentinel {
        BranchSpecification branchSpecification;
        BranchToken branchToken;
        String guid;

        PublishingArtifactNotFound(BranchSpecification branchSpecification) {
            this.id = ArtifactId.SENTINEL.getId();
            this.guid = Strings.emptyString();
            this.branchSpecification = branchSpecification;
            this.branchToken = BranchToken.create(branchSpecification.getBranchId().getId(), "Not Loaded", branchSpecification.getViewId());
        }

        PublishingArtifactNotFound(BranchSpecification branchSpecification, ArtifactId artifactIdentifier) {
            this.id = artifactIdentifier.getId();
            this.guid = Strings.emptyString();
            this.branchSpecification = branchSpecification;
            this.branchToken = BranchToken.create(branchSpecification.getBranchId().getId(), "Not Loaded", branchSpecification.getViewId());
        }

        PublishingArtifactNotFound(BranchSpecification branchSpecification, String guid) {
            this.id = ArtifactId.SENTINEL.getId();
            this.guid = guid;
            this.branchSpecification = branchSpecification;
            this.branchToken = BranchToken.create(branchSpecification.getBranchId().getId(), "Not Loaded", branchSpecification.getViewId());
        }

        @Override
        public boolean branchHasView() {
            return this.branchSpecification.hasView();
        }

        @Override
        public void clearBranchView() {
            this.branchSpecification = new BranchSpecification(BranchId.valueOf(this.branchSpecification.getBranchId().getId()));
            this.branchToken = BranchToken.create(this.branchSpecification.getBranchId().getId(), "Not Loaded", ArtifactId.SENTINEL);
        }

        @Override
        public BranchToken getBranch() {
            return this.branchToken;
        }

        @Override
        public String getGuid() {
            return this.guid;
        }

        @Override
        public boolean isBookmarked() {
            return false;
        }

        @Override
        public boolean isFound() {
            return false;
        }

        @Override
        public TryReload isReloadable() {
            return this.branchSpecification.hasView() ? TryReload.NO : TryReload.YES;
        }

        @Override
        public Message toMessage(int indent, Message message) {
            Message outMessage = Objects.nonNull(message) ? message : new Message();
            outMessage.indent(indent).title((CharSequence)"PublishingArtifact (PublishingArtifactNotFound)").indentInc().segment((CharSequence)"Identifier", (Object)this.getIdString()).segment((CharSequence)"GUID", (Object)this.getGuid()).segment((CharSequence)"Branch Identifier", (Object)this.branchToken.getId()).segment((CharSequence)"Branch View", (Object)this.branchToken.getViewId()).indentDec();
            return outMessage;
        }

        @Override
        public String toString() {
            return this.toMessage(0, null).toString();
        }
    }

    public static class PublishingArtifactSentinel
    extends ArtifactReadable.ArtifactReadableImpl
    implements PublishingArtifact {
        @Override
        public boolean areChildrenCached() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean branchHasView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearApplicable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearBookmarked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearBranchView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearEndOfSection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearHyperlinkFrom(PublishingArtifact artifact) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearHyperlinkTo(PublishingArtifact artifact) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearProcessed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearStartOfSection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PublishingArtifact> getChildrenAsPublishingArtifacts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Integer> getHierarchyPosition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getOutlineLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PublishingArtifact getParent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPublishingContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasAttributeContent(AttributeTypeToken attributeTypeToken) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void incrementRenderedAttributeCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Applicability isApplicable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isBookmarked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isChanged() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEndOfSection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isFound() {
            return false;
        }

        @Override
        public boolean isHierarchyPositionSet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHyperlinked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHyperlinkedFrom(PublishingArtifact artifact) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHyperlinkedTo(PublishingArtifact artifact) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isProcessed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublished() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublishingContentCached() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TryReload isReloadable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isStartOfSection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void pushHierarchyPosition(Integer position) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setApplicable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setBookmarked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setBranchView(BranchSpecification branchSpecification) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setChanged() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setChildrenLoadedAndCached() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEndOfSection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHierarchyPosition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHierarchyPosition(List<Integer> parentHierarchyPosition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHyperlinkFrom(PublishingArtifact artifact) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHyperlinkTo(PublishingArtifact artifact) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOutlineLevel(int level) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setProcessed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPublishingContent(String content) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStartOfSection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Stream<PublishingArtifact> streamHyperlinkedFrom() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Stream<PublishingArtifact> streamHyperlinkedTo() {
            throw new UnsupportedOperationException();
        }

        public Message toMessage(int indent, Message message) {
            Message outMessage = Objects.nonNull(message) ? message : new Message();
            outMessage.indent(indent).title((CharSequence)"PublishingArtifact (PublishingArtifactSentinel)").indentInc().segment((CharSequence)"Identifier", (Object)this.getIdString()).segment((CharSequence)"GUID", this.getGuid()).indentDec();
            return outMessage;
        }

        public String toString() {
            return this.toMessage(0, null).toString();
        }
    }

    public static enum TryReload {
        NO,
        YES;


        public boolean no() {
            return this == NO;
        }

        public boolean yes() {
            return this == YES;
        }
    }
}

