/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.publishing.ContentPosition;
import org.eclipse.osee.framework.core.publishing.FormatIndicatorDeserializer;
import org.eclipse.osee.framework.core.publishing.FormatIndicatorSerializer;
import org.eclipse.osee.framework.core.publishing.PublishingAppender;
import org.eclipse.osee.framework.core.publishing.markdown.MarkdownPublishingAppender;
import org.eclipse.osee.framework.core.publishing.wordml.ValidateWordMl;
import org.eclipse.osee.framework.core.publishing.wordml.WordMlPublishingAppender;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

@JsonSerialize(using=FormatIndicatorSerializer.class)
@JsonDeserialize(using=FormatIndicatorDeserializer.class)
public enum FormatIndicator implements ToMessage
{
    MARKDOWN("markdown", ContentPosition.START, CoreArtifactTypes.Markdown, CoreAttributeTypes.MarkdownContent, CoreArtifactTypes.HeadingMarkdown, CoreAttributeTypes.Name, 6, (appender, maximumOutlineDepth) -> new MarkdownPublishingAppender(appender), null),
    TEXT("text", ContentPosition.END, CoreArtifactTypes.PlainText, CoreAttributeTypes.PlainTextContent, CoreArtifactTypes.HeadingPlainText, CoreAttributeTypes.Name, -1, (appender, maximumOutlineDepth) -> new WordMlPublishingAppender(appender), null),
    WORD_ML("word-ml", ContentPosition.END, CoreArtifactTypes.MsWordTemplate, CoreAttributeTypes.WordTemplateContent, CoreArtifactTypes.HeadingMsWord, CoreAttributeTypes.Name, 9, (appender, maximumOutlineDepth) -> new WordMlPublishingAppender(appender), ValidateWordMl::validateWordMl),
    XHTML("xhtml", ContentPosition.END, CoreArtifactTypes.HtmlArtifact, CoreAttributeTypes.HtmlContent, CoreArtifactTypes.HeadingHtml, CoreAttributeTypes.Name, -1, (appender, maximumOutlineDepth) -> new WordMlPublishingAppender(appender), null);

    private static final @NonNull Map<@NonNull String, @NonNull FormatIndicator> formatIndicators;
    private static final @NonNull EnumMap<@NonNull FormatIndicator, @NonNull String> formatNames;
    static final String jsonObjectName = "formatIndicator";
    private final @NonNull ContentPosition contentPosition;
    private final @Nullable Function<String, Message> contentValidator;
    private final @NonNull String formatName;
    private final @NonNull AttributeTypeToken contentAttributeTypeToken;
    private final @NonNull ArtifactTypeToken contentArtifactTypeToken;
    private final int maximumOutlineDepth;
    private final @NonNull PublishingAppenderFactory publishingAppenderFactory;
    private final @NonNull ArtifactTypeToken defaultHeadingArtifactTypeToken;
    private final @NonNull AttributeTypeToken defaultHeadingContentAttributeTypeToken;

    static {
        formatNames = new EnumMap(FormatIndicator.class);
        FormatIndicator[] formatIndicatorArray = FormatIndicator.values();
        int n = formatIndicatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            FormatIndicator formatIndicator = formatIndicatorArray[n2];
            formatNames.put(formatIndicator, formatIndicator.getFormatName());
            ++n2;
        }
        formatIndicators = new HashMap<String, FormatIndicator>();
        formatNames.entrySet().forEach(entry -> {
            FormatIndicator formatIndicator = formatIndicators.put((String)entry.getValue(), (FormatIndicator)((Object)((Object)entry.getKey())));
        });
    }

    public static Optional<FormatIndicator> ofFormatName(@Nullable String formatName) {
        FormatIndicator formatIndicator = (FormatIndicator)((Object)Conditions.applyWhenNonNull((Object)formatName, formatIndicators::get));
        return Optional.ofNullable(formatIndicator);
    }

    public ArtifactTypeToken getDefaultHeadingArtifactTypeToken() {
        return this.defaultHeadingArtifactTypeToken;
    }

    public AttributeTypeToken getDefaultHeadingContentAttributTypeToken() {
        return this.defaultHeadingContentAttributeTypeToken;
    }

    private FormatIndicator(@NonNull String formatName, @NonNull ContentPosition contentPosition, @NonNull ArtifactTypeToken contentArtifactTypeToken, @NonNull AttributeTypeToken contentAttributeTypeToken, ArtifactTypeToken defaultHeadingArtifactTypeToken, @NonNull AttributeTypeToken defaultHeadingContentAttributeTypeToken, @Nullable int maximumOutlineDepth, PublishingAppenderFactory publishingAppenderFactory, Function<String, Message> contentValidator) {
        this.formatName = (String)Conditions.requireNonNull((Object)formatName);
        this.contentPosition = (ContentPosition)((Object)Conditions.requireNonNull((Object)((Object)contentPosition)));
        this.contentArtifactTypeToken = (ArtifactTypeToken)Conditions.requireNonNull((Object)contentArtifactTypeToken);
        this.contentAttributeTypeToken = (AttributeTypeToken)Conditions.requireNonNull((Object)contentAttributeTypeToken);
        this.defaultHeadingArtifactTypeToken = (ArtifactTypeToken)Conditions.requireNonNull((Object)defaultHeadingArtifactTypeToken);
        this.defaultHeadingContentAttributeTypeToken = (AttributeTypeToken)Conditions.requireNonNull((Object)defaultHeadingContentAttributeTypeToken);
        this.maximumOutlineDepth = maximumOutlineDepth;
        this.publishingAppenderFactory = (PublishingAppenderFactory)Conditions.requireNonNull((Object)publishingAppenderFactory);
        this.contentValidator = contentValidator;
    }

    public @NonNull PublishingAppender createPublishingAppender(@NonNull Appendable appendable) {
        return this.publishingAppenderFactory.create((Appendable)Conditions.requireNonNull((Object)appendable), this.maximumOutlineDepth);
    }

    public @NonNull PublishingAppender createPublishingAppender(@NonNull Appendable appendable, int maximumOutlineDepth) {
        return this.publishingAppenderFactory.create((Appendable)Conditions.requireNonNull((Object)appendable), Math.max(0, Math.min(maximumOutlineDepth, this.maximumOutlineDepth)));
    }

    public @NonNull ContentPosition getContentPosition() {
        return this.contentPosition;
    }

    public @NonNull String getFormatName() {
        return this.formatName;
    }

    public @NonNull AttributeTypeToken getContentAttributeTypeToken() {
        return this.contentAttributeTypeToken;
    }

    public @NonNull ArtifactTypeToken getContentArtifactTypeToken() {
        return this.contentArtifactTypeToken;
    }

    public int getMaximumOutlineDepth() {
        return this.maximumOutlineDepth;
    }

    public boolean isMarkdown() {
        return this == MARKDOWN;
    }

    public boolean isWordMl() {
        return this == WORD_ML;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Format Indicator").indentInc().segment((CharSequence)"Format Name", (Object)this.getFormatName()).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }

    public @Nullable Message validatePublishingTemplateContent(@NonNull String content) {
        return this.contentValidator != null ? this.contentValidator.apply((String)Conditions.requireNonNull((Object)content)) : null;
    }

    private static interface PublishingAppenderFactory {
        public @NonNull PublishingAppender create(@NonNull Appendable var1, @NonNull Integer var2);
    }
}

