/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums.token;

import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.publishing.CuiCategoryIndicator;
import org.eclipse.osee.framework.core.publishing.CuiTypeIndicator;
import org.eclipse.osee.framework.core.util.toggles.CuiNamesConfiguration;
import org.eclipse.osee.framework.core.util.toggles.Toggle;
import org.eclipse.osee.framework.core.util.toggles.TogglesFactory;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class DataClassificationAttributeType
extends AttributeTypeEnum<DataClassificationEnum> {
    private static String standardDescription = "This attribute is used by the following artifact types:\n   * CoreArtifactTypes.Controlled:\n        to specify a CUI Category and CUI Type of the data contained in the controlled artifact.\n   * CoreArtifactTypes.DataRightsConfiguration:\n        to specify an allowed CUI Category and CUI Type for a publish.\n";
    private static String standardName = "CUI Category And CUI Type Pairs";
    private static String versionOneDescription = Strings.emptyString();
    private static String versionOneName = "Data Classification";

    public static Pair<String, String> getConfiguredNameAndDescription() {
        Toggle<CuiNamesConfiguration> toggles = TogglesFactory.create("CuiNamesConfiguration", CuiNamesConfiguration::convert, TogglesFactory.ToggleSource.BUNDLE_MANIFEST);
        CuiNamesConfiguration cuiNamesConfiguration = toggles.get();
        switch (cuiNamesConfiguration) {
            case VERSION_ONE: {
                return new Pair((Object)versionOneName, (Object)versionOneDescription);
            }
        }
        return new Pair((Object)standardName, (Object)standardDescription);
    }

    public DataClassificationAttributeType(Long identifier, String name, String description, TaggerTypeToken taggerTypeToken, String mediaType, NamespaceToken namespace) {
        super(identifier, namespace, name, mediaType, description, taggerTypeToken, CuiCategoryIndicator.values().length * CuiTypeIndicator.values().length, new DisplayHint[0]);
        CuiCategoryIndicator[] cuiCategoryIndicatorValues = CuiCategoryIndicator.values();
        CuiTypeIndicator[] cuiTypeIndicatorValues = CuiTypeIndicator.values();
        StringBuilder stringBuilder = new StringBuilder(512);
        int i = 0;
        while (i < cuiCategoryIndicatorValues.length) {
            int j = 0;
            while (j < cuiTypeIndicatorValues.length) {
                stringBuilder.setLength(0);
                stringBuilder.append(cuiCategoryIndicatorValues[i].name()).append(" - ").append(cuiTypeIndicatorValues[j].name());
                this.addEnum(new DataClassificationEnum(i * j + j, stringBuilder.toString()));
                ++j;
            }
            ++i;
        }
    }

    public static class DataClassificationEnum
    extends EnumToken {
        public DataClassificationEnum(int ordinal, String name) {
            super(ordinal, name, new NamespaceToken[0]);
        }
    }
}

