/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import java.util.Objects;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public enum PresentationType implements ToMessage
{
    GENERALIZED_EDIT(null),
    SPECIALIZED_EDIT(".working"),
    DIFF(".compare"),
    DIFF_NO_ATTRIBUTES(".compare"),
    F5_DIFF(null),
    PREVIEW(".preview"),
    MERGE(".compare"),
    RENDER_AS_HUMAN_READABLE_TEXT(null),
    DEFAULT_OPEN(null),
    GENERAL_REQUESTED(null),
    PRODUCE_ATTRIBUTE(null),
    WEB_PREVIEW(null);

    private static final String COMPARE_FOLDER = ".compare";
    private static final String PREVIEW_FOLDER = ".preview";
    private static final String WORKING_FOLDER = ".working";
    private String subFolder;

    private PresentationType(String subFolder) {
        this.subFolder = subFolder;
    }

    public String getSubFolder() {
        return this.subFolder;
    }

    public boolean isOneOf(PresentationType ... presentationTypes) {
        if (presentationTypes == null) {
            return false;
        }
        PresentationType[] presentationTypeArray = presentationTypes;
        int n = presentationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            PresentationType presentationType = presentationTypeArray[n2];
            if (this == presentationType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSubFolderDefined() {
        return Objects.nonNull(this.subFolder);
    }

    public boolean matches(PresentationType ... presentationTypes) {
        Conditions.checkExpressionFailOnTrue((presentationTypes.length == 0 ? 1 : 0) != 0, (String)"presentationTypes to match cannot be empty", (Object[])new Object[0]);
        boolean result = false;
        PresentationType[] presentationTypeArray = presentationTypes;
        int n = presentationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            PresentationType presentationType = presentationTypeArray[n2];
            if (this == presentationType) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"PresentationType").indentInc().segment((CharSequence)"Name", (Object)this.name()).segment((CharSequence)"Sub-Folder", (Object)this.subFolder).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

