/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.osee.framework.core.ApiKeyApi;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.exception.OseeAccessDeniedException;

public interface UserService {
    public void clearCaches();

    public TransactionId createUsers(Iterable<UserToken> var1, String var2);

    public String getLoginKey();

    public Collection<IUserGroupArtifactToken> getMyUserGroups();

    default public IUserGroup getOseeAccessAdmin() {
        return this.getUserGroup(CoreUserGroups.OseeAccessAdmin);
    }

    default public IUserGroup getOseeAdmin() {
        return this.getUserGroup(CoreUserGroups.OseeAdmin);
    }

    public UserToken getUser();

    public UserToken getUser(Long var1);

    public UserToken getUserByUserId(String var1);

    public IUserGroup getUserGroup(ArtifactToken var1);

    public IUserGroup getUserGroup(IUserGroupArtifactToken var1);

    public IUserGroup getUserGroupOrNull(IUserGroupArtifactToken var1);

    public UserToken getUserIfLoaded();

    public UserToken getUserIfLoaded(Long var1);

    public Collection<UserToken> getUsers(IUserGroupArtifactToken var1);

    default public boolean isActiveLoginUser() {
        return this.isActiveUser() && this.isLoginUser();
    }

    default public boolean isActiveUser() {
        UserToken userToken;
        block3: {
            try {
                userToken = this.getUser();
                if (!Objects.isNull(userToken)) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return userToken.isActive();
    }

    public boolean isBeforeUserCreation();

    default public boolean isInUserGroup(IUserGroupArtifactToken ... userGroups) {
        Collection<IUserGroupArtifactToken> myUserGroups = this.getMyUserGroups();
        IUserGroupArtifactToken[] iUserGroupArtifactTokenArray = userGroups;
        int n = userGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IUserGroupArtifactToken userGrp = iUserGroupArtifactTokenArray[n2];
            if (myUserGroups.contains(userGrp)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    default public boolean isLoginUser() {
        List<String> loginIdsList;
        block5: {
            UserToken userToken;
            block4: {
                try {
                    userToken = this.getUser();
                    if (!Objects.isNull(userToken)) break block4;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            loginIdsList = userToken.getLoginIds();
            if (!Objects.isNull(loginIdsList)) break block5;
            return false;
        }
        return loginIdsList.size() >= 1;
    }

    default public boolean isUserMember(IUserGroupArtifactToken userGroup, ArtifactId user) {
        return this.isUserMember(userGroup, user.getId());
    }

    public boolean isUserMember(IUserGroupArtifactToken var1, Long var2);

    default public void requireActiveLoginUser() {
        if (!this.isActiveLoginUser()) {
            throw new OseeAccessDeniedException("User %s is not an active login user", this.getUser().toStringWithId());
        }
    }

    default public void requireActiveUser() {
        if (!this.isActiveUser()) {
            throw new OseeAccessDeniedException("User %s is not an active user", this.getUser().toStringWithId());
        }
    }

    default public void requireLoginUser() {
        if (!this.isLoginUser()) {
            throw new OseeAccessDeniedException("User %s is not a login user", this.getUser().toStringWithId());
        }
    }

    default public void requireRole(IUserGroupArtifactToken ... userGroups) throws OseeAccessDeniedException {
        Collection<IUserGroupArtifactToken> roles = this.getMyUserGroups();
        IUserGroupArtifactToken[] iUserGroupArtifactTokenArray = userGroups;
        int n = userGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IUserGroupArtifactToken userGroup = iUserGroupArtifactTokenArray[n2];
            if (roles.contains(userGroup)) {
                return;
            }
            ++n2;
        }
        throw new OseeAccessDeniedException("User %s is not in any of the user groups %s", this.getUser().toStringWithId(), Arrays.deepToString(userGroups));
    }

    public void setBeforeUserCreation(boolean var1);

    public void setUserForCurrentThread(String var1);

    public void setUserForCurrentThread(UserId var1);

    public void removeUserFromCurrentThread();

    public void setUserLoading(boolean var1);

    default public IUserGroup getUserGroupOrSentinel(IUserGroupArtifactToken userGroup) {
        IUserGroup userGroupOrNull = this.getUserGroupOrNull(userGroup);
        if (userGroupOrNull == null) {
            return IUserGroup.SENTINEL;
        }
        return userGroupOrNull;
    }

    public void setUserFromBasic(String var1, ApiKeyApi var2);
}

