/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactTypeJoin;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeMultiplicity;
import org.eclipse.osee.framework.core.data.AttributeTypeArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeBoolean;
import org.eclipse.osee.framework.core.data.AttributeTypeBranchId;
import org.eclipse.osee.framework.core.data.AttributeTypeDate;
import org.eclipse.osee.framework.core.data.AttributeTypeDouble;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeInputStream;
import org.eclipse.osee.framework.core.data.AttributeTypeInteger;
import org.eclipse.osee.framework.core.data.AttributeTypeJoin;
import org.eclipse.osee.framework.core.data.AttributeTypeLong;
import org.eclipse.osee.framework.core.data.AttributeTypeMapEntry;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristic;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.data.DynamicEnumAttributeType;
import org.eclipse.osee.framework.core.data.MaterialIcon;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.OperationTypeToken;
import org.eclipse.osee.framework.core.data.OrcsTypeJoin;
import org.eclipse.osee.framework.core.data.RelationTypeJoin;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.Tuple3Type;
import org.eclipse.osee.framework.core.data.Tuple4Type;
import org.eclipse.osee.framework.core.data.TupleFamilyId;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.jdk.core.type.ChainingArrayList;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.SexFunction;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class OrcsTypeTokens {
    private final List<ArtifactTypeToken> artifactTypes = new ArrayList<ArtifactTypeToken>();
    private final ChainingArrayList<@NonNull AttributeTypeGeneric<?>> attributeTypes = new ChainingArrayList();
    private final ChainingArrayList<@NonNull RelationTypeToken> relationTypes = new ChainingArrayList();
    private final ChainingArrayList<@NonNull ComputedCharacteristic<?>> computedCharacteristics = new ChainingArrayList();
    private final List<OrcsTypeJoin<?, ?>> orcsTypeJoins = new ArrayList();
    private final List<Tuple2Type<?, ?>> tuple2Types = new ArrayList();
    private final List<Tuple3Type<?, ?, ?>> tuple3Types = new ArrayList();
    private final List<Tuple4Type<?, ?, ?, ?>> tuple4Types = new ArrayList();
    private final ChainingArrayList<@NonNull OperationTypeToken> operationTypes = new ChainingArrayList();
    private final NamespaceToken namespace;

    public OrcsTypeTokens(NamespaceToken namespace) {
        this.namespace = namespace;
    }

    public NamespaceToken getNamespace() {
        return this.namespace;
    }

    public AttributeMultiplicity artifactType(Long id, String name, boolean isAbstract, OseeImage image, ArtifactTypeToken ... superTypes) {
        return new AttributeMultiplicity(id, this.namespace, name, isAbstract, image, superTypes);
    }

    public AttributeMultiplicity artifactType(Long id, String name, boolean isAbstract, MaterialIcon icon, ArtifactTypeToken ... superTypes) {
        return new AttributeMultiplicity(id, this.namespace, name, isAbstract, icon, superTypes);
    }

    public AttributeMultiplicity artifactType(Long id, String name, boolean isAbstract, MaterialIcon icon, Set<OperationTypeToken> operationTypes, ArtifactTypeToken ... superTypes) {
        return new AttributeMultiplicity(id, this.namespace, name, isAbstract, icon, operationTypes, superTypes);
    }

    public AttributeMultiplicity artifactType(Long id, String name, boolean isAbstract, OseeImage image, MaterialIcon icon, ArtifactTypeToken ... superTypes) {
        return new AttributeMultiplicity(id, this.namespace, name, isAbstract, image, icon, (List<ArtifactTypeToken>)Collections.asList((Object[])superTypes));
    }

    public AttributeMultiplicity artifactType(Long id, String name, boolean isAbstract, ArtifactTypeToken ... superTypes) {
        return new AttributeMultiplicity(id, this.namespace, name, isAbstract, superTypes);
    }

    public AttributeMultiplicity artifactType(Long id, String name, boolean isAbstract, Set<OperationTypeToken> operationTypes, ArtifactTypeToken ... superTypes) {
        return new AttributeMultiplicity(id, this.namespace, name, isAbstract, operationTypes, superTypes);
    }

    public List<AttributeTypeGeneric<?>> getAttributeTypes() {
        return this.attributeTypes;
    }

    public List<ArtifactTypeToken> getArtifactTypes() {
        return this.artifactTypes;
    }

    public ArtifactTypeToken add(AttributeMultiplicity attributeMultiplicity) {
        ArtifactTypeToken artifactType = attributeMultiplicity.get();
        this.artifactTypes.add(artifactType);
        return artifactType;
    }

    public <V, T extends AttributeTypeGeneric<V>> T add(T attributeType) {
        this.attributeTypes.add(attributeType);
        return attributeType;
    }

    public void validateString(String value) {
        if (Strings.isInvalidOrBlank((String)value)) {
            throw new OseeArgumentException("Invalid Parameter", new Object[0]);
        }
    }

    public RelationTypeToken addNewRelationType(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName) {
        this.validateString(name);
        return (RelationTypeToken)this.relationTypes.addAndReturn((Object)RelationTypeToken.create(id, name, relationTypeMultiplicity, order, artifactTypeA, sideAName, artifactTypeB, sideBName, ArtifactTypeToken.SENTINEL, true));
    }

    public RelationTypeToken addNewRelationType(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName, ArtifactTypeToken relationArtifactType) {
        this.validateString(name);
        return (RelationTypeToken)this.relationTypes.addAndReturn((Object)RelationTypeToken.create(id, name, relationTypeMultiplicity, order, artifactTypeA, sideAName, artifactTypeB, sideBName, relationArtifactType, true));
    }

    public RelationTypeToken addNewRelationType(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName, RelationTypeToken oldRelType) {
        this.validateString(name);
        return (RelationTypeToken)this.relationTypes.addAndReturn((Object)RelationTypeToken.create(id, name, relationTypeMultiplicity, order, artifactTypeA, sideAName, artifactTypeB, sideBName, ArtifactTypeToken.SENTINEL, true, oldRelType));
    }

    public RelationTypeToken addNewRelationType(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName, ArtifactTypeToken relationArtifactType, RelationTypeToken oldRelType) {
        this.validateString(name);
        return (RelationTypeToken)this.relationTypes.addAndReturn((Object)RelationTypeToken.create(id, name, relationTypeMultiplicity, order, artifactTypeA, sideAName, artifactTypeB, sideBName, relationArtifactType, true, oldRelType));
    }

    public RelationTypeToken add(long id, String name, RelationTypeMultiplicity relationTypeMultiplicity, RelationSorter order, ArtifactTypeToken artifactTypeA, String sideAName, ArtifactTypeToken artifactTypeB, String sideBName) {
        this.validateString(name);
        return (RelationTypeToken)this.relationTypes.addAndReturn((Object)RelationTypeToken.create(id, name, relationTypeMultiplicity, order, artifactTypeA, sideAName, artifactTypeB, sideBName));
    }

    public <E1, E2> Tuple2Type<E1, E2> add(TupleFamilyId familyId, long id, Function<Long, E1> valueOfE1, Function<Long, E2> valueOfE2) {
        Tuple2Type<E1, E2> tuple = Tuple2Type.valueOf(familyId, id, valueOfE1, valueOfE2);
        this.tuple2Types.add(tuple);
        return tuple;
    }

    public <E1, E2, E3> Tuple3Type<E1, E2, E3> add(TupleFamilyId familyId, long id, Function<Long, E1> valueOfE1, Function<Long, E2> valueOfE2, Function<Long, E3> valueOfE3) {
        Tuple3Type<E1, E2, E3> tuple = Tuple3Type.valueOf(familyId, id, valueOfE1, valueOfE2, valueOfE3);
        this.tuple3Types.add(tuple);
        return tuple;
    }

    public <E1, E2, E3, E4> Tuple4Type<E1, E2, E3, E4> add(TupleFamilyId familyId, long id, Function<Long, E1> valueOfE1, Function<Long, E2> valueOfE2, Function<Long, E3> valueOfE3, Function<Long, E4> valueOfE4) {
        Tuple4Type<E1, E2, E3, E4> tuple = Tuple4Type.valueOf(familyId, id, valueOfE1, valueOfE2, valueOfE3, valueOfE4);
        this.tuple4Types.add(tuple);
        return tuple;
    }

    public OperationTypeToken add(long id, String name, String description, MaterialIcon icon) {
        this.validateString(name);
        this.validateString(description);
        return (OperationTypeToken)this.operationTypes.addAndReturn((Object)OperationTypeToken.create(id, name, description, icon));
    }

    public void registerTypes(OrcsTokenService tokenService) {
        this.artifactTypes.forEach(tokenService::registerArtifactType);
        this.attributeTypes.forEach(tokenService::registerAttributeType);
        this.relationTypes.forEach(tokenService::registerRelationType);
        this.operationTypes.forEach(tokenService::registerOperationType);
        this.tuple2Types.forEach(tokenService::registerTuple2Type);
        this.tuple3Types.forEach(tokenService::registerTuple3Type);
        this.tuple4Types.forEach(tokenService::registerTuple4Type);
        for (OrcsTypeJoin<?, ?> typeJoin : this.orcsTypeJoins) {
            if (typeJoin instanceof ArtifactTypeJoin) {
                tokenService.registerArtifactTypeJoin((ArtifactTypeJoin)typeJoin);
                continue;
            }
            if (typeJoin instanceof AttributeTypeJoin) {
                tokenService.registerAttributeTypeJoin((AttributeTypeJoin)typeJoin);
                continue;
            }
            if (typeJoin instanceof RelationTypeJoin) {
                tokenService.registerRelationTypeJoin((RelationTypeJoin)typeJoin);
                continue;
            }
            throw new OseeArgumentException("Unexpected join type: ", new Object[]{typeJoin});
        }
    }

    public @NonNull AttributeTypeArtifactId createArtifactId(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, DisplayHint ... displayHints) {
        this.validateString(name);
        AttributeTypeArtifactId attrType = (AttributeTypeArtifactId)this.attributeTypes.addAndReturn((Object)new AttributeTypeArtifactId(id, this.namespace, name, mediaType, description, taggerType));
        if (attrType.getDisplayHints().contains((Object)DisplayHint.MultiLine)) {
            attrType.addDisplayHint(DisplayHint.SingleLine);
        }
        DisplayHint[] displayHintArray = displayHints;
        int n = displayHints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            attrType.getDisplayHints().add(hint);
            ++n2;
        }
        return attrType;
    }

    public @NonNull AttributeTypeArtifactId createArtifactId(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createArtifactId(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), displayHints);
    }

    public @NonNull AttributeTypeArtifactId createArtifactIdNoTag(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createArtifactId(id, name, mediaType, description, TaggerTypeToken.SENTINEL, displayHints);
    }

    public @NonNull AttributeTypeBoolean createBoolean(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, DisplayHint ... displayHints) {
        this.validateString(name);
        return (AttributeTypeBoolean)this.attributeTypes.addAndReturn((Object)new AttributeTypeBoolean(id, this.namespace, name, mediaType, description, taggerType, displayHints));
    }

    public @NonNull AttributeTypeBoolean createBoolean(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createBoolean(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), displayHints);
    }

    public @NonNull AttributeTypeBoolean createBooleanNoTag(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createBoolean(id, name, mediaType, description, TaggerTypeToken.SENTINEL, displayHints);
    }

    public @NonNull AttributeTypeBranchId createBranchId(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        this.validateString(name);
        return (AttributeTypeBranchId)this.attributeTypes.addAndReturn((Object)new AttributeTypeBranchId(id, this.namespace, name, mediaType, description, taggerType));
    }

    public @NonNull AttributeTypeBranchId createBranchId(Long id, String name, String mediaType, String description) {
        return this.createBranchId(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType));
    }

    public @NonNull AttributeTypeBranchId createBranchIdNoTag(Long id, String name, String mediaType, String description) {
        return this.createBranchId(id, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public @NonNull AttributeTypeDate createDate(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, DisplayHint ... displayHints) {
        this.validateString(name);
        AttributeTypeDate type = (AttributeTypeDate)this.attributeTypes.addAndReturn((Object)new AttributeTypeDate(id, this.namespace, name, mediaType, description, taggerType));
        DisplayHint[] displayHintArray = displayHints;
        int n = displayHints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            type.addDisplayHint(hint);
            ++n2;
        }
        return type;
    }

    public @NonNull AttributeTypeDate createDate(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createDate(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), displayHints);
    }

    public @NonNull AttributeTypeDate createDateNoTag(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createDate(id, name, mediaType, description, TaggerTypeToken.SENTINEL, displayHints);
    }

    public @NonNull AttributeTypeDouble createDouble(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, DisplayHint ... displayHints) {
        this.validateString(name);
        AttributeTypeDouble attrType = (AttributeTypeDouble)this.attributeTypes.addAndReturn((Object)new AttributeTypeDouble(id, this.namespace, name, mediaType, description, taggerType, displayHints));
        if (attrType.getDisplayHints().contains((Object)DisplayHint.MultiLine)) {
            attrType.addDisplayHint(DisplayHint.SingleLine);
        }
        return attrType;
    }

    public @NonNull AttributeTypeDouble createDouble(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createDouble(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), displayHints);
    }

    public @NonNull AttributeTypeDouble createDoubleNoTag(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createDouble(id, name, mediaType, description, TaggerTypeToken.SENTINEL, displayHints);
    }

    public @NonNull AttributeTypeInputStream createInputStream(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, String fileExtension) {
        this.validateString(name);
        return (AttributeTypeInputStream)this.attributeTypes.addAndReturn((Object)new AttributeTypeInputStream(id, this.namespace, name, mediaType, description, taggerType, fileExtension));
    }

    public @NonNull AttributeTypeInputStream createInputStream(Long id, String name, String mediaType, String description) {
        return this.createInputStream(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), OrcsTypeTokens.defaultFileExtension(mediaType));
    }

    public @NonNull AttributeTypeInputStream createInputStream(Long id, String name, String mediaType, String description, String fileExtension) {
        return this.createInputStream(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), fileExtension);
    }

    public @NonNull AttributeTypeInputStream createInputStreamNoTag(Long id, String name, String mediaType, String description) {
        return this.createInputStream(id, name, mediaType, description, TaggerTypeToken.SENTINEL, OrcsTypeTokens.defaultFileExtension(mediaType));
    }

    public @NonNull AttributeTypeInputStream createInputStreamNoTag(Long id, String name, String mediaType, String description, String fileExtension) {
        return this.createInputStream(id, name, mediaType, description, TaggerTypeToken.SENTINEL, fileExtension);
    }

    public @NonNull AttributeTypeInteger createInteger(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, DisplayHint ... displayHints) {
        this.validateString(name);
        AttributeTypeInteger attrType = (AttributeTypeInteger)this.attributeTypes.addAndReturn((Object)new AttributeTypeInteger(id, this.namespace, name, mediaType, description, taggerType));
        if (attrType.getDisplayHints().contains((Object)DisplayHint.MultiLine)) {
            attrType.addDisplayHint(DisplayHint.SingleLine);
        }
        DisplayHint[] displayHintArray = displayHints;
        int n = displayHints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            attrType.addDisplayHint(hint);
            ++n2;
        }
        return attrType;
    }

    public @NonNull AttributeTypeInteger createInteger(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createInteger(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), displayHints);
    }

    public @NonNull AttributeTypeInteger createIntegerNoTag(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createInteger(id, name, mediaType, description, TaggerTypeToken.SENTINEL, displayHints);
    }

    public @NonNull AttributeTypeLong createLong(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, DisplayHint ... displayHints) {
        this.validateString(name);
        AttributeTypeLong attrType = (AttributeTypeLong)this.attributeTypes.addAndReturn((Object)new AttributeTypeLong(id, this.namespace, name, mediaType, description, taggerType));
        if (attrType.getDisplayHints().contains((Object)DisplayHint.MultiLine)) {
            attrType.addDisplayHint(DisplayHint.SingleLine);
        }
        DisplayHint[] displayHintArray = displayHints;
        int n = displayHints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            attrType.addDisplayHint(hint);
            ++n2;
        }
        return attrType;
    }

    public @NonNull AttributeTypeLong createLong(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createLong(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), displayHints);
    }

    public @NonNull AttributeTypeLong createLongNoTag(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createLong(id, name, mediaType, description, TaggerTypeToken.SENTINEL, displayHints);
    }

    public <T extends AttributeTypeEnum<? extends EnumToken>> @NonNull T createEnum(T attributeType, DisplayHint ... displayHints) {
        AttributeTypeEnum type = (AttributeTypeEnum)this.attributeTypes.addAndReturn(attributeType);
        DisplayHint[] displayHintArray = displayHints;
        int n = displayHints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            type.addDisplayHint(hint);
            ++n2;
        }
        return (T)type;
    }

    public <T extends AttributeTypeEnum<? extends EnumToken>> @NonNull T createEnumNoTag(T attributeType, DisplayHint ... displayHints) {
        AttributeTypeEnum type = (AttributeTypeEnum)this.attributeTypes.addAndReturn(attributeType);
        DisplayHint[] displayHintArray = displayHints;
        int n = displayHints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            type.addDisplayHint(hint);
            ++n2;
        }
        return (T)type;
    }

    public @NonNull DynamicEnumAttributeType createEnum(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, DisplayHint ... displayHints) {
        this.validateString(name);
        DynamicEnumAttributeType type = (DynamicEnumAttributeType)this.attributeTypes.addAndReturn((Object)new DynamicEnumAttributeType(id, this.namespace, name, mediaType, description, taggerType));
        DisplayHint[] displayHintArray = displayHints;
        int n = displayHints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            type.addDisplayHint(hint);
            ++n2;
        }
        return type;
    }

    public @NonNull DynamicEnumAttributeType createEnum(Long id, String name, String mediaType, String description) {
        return this.createEnum(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), new DisplayHint[0]);
    }

    public <T extends AttributeTypeEnum<? extends EnumToken>> @NonNull T createEnum(AttributeEnumConstructor<T> attributeEnumConstructor, Long identifier, String name, String description, String mediaType, NamespaceToken namespaceToken, TaggerTypeToken taggerTypeToken, DisplayHint ... displayHints) {
        this.validateString(name);
        @NonNull AttributeTypeEnum type = (AttributeTypeEnum)this.attributeTypes.addAndReturn(attributeEnumConstructor.apply(identifier, name, description, taggerTypeToken, mediaType, namespaceToken));
        DisplayHint[] displayHintArray = displayHints;
        int n = displayHints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            type.addDisplayHint(hint);
            ++n2;
        }
        return (T)type;
    }

    public <T extends AttributeTypeEnum<? extends EnumToken>> @NonNull T createEnum(AttributeEnumConstructorNoDescription<T> attributeEnumConstructor, Long identifier, String name, String mediaType, DisplayHint ... displayHints) {
        this.validateString(name);
        AttributeTypeEnum type = (AttributeTypeEnum)this.attributeTypes.addAndReturn(attributeEnumConstructor.apply(identifier, name, OrcsTypeTokens.determineTaggerType(mediaType), mediaType, this.namespace));
        DisplayHint[] displayHintArray = displayHints;
        int n = displayHints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            type.addDisplayHint(hint);
            ++n2;
        }
        return (T)type;
    }

    public <T extends AttributeTypeEnum<? extends EnumToken>> @NonNull T createEnum(AttributeEnumConstructor<T> attributeEnumConstructor, AttributeDisplayNameAndDescriptionSupplier attributeDisplayNameAndDescriptionSupplier, Long identifier, String mediaType, NamespaceToken namespaceToken, TaggerTypeToken taggerTypeToken) {
        Pair<String, String> nameAndDescription = attributeDisplayNameAndDescriptionSupplier.get();
        AttributeTypeEnum attrType = (AttributeTypeEnum)this.attributeTypes.addAndReturn(attributeEnumConstructor.apply(identifier, (String)nameAndDescription.getFirst(), (String)nameAndDescription.getSecond(), taggerTypeToken, mediaType, namespaceToken));
        attrType.addDisplayHint(DisplayHint.MultiLine);
        return (T)attrType;
    }

    public <T extends AttributeTypeEnum<? extends EnumToken>> @NonNull T createEnum(AttributeEnumConstructorNoDescription<T> attributeEnumConstructorNoDescription, AttributeDisplayNameSupplier attributeDisplayNameSupplier, Long identifier, String mediaType, NamespaceToken namespaceToken, TaggerTypeToken taggerTypeToken, DisplayHint ... displayHints) {
        String name = attributeDisplayNameSupplier.get();
        AttributeTypeEnum attrType = (AttributeTypeEnum)this.attributeTypes.addAndReturn(attributeEnumConstructorNoDescription.apply(identifier, name, taggerTypeToken, mediaType, namespaceToken));
        attrType.addDisplayHint(DisplayHint.MultiLine);
        DisplayHint[] displayHintArray = displayHints;
        int n = displayHints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            attrType.addDisplayHint(hint);
            ++n2;
        }
        return (T)attrType;
    }

    public @NonNull AttributeTypeString createString(Long id, String name, String mediaType, String description, TaggerTypeToken taggerType, String fileExtension, Set<OperationTypeToken> operationTypes, DisplayHint ... displayHints) {
        this.validateString(name);
        return (AttributeTypeString)this.attributeTypes.addAndReturn((Object)new AttributeTypeString(id, this.namespace, name, mediaType, description, taggerType, fileExtension, operationTypes, displayHints));
    }

    public @NonNull AttributeTypeString createString(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createString(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), OrcsTypeTokens.defaultFileExtension(mediaType), null, displayHints);
    }

    public @NonNull AttributeTypeString createString(Long id, String name, String mediaType, String description, Set<OperationTypeToken> operationTypes, DisplayHint ... displayHints) {
        return this.createString(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), OrcsTypeTokens.defaultFileExtension(mediaType), operationTypes, displayHints);
    }

    public @NonNull AttributeTypeString createString(Long id, String name, String mediaType, String description, String fileExtension, DisplayHint ... displayHints) {
        return this.createString(id, name, mediaType, description, OrcsTypeTokens.determineTaggerType(mediaType), fileExtension, null, displayHints);
    }

    public @NonNull AttributeTypeString createStringNoTag(Long id, String name, String mediaType, String description, DisplayHint ... displayHints) {
        return this.createString(id, name, mediaType, description, TaggerTypeToken.SENTINEL, OrcsTypeTokens.defaultFileExtension(mediaType), null, displayHints);
    }

    public @NonNull AttributeTypeString createStringNoTag(Long id, String name, String mediaType, String description, String fileExtension, DisplayHint ... displayHints) {
        return this.createString(id, name, mediaType, description, TaggerTypeToken.SENTINEL, fileExtension, null, displayHints);
    }

    public @NonNull AttributeTypeString createString(AttributeDisplayNameAndDescriptionSupplier attributeNameAndDescriptionSupplier, Long identifier, String mediaType, TaggerTypeToken taggerTypeToken, NamespaceToken namespaceToken, String fileExtension, DisplayHint ... displayHints) {
        Pair<String, String> nameAndDescription = attributeNameAndDescriptionSupplier.get();
        return (AttributeTypeString)this.attributeTypes.addAndReturn((Object)new AttributeTypeString(identifier, namespaceToken, (String)nameAndDescription.getFirst(), mediaType, (String)nameAndDescription.getSecond(), taggerTypeToken, fileExtension, null, displayHints));
    }

    public @NonNull AttributeTypeMapEntry createMapEntry(Long id, String name, String description, Supplier<String> keyDescriptionSupplier, Supplier<String> valueDescriptionSupplier, String defaultKey, String defaultValue) {
        this.validateString(name);
        return (AttributeTypeMapEntry)this.attributeTypes.addAndReturn((Object)new AttributeTypeMapEntry(id, this.namespace, name, description, keyDescriptionSupplier, valueDescriptionSupplier, defaultKey, defaultValue));
    }

    public <T, U extends ComputedCharacteristic<T>> U createComp(SexFunction<Long, String, TaggerTypeToken, NamespaceToken, String, List<AttributeTypeGeneric<T>>, U> computationCharacteristicConstructor, Long id, String name, String description, AttributeTypeGeneric<T> ... typesToCompute) {
        this.validateString(name);
        return (U)((ComputedCharacteristic)this.computedCharacteristics.addAndReturn((Object)((ComputedCharacteristic)computationCharacteristicConstructor.apply((Object)id, (Object)name, (Object)TaggerTypeToken.PlainTextTagger, (Object)this.namespace, (Object)description, Arrays.asList(typesToCompute)))));
    }

    public <T, U extends ComputedCharacteristic<T>> U createCompNoTag(SexFunction<Long, String, TaggerTypeToken, NamespaceToken, String, List<AttributeTypeGeneric<T>>, U> computationCharacteristicConstructor, Long id, String name, String description, AttributeTypeGeneric<T> ... typesToCompute) {
        this.validateString(name);
        return (U)((ComputedCharacteristic)this.computedCharacteristics.addAndReturn((Object)((ComputedCharacteristic)computationCharacteristicConstructor.apply((Object)id, (Object)name, (Object)TaggerTypeToken.SENTINEL, (Object)this.namespace, (Object)description, Arrays.asList(typesToCompute)))));
    }

    public <U extends ComputedCharacteristic<EnumToken>> U createComp(SexFunction<Long, String, TaggerTypeToken, NamespaceToken, String, List<AttributeTypeGeneric<EnumToken>>, U> computationCharacteristicConstructor, Long id, String name, String description, AttributeTypeEnum<?> ... typesToCompute) {
        this.validateString(name);
        return (U)((ComputedCharacteristic)this.computedCharacteristics.addAndReturn((Object)((ComputedCharacteristic)computationCharacteristicConstructor.apply((Object)id, (Object)name, (Object)TaggerTypeToken.PlainTextTagger, (Object)this.namespace, (Object)description, this.createEnumList(typesToCompute)))));
    }

    public <U extends ComputedCharacteristic<EnumToken>> U createCompNoTag(SexFunction<Long, String, TaggerTypeToken, NamespaceToken, String, List<AttributeTypeGeneric<EnumToken>>, U> computationCharacteristicConstructor, Long id, String name, String description, AttributeTypeEnum<?> ... typesToCompute) {
        this.validateString(name);
        return (U)((ComputedCharacteristic)this.computedCharacteristics.addAndReturn((Object)((ComputedCharacteristic)computationCharacteristicConstructor.apply((Object)id, (Object)name, (Object)TaggerTypeToken.SENTINEL, (Object)this.namespace, (Object)description, this.createEnumList(typesToCompute)))));
    }

    private List<AttributeTypeGeneric<EnumToken>> createEnumList(AttributeTypeEnum<?>[] typesToCompute) {
        ArrayList<AttributeTypeGeneric<EnumToken>> enumsToCompute = new ArrayList<AttributeTypeGeneric<EnumToken>>();
        AttributeTypeEnum<?>[] attributeTypeEnumArray = typesToCompute;
        int n = typesToCompute.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeTypeEnum<?> enumType = attributeTypeEnumArray[n2];
            enumsToCompute.add(enumType.getAsEnumToken());
            ++n2;
        }
        return enumsToCompute;
    }

    public static TaggerTypeToken determineTaggerType(String mediaType) {
        switch (mediaType) {
            case "text/html": 
            case "application/msword": {
                return TaggerTypeToken.XmlTagger;
            }
        }
        return TaggerTypeToken.PlainTextTagger;
    }

    public static String defaultFileExtension(String mediaType) {
        switch (mediaType) {
            case "application/zip": 
            case "text/plain": {
                return "txt";
            }
            case "text/xml": 
            case "application/msword": {
                return "xml";
            }
            case "text/html": {
                return "html";
            }
            case "application/octet-stream": 
            case "image/*": {
                return "bin";
            }
            case "text/markdown": {
                return "md";
            }
        }
        return "";
    }

    public int size() {
        return this.artifactTypes.size() + this.attributeTypes.size() + this.relationTypes.size() + this.tuple2Types.size() + this.tuple3Types.size() + this.tuple4Types.size() + this.operationTypes.size();
    }

    public String toString() {
        return this.namespace + ": " + this.size();
    }

    public ArtifactTypeJoin artifactTypeJoin(String name, ArtifactTypeToken ... artifactTypes) {
        ArtifactTypeJoin typeJoin = new ArtifactTypeJoin(name, artifactTypes);
        this.orcsTypeJoins.add(typeJoin);
        return typeJoin;
    }

    public AttributeTypeJoin attributeTypeJoin(String name, AttributeTypeToken ... attributeTypes) {
        AttributeTypeJoin typeJoin = new AttributeTypeJoin(name, attributeTypes);
        this.orcsTypeJoins.add(typeJoin);
        return typeJoin;
    }

    public RelationTypeJoin relationTypeJoin(String name, RelationTypeToken ... relationTypes) {
        RelationTypeJoin typeJoin = new RelationTypeJoin(name, relationTypes);
        this.orcsTypeJoins.add(typeJoin);
        return typeJoin;
    }

    @FunctionalInterface
    public static interface AttributeDisplayNameAndDescriptionSupplier {
        public Pair<String, String> get();
    }

    @FunctionalInterface
    public static interface AttributeDisplayNameSupplier {
        public String get();
    }

    @FunctionalInterface
    public static interface AttributeEnumConstructor<T extends AttributeTypeEnum<? extends EnumToken>> {
        public T apply(Long var1, String var2, String var3, TaggerTypeToken var4, String var5, NamespaceToken var6);
    }

    @FunctionalInterface
    public static interface AttributeEnumConstructorNoDescription<T extends AttributeTypeEnum<? extends EnumToken>> {
        public T apply(Long var1, String var2, TaggerTypeToken var3, String var4, NamespaceToken var5);
    }
}

