/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.Objects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class BranchSpecification
implements ToMessage {
    protected final BranchId branchId;

    static ArtifactId cleanArtifactId(ArtifactId artifactId) {
        return Objects.nonNull(artifactId) ? (ArtifactId.SENTINEL.equals(artifactId) ? ArtifactId.SENTINEL : ArtifactId.create(artifactId)) : ArtifactId.SENTINEL;
    }

    static BranchId cleanBranchId(BranchId branchId, ArtifactId viewId) {
        boolean branchIdViewIdIsValid;
        boolean viewIdIsValid;
        boolean branchIdIsValid = Objects.nonNull(branchId) && !Id.SENTINEL.equals(branchId.getId());
        boolean bl = viewIdIsValid = Objects.nonNull(viewId) && !ArtifactId.SENTINEL.equals(viewId);
        if (!branchIdIsValid && viewIdIsValid) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"BranchSpecification::cleanBranchId, branchId is invalid and viewId is valid.").indentInc().segment((CharSequence)"branchId", (Object)(Objects.isNull(branchId) ? "(null)" : branchId.getIdString())).segment((CharSequence)"viewId", (Object)viewId.getIdString()).toString());
        }
        boolean bl2 = branchIdViewIdIsValid = Objects.nonNull(branchId) && Objects.nonNull(branchId.getViewId()) && !ArtifactId.SENTINEL.equals(branchId.getViewId());
        if (!branchIdIsValid && branchIdViewIdIsValid) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"BranchSpecification::cleanBranchId, branchId is invalid and view identifier in branchId is valid.").indentInc().segment((CharSequence)"branchId", (Object)(Objects.isNull(branchId) ? "(null)" : branchId.getIdString())).segment((CharSequence)"branchId.getViewId()", (Object)branchId.getViewId().getIdString()).toString());
        }
        if (branchIdIsValid && branchIdViewIdIsValid && viewIdIsValid && !branchId.getViewId().equals(viewId)) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"BranchSpecification::cleanBranchId, view in branchId conflicts with viewId.").indentInc().segment((CharSequence)"branchId", (Object)branchId.getIdString()).segment((CharSequence)"branchId.getViewId()", (Object)branchId.getViewId().getIdString()).segment((CharSequence)"viewId", (Object)viewId.getIdString()).toString());
        }
        if (!branchIdIsValid) {
            return BranchId.SENTINEL;
        }
        Long branchIdLong = branchId.getId();
        if (branchIdViewIdIsValid) {
            return BranchId.create(branchIdLong, BranchSpecification.cleanArtifactId(branchId.getViewId()));
        }
        if (viewIdIsValid) {
            return BranchId.create(branchIdLong, BranchSpecification.cleanArtifactId(viewId));
        }
        return BranchId.create(branchIdLong, ArtifactId.SENTINEL);
    }

    public BranchSpecification(BranchId branchId) {
        this(branchId, ArtifactId.SENTINEL);
    }

    public BranchSpecification(BranchId branchId, ArtifactId viewId) {
        this.branchId = BranchSpecification.cleanBranchId(branchId, viewId);
    }

    public BranchId getBranchId() {
        return this.branchId;
    }

    public BranchId getBranchIdWithOutViewId() {
        return BranchId.valueOf(this.branchId.getId());
    }

    public ArtifactId getViewId() {
        return this.branchId.getViewId();
    }

    public boolean hasView() {
        return !this.branchId.getViewId().equals(ArtifactId.SENTINEL);
    }

    public int hashCode() {
        Long a = this.branchId.getId();
        Long b = this.branchId.getViewId().getId();
        long r = Long.rotateLeft((a << 5) - a, 24) ^ b * b - b;
        return (int)(r >> 32 ^ r) & 0xFFFFFFFF;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BranchSpecification)) {
            return false;
        }
        BranchSpecification otherBranchSpecification = (BranchSpecification)other;
        return this.branchId.getId().equals(otherBranchSpecification.branchId.getId()) && this.branchId.getViewId().getId().equals(otherBranchSpecification.getViewId().getId());
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.title((CharSequence)"Branch Specification").indentInc().segment((CharSequence)"Branch Identifier", (Object)(this.branchId.getId().equals(Id.SENTINEL) ? "SENTINEL" : this.branchId.getIdString())).segment((CharSequence)"View Identifier", (Object)(this.branchId.getViewId().getId().equals(Id.SENTINEL) ? "SENTINEL" : this.branchId.getViewId().getIdString())).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

