/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.KeyScopeContainer;
import org.eclipse.osee.framework.core.data.UserId;

public class ApiKey {
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private String name;
    private List<KeyScopeContainer> scopes;
    private String creationDate;
    private String expirationDate;
    private String hashedValue;
    private String uniqueID;
    private final UserId userArtId;

    public ApiKey() {
        this.name = "";
        this.scopes = new ArrayList<KeyScopeContainer>();
        this.creationDate = "";
        this.expirationDate = "";
        this.hashedValue = "";
        this.uniqueID = "";
        this.userArtId = UserId.SENTINEL;
    }

    public ApiKey(String name, List<KeyScopeContainer> scopes, String creationDate, String expirationDate, String hashedValue, String uniqueID) {
        this.name = name;
        this.scopes = scopes;
        this.creationDate = creationDate;
        this.expirationDate = expirationDate;
        this.hashedValue = "";
        this.uniqueID = uniqueID != null ? uniqueID : "";
        this.userArtId = UserId.SENTINEL;
    }

    public ApiKey(String name, List<KeyScopeContainer> scopes, String creationDate, String expirationDate, String uniqueID, UserId userArtId) {
        this.name = name;
        this.scopes = scopes;
        this.creationDate = creationDate;
        this.expirationDate = expirationDate;
        this.hashedValue = "";
        this.uniqueID = uniqueID != null ? uniqueID : "";
        this.userArtId = userArtId;
    }

    public ApiKey(String name, List<KeyScopeContainer> scopes, String creationDate, String expirationDate, String uniqueID) {
        this.name = name;
        this.scopes = scopes;
        this.creationDate = creationDate;
        this.expirationDate = expirationDate;
        this.hashedValue = "";
        this.uniqueID = uniqueID != null ? uniqueID : "";
        this.userArtId = UserId.SENTINEL;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<KeyScopeContainer> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<KeyScopeContainer> scopes) {
        this.scopes = scopes;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getHashedValue() {
        return this.hashedValue;
    }

    public void setHashedValue(String hashedValue) {
        this.hashedValue = hashedValue;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    @JsonIgnore
    public boolean isExpired() {
        LocalDate expirationDate;
        LocalDate currentDate = LocalDate.now();
        return !currentDate.isEqual(expirationDate = LocalDate.parse(this.expirationDate, this.dateFormatter)) && !currentDate.isBefore(expirationDate);
    }

    public String toString() {
        return "ApiKey{name='" + this.name + '\'' + ", scopes=" + this.scopes + ", creationDate='" + this.creationDate + '\'' + ", expirationDate='" + this.expirationDate + '\'' + ", hashedValue='" + this.hashedValue + '\'' + ", uniqueID='" + this.uniqueID + '\'' + '}';
    }

    public UserId getUserArtId() {
        return this.userArtId;
    }
}

