/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.coverage.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.coverage.internal.PartitionResultToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class PartitionDefToken
extends ArtifactAccessorResultWithoutGammas {
    public static final PartitionDefToken SENTINEL = new PartitionDefToken();
    private final Comparator<Date> dateComparator = new DateComparator();
    private boolean active = true;
    private String team = "";
    private String lastAuthor = "";
    private Date lastModified = new Date();
    private String modifiedFlag = "";
    private String coverageImportPath = "";
    private String coverageImportApi = "";
    private Date latestExecutionDate = new Date();
    private int latestPassedCount = 0;
    private int latestFailedCount = 0;
    private int latestCoveredCount = 0;
    private int latestModifyCount = 0;
    private String latestResult = "";
    private String description = "";
    private String notes = "";
    private String errors = "";
    private List<PartitionResultToken> partitionResults;

    public PartitionDefToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public PartitionDefToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setActive((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Active, (Object)true));
        this.setTeam(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.TeamName, ""));
        this.setLastAuthor(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.LastAuthor, ""));
        this.setLastModified((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.LastModifiedDate, (Object)new Date()));
        this.setModifiedFlag(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ModifiedFlag, ""));
        this.setCoverageImportPath(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageImportPath, ""));
        this.setCoverageImportApi(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageImportApi, ""));
        this.setDescription(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, ""));
        this.setNotes(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Notes, ""));
        this.setErrors("");
        this.setPartitionResults(art.getRelated(CoreRelationTypes.PartitionDefToPartitionResult_PartitionResult).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).sorted(Comparator.comparing(this::getExecutionDateByAttr, this.dateComparator)).filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new PartitionResultToken((ArtifactReadable)a)).collect(Collectors.toList()));
        if (!this.getPartitionResults().isEmpty()) {
            PartitionResultToken resultToken = this.getPartitionResults().get(0);
            this.setLatestExecutionDate(resultToken.getExecutionDate());
            this.setLatestPassedCount(resultToken.getPassedCount());
            this.setLatestFailedCount(resultToken.getFailedCount());
            this.setLatestCoveredCount(resultToken.getCoveredCount());
            this.setLatestModifyCount(resultToken.getModifyCount());
            this.setLatestResult(resultToken.getResult());
        }
    }

    public PartitionDefToken(Long id, String name) {
        super(id, name);
        this.setActive(true);
        this.setTeam("");
        this.setLastAuthor("");
        this.setLastModified(new Date());
        this.setModifiedFlag("");
        this.setCoverageImportPath("");
        this.setCoverageImportApi("");
        this.setLatestExecutionDate(new Date());
        this.setLatestPassedCount(0);
        this.setLatestFailedCount(0);
        this.setLatestCoveredCount(0);
        this.setLatestModifyCount(0);
        this.setLatestResult("");
        this.setDescription("");
        this.setNotes("");
        this.setErrors("");
        this.setPartitionResults(new ArrayList<PartitionResultToken>());
    }

    public PartitionDefToken(Exception ex) {
        this.setErrors(ex.toString());
    }

    public PartitionDefToken() {
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String getLastAuthor() {
        return this.lastAuthor;
    }

    public void setLastAuthor(String lastAuthor) {
        this.lastAuthor = lastAuthor;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getModifiedFlag() {
        return this.modifiedFlag;
    }

    public void setModifiedFlag(String modifiedFlag) {
        this.modifiedFlag = modifiedFlag;
    }

    public String getCoverageImportPath() {
        return this.coverageImportPath;
    }

    public void setCoverageImportPath(String coverageImportPath) {
        this.coverageImportPath = coverageImportPath;
    }

    public String getCoverageImportApi() {
        return this.coverageImportApi;
    }

    public void setCoverageImportApi(String coverageImportApi) {
        this.coverageImportApi = coverageImportApi;
    }

    public Date getLatestExecutionDate() {
        return this.latestExecutionDate;
    }

    public void setLatestExecutionDate(Date latestExecutionDate) {
        this.latestExecutionDate = latestExecutionDate;
    }

    public int getLatestPassedCount() {
        return this.latestPassedCount;
    }

    public void setLatestPassedCount(int latestPassedCount) {
        this.latestPassedCount = latestPassedCount;
    }

    public int getLatestFailedCount() {
        return this.latestFailedCount;
    }

    public void setLatestFailedCount(int latestFailedCount) {
        this.latestFailedCount = latestFailedCount;
    }

    public int getLatestCoveredCount() {
        return this.latestCoveredCount;
    }

    public void setLatestCoveredCount(int latestCoveredCount) {
        this.latestCoveredCount = latestCoveredCount;
    }

    public int getLatestModifyCount() {
        return this.latestModifyCount;
    }

    public void setLatestModifyCount(int latestModifyCount) {
        this.latestModifyCount = latestModifyCount;
    }

    public String getLatestResult() {
        return this.latestResult;
    }

    public void setLatestResult(String latestResult) {
        this.latestResult = latestResult;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public List<PartitionResultToken> getPartitionResults() {
        return this.partitionResults;
    }

    public void setPartitionResults(List<PartitionResultToken> partitionResults) {
        this.partitionResults = partitionResults;
    }

    public String getErrors() {
        return this.errors;
    }

    public void setErrors(String errors) {
        this.errors = errors;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.Active, Boolean.toString(this.getActive()));
        values.put(CoreAttributeTypes.TeamName, this.getTeam());
        values.put(CoreAttributeTypes.LastAuthor, this.getLastAuthor());
        values.put(CoreAttributeTypes.LastModifiedDate, Long.toString(this.getLastModified().getTime()));
        values.put(CoreAttributeTypes.ModifiedFlag, this.getModifiedFlag());
        values.put(CoreAttributeTypes.CoverageImportPath, this.getCoverageImportPath());
        values.put(CoreAttributeTypes.CoverageImportApi, this.getCoverageImportApi());
        values.put(CoreAttributeTypes.Description, this.getDescription());
        values.put(CoreAttributeTypes.Notes, this.getNotes());
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.CoveragePartitionDef.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.CoveragePartitionDef.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }

    public Date getExecutionDateByAttr(ArtifactReadable art) {
        return (Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ExecutionDate);
    }

    public class DateComparator
    implements Comparator<Date> {
        @Override
        public int compare(Date date1, Date date2) {
            if (date1 == null && date2 == null) {
                return 0;
            }
            if (date1 == null) {
                return 1;
            }
            if (date2 == null) {
                return -1;
            }
            return date1.compareTo(date2);
        }
    }
}

