/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs;

import java.sql.JDBCType;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.jdbc.SqlColumn;
import org.eclipse.osee.jdbc.SqlTable;

public class OseeDb {
    public static final SqlTable ARTIFACT_TABLE = new SqlTable("osee_artifact", "art", ObjectType.ARTIFACT);
    public static final SqlColumn ARTIFACT_ART_ID = ARTIFACT_TABLE.addColumn("ART_ID", JDBCType.BIGINT);
    public static final SqlColumn ARTIFACT_GAMMA_ID = ARTIFACT_TABLE.addColumn("GAMMA_ID", JDBCType.BIGINT);
    public static final SqlColumn ARTIFACT_ART_TYPE_ID = ARTIFACT_TABLE.addColumn("ART_TYPE_ID", JDBCType.BIGINT);
    public static final SqlColumn ARTIFACT_GUID = ARTIFACT_TABLE.addVarCharColumn("GUID", 22, false);
    public static final SqlTable ATTRIBUTE_TABLE;
    public static final SqlColumn ATTRIBUTE_ATRR_ID;
    public static final SqlColumn ATTRIBUTE_GAMMA_ID;
    public static final SqlColumn ATTRIBUTE_ART_ID;
    public static final SqlColumn ATTRIBUTE_ATTR_TYPE_ID;
    public static final SqlColumn ATTRIBUTE_VALUE;
    public static final SqlColumn ATTRIBUTE_URI;
    public static final SqlTable ATTRIBUTE_SOURCE_TABLE;
    public static final SqlColumn ATTRIBUTE_SOURCE_TABLE_GAMMA_ID;
    public static final SqlColumn ATTRIBUTE_SOURCE_TABLE_ART_ID;
    public static final SqlColumn ATTRIBUTE_SOURCE_TABLE_TYPE_ID;
    public static final SqlColumn ATTRIBUTE_SOURCE_TABLE_ATTR_ORDER;
    public static final SqlColumn ATTRIBUTE_SOURCE_TABLE_STRING_VALUE;
    public static final SqlColumn ATTRIBUTE_SOURCE_TABLE_NUMBER_VALUE;
    public static final SqlTable ATTRIBUTE_BINARY_TABLE;
    public static final SqlColumn ATTRIBUTE_BINARY_TABLE_GAMMA_ID;
    public static final SqlColumn ATTRIBUTE_BINARY_TABLE_VALUE;
    public static final SqlTable RELATION_TABLE;
    public static final SqlColumn RELATION_LINK_REL_LINK_TYPE_ID;
    public static final SqlColumn RELATION_LINK_A_ART_ID;
    public static final SqlColumn RELATION_LINK_B_ART_ID;
    public static final SqlColumn RELATION_LINK_GAMMA_ID;
    public static final SqlColumn RELATION_LINK_REL_LINK_ID;
    public static final SqlColumn RELATION_LINK_RATIONALE;
    public static final SqlTable RELATION_TABLE2;
    public static final SqlColumn RELATION_REL_TYPE;
    public static final SqlColumn RELATION_A_ART_ID;
    public static final SqlColumn RELATION_B_ART_ID;
    public static final SqlColumn RELATION_REL_ART_ID;
    public static final SqlColumn RELATION_REL_ORDER;
    public static final SqlColumn RELATION_GAMMA_ID;
    public static final SqlTable BRANCH_TABLE;
    public static final SqlColumn BRANCH_ID;
    public static final SqlColumn BRANCH_TYPE;
    public static final SqlColumn BRANCH_STATE;
    public static final SqlColumn BRANCH_NAME;
    public static final SqlColumn BRANCH_PARENT_BRANCH_ID;
    public static final SqlColumn BRANCH_PARENT_TRANSACTION_ID;
    public static final SqlColumn BRANCH_BASELINE_TRANSACTION_ID;
    public static final SqlColumn BRANCH_ASSOCIATED_ART_ID;
    public static final SqlColumn BRANCH_ARCHIVED;
    public static final SqlColumn BRANCH_INHERIT_ACCESS_CONTROL;
    public static final SqlTable TXS_TABLE;
    public static final SqlColumn TXS_BRANCH_ID;
    public static final SqlColumn TXS_GAMMA_ID;
    public static final SqlColumn TXS_TRANSACTION_ID;
    public static final SqlColumn TXS_TX_CURRENT;
    public static final SqlColumn TXS_MOD_TYPE;
    public static final SqlColumn TXS_APP_ID;
    public static final SqlTable TXS_ARCHIVED_TABLE;
    public static final SqlColumn TXS_ARCHIVED_BRANCH_ID;
    public static final SqlColumn TXS_ARCHIVED_GAMMA_ID;
    public static final SqlColumn TXS_ARCHIVED_TRANSACTION_ID;
    public static final SqlColumn TXS_ARCHIVED_TX_CURRENT;
    public static final SqlColumn TXS_ARCHIVED_MOD_TYPE;
    public static final SqlColumn TXS_ARCHIVED_APP_ID;
    public static final SqlTable TX_DETAILS_TABLE;
    public static final SqlColumn TX_DETAILS_TX_BRANCH_ID;
    public static final SqlColumn TX_DETAILS_TRANSACTION_ID;
    public static final SqlColumn TX_DETAILS_AUTHOR;
    public static final SqlColumn TX_DETAILS_TIME;
    public static final SqlColumn TX_DETAILS_OSEE_COMMENT;
    public static final SqlColumn TX_DETAILS_TX_TYPE;
    public static final SqlColumn TX_DETAILS_TX_COMMIT_ART_ID;
    public static final SqlColumn TX_DETAILS_BUILD_ID;
    public static final SqlTable OSEE_PERMISSION_TABLE;
    public static final SqlColumn OSEE_PERMISSION_PERMISSION_ID;
    public static final SqlColumn OSEE_PERMISSION_PERMISSION_NAME;
    public static final SqlTable OSEE_ARTIFACT_ACL_TABLE;
    public static final SqlColumn OSEE_ARTIFACT_ACL_ART_ID;
    public static final SqlColumn OSEE_ARTIFACT_ACL_PRIVILEGE_ENTITY_ID;
    public static final SqlColumn OSEE_ARTIFACT_ACL_BRANCH_ID;
    public static final SqlColumn OSEE_ARTIFACT_ACL_PERMISSION_ID;
    public static final SqlTable OSEE_BRANCH_ACL_TABLE;
    public static final SqlColumn OSEE_BRANCH_ACL_BRANCH_ID;
    public static final SqlColumn OSEE_BRANCH_ACL_PRIVILEGE_ENTITY_ID;
    public static final SqlColumn OSEE_BRANCH_ACL_PERMISSION_ID;
    public static final SqlTable OSEE_SEARCH_TAGS_TABLE;
    public static final SqlColumn OSEE_SEARCH_TAGS_CODED_TAG_ID;
    public static final SqlColumn OSEE_SEARCH_TAGS_GAMMA_ID;
    public static final SqlTable OSEE_TAG_GAMMA_QUEUE_TABLE;
    public static final SqlColumn OSEE_TAG_GAMMA_QUEUE_QUERY_ID;
    public static final SqlColumn OSEE_TAG_GAMMA_QUEUE_GAMMA_ID;
    public static final SqlTable OSEE_SEQUENCE_TABLE;
    public static final SqlColumn OSEE_SEQUENCE_SEQUENCE_NAME;
    public static final SqlColumn OSEE_SEQUENCE_LAST_SEQUENCE;
    public static final SqlTable OSEE_INFO_TABLE;
    public static final SqlColumn OSEE_INFO_OSEE_KEY;
    public static final SqlColumn OSEE_INFO_OSEE_VALUE;
    public static final SqlTable OSEE_MERGE_TABLE;
    public static final SqlColumn OSEE_MERGE_MERGE_BRANCH_ID;
    public static final SqlColumn OSEE_MERGE_SOURCE_BRANCH_ID;
    public static final SqlColumn OSEE_MERGE_DEST_BRANCH_ID;
    public static final SqlColumn OSEE_MERGE_COMMIT_TRANSACTION_ID;
    public static final SqlTable OSEE_CONFLICT_TABLE;
    public static final SqlColumn OSEE_CONFLICT_MERGE_BRANCH_ID;
    public static final SqlColumn OSEE_CONFLICT_SOURCE_GAMMA_ID;
    public static final SqlColumn OSEE_CONFLICT_CONFLICT_ID;
    public static final SqlColumn OSEE_CONFLICT_DEST_GAMMA_ID;
    public static final SqlColumn OSEE_CONFLICT_CONFLICT_TYPE;
    public static final SqlColumn OSEE_CONFLICT_STATUS;
    public static final SqlTable OSEE_JOIN_EXPORT_IMPORT_TABLE;
    public static final SqlColumn OSEE_JOIN_EXPORT_IMPORT_TABLE_QUERY_ID;
    public static final SqlColumn OSEE_JOIN_EXPORT_IMPORT_ID1;
    public static final SqlColumn OSEE_JOIN_EXPORT_IMPORT_ID2;
    public static final SqlTable OSEE_IMPORT_SOURCE_TABLE;
    public static final SqlColumn OSEE_IMPORT_SOURCE_IMPORT_ID;
    public static final SqlColumn OSEE_IMPORT_SOURCE_SOURCE_EXPORT_DATE;
    public static final SqlColumn OSEE_IMPORT_SOURCE_DB_SOURCE_GUID;
    public static final SqlColumn OSEE_IMPORT_SOURCE_DATA_IMPORTED;
    public static final SqlTable OSEE_IMPORT_SAVE_POINT_TABLE;
    public static final SqlColumn OSEE_IMPORT_SAVE_POINT_IMPORT_ID;
    public static final SqlColumn OSEE_IMPORT_SAVE_POINT_STATE_ERROR;
    public static final SqlColumn OSEE_IMPORT_SAVE_POINT_STATUS;
    public static final SqlColumn OSEE_IMPORT_SAVE_POINT_SAVE_POINT_NAME;
    public static final SqlTable OSEE_IMPORT_MAP_TABLE;
    public static final SqlColumn OSEE_IMPORT_MAP_IMPORT_ID;
    public static final SqlColumn OSEE_IMPORT_MAP_SEQUENCE_NAME;
    public static final SqlColumn OSEE_IMPORT_MAP_SEQUENCE_ID;
    public static final SqlTable OSEE_IMPORT_INDEX_MAP_TABLE;
    public static final SqlColumn OSEE_IMPORT_INDEX_MAP_MAPPED_ID;
    public static final SqlColumn OSEE_IMPORT_INDEX_MAP_SEQUENCE_ID;
    public static final SqlColumn OSEE_IMPORT_INDEX_MAP_ORIGINAL_ID;
    public static final SqlTable OSEE_JOIN_ARTIFACT_TABLE;
    public static final SqlColumn OSEE_JOIN_ARTIFACT_TABLE_QUERY_ID;
    public static final SqlColumn OSEE_JOIN_ARTIFACT_TABLE_BRANCH_ID;
    public static final SqlColumn OSEE_JOIN_ARTIFACT_TABLE_ART_ID;
    public static final SqlColumn OSEE_JOIN_ARTIFACT_TABLE_TRANSACTION_ID;
    public static final SqlTable OSEE_JOIN_ID_TABLE;
    public static final SqlColumn OSEE_JOIN_ID_TABLE_QUERY_ID;
    public static final SqlColumn OSEE_JOIN_ID_TABLE_ID;
    public static final SqlTable OSEE_JOIN_CLEANUP_TABLE;
    public static final SqlColumn OSEE_JOIN_CLEANUP_QUERY_ID;
    public static final SqlColumn OSEE_JOIN_CLEANUP_TABLE_NAME;
    public static final SqlColumn OSEE_JOIN_CLEANUP_ISSUED_AT;
    public static final SqlColumn OSEE_JOIN_CLEANUP_EXPIRES_IN;
    public static final SqlTable OSEE_JOIN_CHAR_ID_TABLE;
    public static final SqlColumn OSEE_JOIN_CHAR_ID_ID;
    public static final SqlColumn OSEE_JOIN_CHAR_ID_QUERY_ID;
    public static final SqlTable OSEE_JOIN_TRANSACTION_TABLE;
    public static final SqlColumn OSEE_JOIN_TRANSACTION_BRANCH_ID;
    public static final SqlColumn OSEE_JOIN_TRANSACTION_TRANSACTION_ID;
    public static final SqlColumn OSEE_JOIN_TRANSACTION_QUERY_ID;
    public static final SqlColumn OSEE_JOIN_TRANSACTION_GAMMA_ID;
    public static final SqlTable LDAP_DETAILS_TABLE;
    public static final SqlColumn LDAP_DETAILS_USER_NAME;
    public static final SqlColumn LDAP_DETAILS_PASSWORD;
    public static final SqlColumn LDAP_DETAILS_SERVER_NAME;
    public static final SqlColumn LDAP_DETAILS_PORT;
    public static final SqlColumn LDAP_DETAILS_SEARCH_BASE;
    public static final SqlColumn LDAP_DETAILS_GROUP_SEARCH_FILTER;
    public static final SqlTable BRANCH_CATEGORY;
    public static final SqlColumn BRANCH_CATEGORY_BRANCH_ID;
    public static final SqlColumn BRANCH_CATEGORY_CATEGORY;
    public static final SqlColumn BRANCH_CATEGORY_GAMMA_ID;
    public static final SqlTable TUPLE2;
    public static final SqlColumn TUPLE2_TUPLE_TYPE;
    public static final SqlColumn TUPLE2_E1;
    public static final SqlColumn TUPLE2_E2;
    public static final SqlColumn TUPLE2_GAMMA_ID;
    public static final SqlTable TUPLE3;
    public static final SqlColumn TUPLE3_TUPLE_TYPE;
    public static final SqlColumn TUPLE3_E1;
    public static final SqlColumn TUPLE3_E2;
    public static final SqlColumn TUPLE3_E3;
    public static final SqlColumn TUPLE3_GAMMA_ID;
    public static final SqlTable TUPLE4;
    public static final SqlColumn TUPLE4_TUPLE_TYPE;
    public static final SqlColumn TUPLE4_E1;
    public static final SqlColumn TUPLE4_E2;
    public static final SqlColumn TUPLE4_E3;
    public static final SqlColumn TUPLE4_E4;
    public static final SqlColumn TUPLE4_GAMMA_ID;
    public static final SqlTable OSEE_KEY_VALUE_TABLE;
    public static final SqlColumn OSEE_KEY_VALUE_KEY;
    public static final SqlColumn OSEE_KEY_VALUE_VALUE;
    public static final SqlTable OSEE_JOIN_ID4_TABLE;
    public static final SqlColumn OSEE_JOIN_ID4_QUERY_ID;
    public static final SqlColumn OSEE_JOIN_ID4_ID1;
    public static final SqlColumn OSEE_JOIN_ID4_ID2;
    public static final SqlColumn OSEE_JOIN_ID4_ID3;
    public static final SqlColumn OSEE_JOIN_ID4_ID4;
    public static final SqlTable OSEE_SERVER_LOOKUP_TABLE;
    public static final SqlColumn OSEE_SERVER_LOOKUP_SERVER_ID;
    public static final SqlColumn OSEE_SERVER_LOOKUP_VERSION_ID;
    public static final SqlColumn OSEE_SERVER_LOOKUP_SERVER_URI;
    public static final SqlColumn OSEE_SERVER_LOOKUP_START_TIME;
    public static final SqlColumn OSEE_SERVER_LOOKUP_ACCEPTS_REQUESTS;
    public static final SqlTable OSEE_SESSION_TABLE;
    public static final SqlColumn OSEE_SESSION_SESSION_ID;
    public static final SqlColumn OSEE_SESSION_USER_ID;
    public static final SqlColumn OSEE_SESSION_CLIENT_MACHINE_NAME;
    public static final SqlColumn OSEE_SESSION_CLIENT_ADDRESS;
    public static final SqlColumn OSEE_SESSION_CLIENT_PORT;
    public static final SqlColumn OSEE_SESSION_CLIENT_VERSION;
    public static final SqlColumn OSEE_SESSION_CREATED_ON;
    public static final SqlTable OSEE_ACCOUNT_SESSION_TABLE;
    public static final SqlColumn OSEE_ACCOUNT_SESSION_ACCOUNT_ID;
    public static final SqlColumn OSEE_ACCOUNT_SESSION_SESSION_TOKEN;
    public static final SqlColumn OSEE_ACCOUNT_SESSION_CREATED_ON;
    public static final SqlColumn OSEE_ACCOUNT_SESSION_LAST_ACCESSED_ON;
    public static final SqlColumn OSEE_ACCOUNT_SESSION_ACCESSED_FROM;
    public static final SqlColumn OSEE_ACCOUNT_SESSION_ACCESS_DETAILS;
    public static final SqlTable OSEE_ACTIVITY_TYPE_TABLE;
    public static final SqlColumn OSEE_ACTIVITY_TYPE_TYPE_ID;
    public static final SqlColumn OSEE_ACTIVITY_TYPE_MODULE;
    public static final SqlColumn OSEE_ACTIVITY_TYPE_MSG_FORMAT;
    public static final SqlColumn OSEE_ACTIVITY_TYPE_LOG_LEVEL;
    public static final SqlTable OSEE_ACTIVITY_TABLE;
    public static final SqlColumn OSEE_ACTIVITY_ENTRY_ID;
    public static final SqlColumn OSEE_ACTIVITY_PARENT_ID;
    public static final SqlColumn OSEE_ACTIVITY_TYPE_ID;
    public static final SqlColumn OSEE_ACTIVITY_ACCOUNT_ID;
    public static final SqlColumn OSEE_ACTIVITY_SERVER_ID;
    public static final SqlColumn OSEE_ACTIVITY_CLIENT_ID;
    public static final SqlColumn OSEE_ACTIVITY_START_TIME;
    public static final SqlColumn OSEE_ACTIVITY_DURATION;
    public static final SqlColumn OSEE_ACTIVITY_STATUS;
    public static final SqlColumn OSEE_ACTIVITY_MSG_ARGS;
    public static final SqlTable OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE;
    public static final SqlColumn OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_ID;
    public static final SqlColumn OSEE_OAUTH_CLIENT_CREDENTIAL_APPLICATION_ID;
    public static final SqlColumn OSEE_OAUTH_CLIENT_CREDENTIAL_SUBJECT_ID;
    public static final SqlColumn OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_CERT;
    public static final SqlColumn OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_SECRET;
    public static final SqlColumn OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_KEY;
    public static final SqlTable OSEE_OAUTH_AUTHORIZATION_TABLE;
    public static final SqlColumn OSEE_OAUTH_AUTHORIZATION_AUDIENCE;
    public static final SqlColumn OSEE_OAUTH_AUTHORIZATION_APPROVED_SCOPES;
    public static final SqlColumn OSEE_OAUTH_AUTHORIZATION_REDIRECT_URI;
    public static final SqlColumn OSEE_OAUTH_AUTHORIZATION_EXPIRES_IN;
    public static final SqlColumn OSEE_OAUTH_AUTHORIZATION_ISSUED_AT;
    public static final SqlColumn OSEE_OAUTH_AUTHORIZATION_VERIFIER;
    public static final SqlColumn OSEE_OAUTH_AUTHORIZATION_CLIENT_ID;
    public static final SqlColumn OSEE_OAUTH_AUTHORIZATION_ID;
    public static final SqlColumn OSEE_OAUTH_AUTHORIZATION_SUBJECT_ID;
    public static final SqlColumn OSEE_OAUTH_AUTHORIZATION_CODE;
    public static final SqlTable OSEE_OAUTH_TOKEN_TABLE;
    public static final SqlColumn OSEE_OAUTH_TOKEN_AUDIENCE;
    public static final SqlColumn OSEE_OAUTH_TOKEN_EXPIRES_IN;
    public static final SqlColumn OSEE_OAUTH_TOKEN_ISSUED_AT;
    public static final SqlColumn OSEE_OAUTH_TOKEN_TOKEN_KEY;
    public static final SqlColumn OSEE_OAUTH_TOKEN_PARENT_TOKEN_ID;
    public static final SqlColumn OSEE_OAUTH_TOKEN_CLIENT_ID;
    public static final SqlColumn OSEE_OAUTH_TOKEN_GRANT_TYPE;
    public static final SqlColumn OSEE_OAUTH_TOKEN_ID;
    public static final SqlColumn OSEE_OAUTH_TOKEN_SUBJECT_ID;
    public static final SqlColumn OSEE_OAUTH_TOKEN_PARENT_TYPE_ID;
    public static final SqlColumn OSEE_OAUTH_TOKEN_TOKEN_TYPE;
    public static final SqlTable OSEE_VALIDATE_GAMMA_ID;
    public static final SqlColumn OSEE_VALIDATE_GAMMA_ID_GAMMA_ID;
    public static final SqlTable API_KEY_TABLE;
    public static final SqlColumn API_KEY_ID;
    public static final SqlColumn API_KEY_NAME;
    public static final SqlColumn API_KEY_VALUE;
    public static final SqlColumn API_KEY_SCOPES;
    public static final SqlColumn API_KEY_CREATION_DATE;
    public static final SqlColumn API_KEY_EXPIRATION_DATE;
    public static final SqlColumn API_KEY_USER_ARTIFACT_ID;

    static {
        ARTIFACT_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{ARTIFACT_ART_ID, ARTIFACT_GAMMA_ID});
        ARTIFACT_TABLE.createIndex("OSEE_ART__ART_ID_IDX", true, new SqlColumn[]{ARTIFACT_ART_ID});
        ARTIFACT_TABLE.createIndex("OSEE_ART__GUID_IDX", true, new SqlColumn[]{ARTIFACT_GUID});
        ARTIFACT_TABLE.createIndex("OSEE_ART__ART_TYPE_ID_IDX", true, new SqlColumn[]{ARTIFACT_ART_TYPE_ID});
        ARTIFACT_TABLE.setUniqueKeyConstraint("OSEE_ART__ART_ID_UNIQUE", "ART_ID");
        ATTRIBUTE_TABLE = new SqlTable("osee_attribute", "att", ObjectType.ATTRIBUTE);
        ATTRIBUTE_ATRR_ID = ATTRIBUTE_TABLE.addColumn("ATTR_ID", JDBCType.BIGINT);
        ATTRIBUTE_GAMMA_ID = ATTRIBUTE_TABLE.addColumn("GAMMA_ID", JDBCType.BIGINT);
        ATTRIBUTE_ART_ID = ATTRIBUTE_TABLE.addColumn("ART_ID", JDBCType.BIGINT);
        ATTRIBUTE_ATTR_TYPE_ID = ATTRIBUTE_TABLE.addColumnWithValueConstraint("ATTR_TYPE_ID", JDBCType.BIGINT, false, "ATTR_TYPE_ID > 0");
        ATTRIBUTE_VALUE = ATTRIBUTE_TABLE.addVarCharColumn("VALUE", 4000);
        ATTRIBUTE_URI = ATTRIBUTE_TABLE.addVarCharColumn("URI", 200);
        ATTRIBUTE_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{ATTRIBUTE_ATRR_ID, ATTRIBUTE_GAMMA_ID});
        ATTRIBUTE_TABLE.createIndex("OSEE_ATTRIBUTE_AR_G_IDX", true, new SqlColumn[]{ATTRIBUTE_ART_ID, ATTRIBUTE_GAMMA_ID});
        ATTRIBUTE_TABLE.createIndex("OSEE_ATTRIBUTE_G_AT_IDX", true, new SqlColumn[]{ATTRIBUTE_GAMMA_ID, ATTRIBUTE_ATRR_ID});
        ATTRIBUTE_SOURCE_TABLE = new SqlTable("osee_attribute_source", "att", ObjectType.ATTRIBUTE);
        ATTRIBUTE_SOURCE_TABLE_GAMMA_ID = ATTRIBUTE_SOURCE_TABLE.addColumn("GAMMA_ID", JDBCType.BIGINT);
        ATTRIBUTE_SOURCE_TABLE_ART_ID = ATTRIBUTE_SOURCE_TABLE.addColumn("ART_ID", JDBCType.BIGINT);
        ATTRIBUTE_SOURCE_TABLE_TYPE_ID = ATTRIBUTE_SOURCE_TABLE.addColumn("TYPE_ID", JDBCType.BIGINT);
        ATTRIBUTE_SOURCE_TABLE_ATTR_ORDER = ATTRIBUTE_SOURCE_TABLE.addColumn("ATTR_ORDER", JDBCType.BIGINT);
        ATTRIBUTE_SOURCE_TABLE_STRING_VALUE = ATTRIBUTE_SOURCE_TABLE.addVarCharColumn("STRING_VALUE", 4000);
        ATTRIBUTE_SOURCE_TABLE_NUMBER_VALUE = ATTRIBUTE_SOURCE_TABLE.addColumn("NUMBER_VALUE", JDBCType.BIGINT);
        ATTRIBUTE_SOURCE_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{ATTRIBUTE_SOURCE_TABLE_TYPE_ID, ATTRIBUTE_SOURCE_TABLE_ART_ID, ATTRIBUTE_SOURCE_TABLE_ATTR_ORDER});
        ATTRIBUTE_BINARY_TABLE = new SqlTable("osee_attribute_binary", "att", ObjectType.ATTRIBUTE);
        ATTRIBUTE_BINARY_TABLE_GAMMA_ID = ATTRIBUTE_BINARY_TABLE.addColumn("GAMMA_ID", JDBCType.BIGINT);
        ATTRIBUTE_BINARY_TABLE_VALUE = ATTRIBUTE_BINARY_TABLE.addColumn("VALUE", JDBCType.BLOB);
        ATTRIBUTE_BINARY_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{ATTRIBUTE_BINARY_TABLE_GAMMA_ID});
        RELATION_TABLE = new SqlTable("osee_relation_link", "rel", ObjectType.RELATION);
        RELATION_LINK_REL_LINK_TYPE_ID = RELATION_TABLE.addColumn("REL_LINK_TYPE_ID", JDBCType.BIGINT);
        RELATION_LINK_A_ART_ID = RELATION_TABLE.addColumn("A_ART_ID", JDBCType.BIGINT);
        RELATION_LINK_B_ART_ID = RELATION_TABLE.addColumn("B_ART_ID", JDBCType.BIGINT);
        RELATION_LINK_GAMMA_ID = RELATION_TABLE.addColumn("GAMMA_ID", JDBCType.BIGINT);
        RELATION_LINK_REL_LINK_ID = RELATION_TABLE.addColumn("REL_LINK_ID", JDBCType.BIGINT);
        RELATION_LINK_RATIONALE = RELATION_TABLE.addVarCharColumn("RATIONALE", 4000);
        RELATION_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{RELATION_LINK_GAMMA_ID});
        RELATION_TABLE.createIndex("OSEE_RELATION__R_G_IDX", true, new SqlColumn[]{RELATION_LINK_REL_LINK_ID, RELATION_LINK_GAMMA_ID});
        RELATION_TABLE.createIndex("OSEE_RELATION__A_IDX", true, new SqlColumn[]{RELATION_LINK_A_ART_ID});
        RELATION_TABLE.createIndex("OSEE_RELATION__B_IDX", true, new SqlColumn[]{RELATION_LINK_B_ART_ID});
        RELATION_TABLE2 = new SqlTable("osee_relation", "rel", ObjectType.RELATION, 4);
        RELATION_REL_TYPE = RELATION_TABLE2.addColumn("REL_TYPE", JDBCType.BIGINT);
        RELATION_A_ART_ID = RELATION_TABLE2.addColumn("A_ART_ID", JDBCType.BIGINT);
        RELATION_B_ART_ID = RELATION_TABLE2.addColumn("B_ART_ID", JDBCType.BIGINT);
        RELATION_REL_ART_ID = RELATION_TABLE2.addColumn("REL_ART_ID", JDBCType.BIGINT);
        RELATION_REL_ORDER = RELATION_TABLE2.addColumn("REL_ORDER", JDBCType.INTEGER);
        RELATION_GAMMA_ID = RELATION_TABLE2.addColumn("GAMMA_ID", JDBCType.BIGINT);
        RELATION_TABLE2.setPrimaryKeyConstraint(new SqlColumn[]{RELATION_REL_TYPE, RELATION_A_ART_ID, RELATION_B_ART_ID, RELATION_REL_ART_ID, RELATION_REL_ORDER});
        RELATION_TABLE2.createIndex("OSEE_RELATION__G_IDX", true, new SqlColumn[]{RELATION_GAMMA_ID});
        RELATION_TABLE2.createIndex("OSEE_RELATION__B2_IDX", true, new SqlColumn[]{RELATION_B_ART_ID});
        BRANCH_TABLE = new SqlTable("osee_branch", "br", ObjectType.BRANCH);
        BRANCH_ID = BRANCH_TABLE.addColumn("BRANCH_ID", JDBCType.BIGINT);
        BRANCH_TYPE = BRANCH_TABLE.addColumn("BRANCH_TYPE", JDBCType.SMALLINT);
        BRANCH_STATE = BRANCH_TABLE.addColumn("BRANCH_STATE", JDBCType.SMALLINT);
        BRANCH_NAME = BRANCH_TABLE.addVarCharColumn("BRANCH_NAME", 200, false);
        BRANCH_PARENT_BRANCH_ID = BRANCH_TABLE.addColumn("PARENT_BRANCH_ID", JDBCType.BIGINT);
        BRANCH_PARENT_TRANSACTION_ID = BRANCH_TABLE.addColumn("PARENT_TRANSACTION_ID", JDBCType.BIGINT);
        BRANCH_BASELINE_TRANSACTION_ID = BRANCH_TABLE.addColumn("BASELINE_TRANSACTION_ID", JDBCType.BIGINT);
        BRANCH_ASSOCIATED_ART_ID = BRANCH_TABLE.addColumn("ASSOCIATED_ART_ID", JDBCType.BIGINT);
        BRANCH_ARCHIVED = BRANCH_TABLE.addColumn("ARCHIVED", JDBCType.SMALLINT);
        BRANCH_INHERIT_ACCESS_CONTROL = BRANCH_TABLE.addColumn("INHERIT_ACCESS_CONTROL", JDBCType.SMALLINT);
        BRANCH_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{BRANCH_ID});
        BRANCH_TABLE.createIndex("OSEE_BRANCH_A_IDX", true, new SqlColumn[]{BRANCH_ARCHIVED});
        BRANCH_TABLE.addStatement(BRANCH_TABLE.getInsertIntoSqlWithValues(new Object[]{CoreBranches.SYSTEM_ROOT, BranchType.SYSTEM_ROOT, BranchState.MODIFIED, CoreBranches.SYSTEM_ROOT.getName(), -1, 1, 1, -1, BranchArchivedState.UNARCHIVED, 0}));
        TXS_TABLE = new SqlTable("osee_txs", "txs", 1);
        TXS_BRANCH_ID = TXS_TABLE.addColumn("BRANCH_ID", JDBCType.BIGINT);
        TXS_GAMMA_ID = TXS_TABLE.addColumn("GAMMA_ID", JDBCType.BIGINT);
        TXS_TRANSACTION_ID = TXS_TABLE.addColumn("TRANSACTION_ID", JDBCType.BIGINT);
        TXS_TX_CURRENT = TXS_TABLE.addColumn("TX_CURRENT", JDBCType.SMALLINT);
        TXS_MOD_TYPE = TXS_TABLE.addColumn("MOD_TYPE", JDBCType.SMALLINT);
        TXS_APP_ID = TXS_TABLE.addColumn("APP_ID", JDBCType.BIGINT);
        TXS_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{TXS_BRANCH_ID, TXS_GAMMA_ID, TXS_TRANSACTION_ID});
        TXS_ARCHIVED_TABLE = new SqlTable("osee_txs_archived", "txs_arc", 1);
        TXS_ARCHIVED_BRANCH_ID = TXS_ARCHIVED_TABLE.addColumn("BRANCH_ID", JDBCType.BIGINT);
        TXS_ARCHIVED_GAMMA_ID = TXS_ARCHIVED_TABLE.addColumn("GAMMA_ID", JDBCType.BIGINT);
        TXS_ARCHIVED_TRANSACTION_ID = TXS_ARCHIVED_TABLE.addColumn("TRANSACTION_ID", JDBCType.BIGINT);
        TXS_ARCHIVED_TX_CURRENT = TXS_ARCHIVED_TABLE.addColumn("TX_CURRENT", JDBCType.SMALLINT);
        TXS_ARCHIVED_MOD_TYPE = TXS_ARCHIVED_TABLE.addColumn("MOD_TYPE", JDBCType.SMALLINT);
        TXS_ARCHIVED_APP_ID = TXS_ARCHIVED_TABLE.addColumn("APP_ID", JDBCType.BIGINT);
        TXS_ARCHIVED_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{TXS_ARCHIVED_BRANCH_ID, TXS_ARCHIVED_GAMMA_ID, TXS_ARCHIVED_TRANSACTION_ID});
        TXS_ARCHIVED_TABLE.setTableExtras("TABLESPACE osee_archived");
        TX_DETAILS_TABLE = new SqlTable("osee_tx_details", "txd", ObjectType.TX);
        TX_DETAILS_TX_BRANCH_ID = TX_DETAILS_TABLE.addColumn("BRANCH_ID", JDBCType.BIGINT);
        TX_DETAILS_TRANSACTION_ID = TX_DETAILS_TABLE.addColumn("TRANSACTION_ID", JDBCType.BIGINT);
        TX_DETAILS_AUTHOR = TX_DETAILS_TABLE.addColumn("AUTHOR", JDBCType.BIGINT);
        TX_DETAILS_TIME = TX_DETAILS_TABLE.addColumn("TIME", JDBCType.TIMESTAMP);
        TX_DETAILS_OSEE_COMMENT = TX_DETAILS_TABLE.addVarCharColumn("OSEE_COMMENT", 1000);
        TX_DETAILS_TX_TYPE = TX_DETAILS_TABLE.addColumn("TX_TYPE", JDBCType.SMALLINT);
        TX_DETAILS_TX_COMMIT_ART_ID = TX_DETAILS_TABLE.addColumn("COMMIT_ART_ID", JDBCType.BIGINT, true);
        TX_DETAILS_BUILD_ID = TX_DETAILS_TABLE.addColumn("BUILD_ID", JDBCType.BIGINT);
        TX_DETAILS_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{TX_DETAILS_TRANSACTION_ID});
        TX_DETAILS_TABLE.setForeignKeyConstraint("BRANCH_ID_FK1", TX_DETAILS_TX_BRANCH_ID, BRANCH_TABLE, BRANCH_ID);
        TX_DETAILS_TABLE.createIndex("OSEE_TX_DETAILS_B_TX_IDX", true, new SqlColumn[]{TX_DETAILS_TX_BRANCH_ID, TX_DETAILS_TRANSACTION_ID});
        TX_DETAILS_TABLE.addStatement(TX_DETAILS_TABLE.getInsertIntoSqlWithValues(new Object[]{1, 1, -1, "CURRENT_TIMESTAMP", String.valueOf(CoreBranches.SYSTEM_ROOT.getName()) + " Creation", TransactionDetailsType.Baselined, -1, OseeCodeVersion.getVersionId()}));
        OSEE_PERMISSION_TABLE = new SqlTable("osee_permission", "per");
        OSEE_PERMISSION_PERMISSION_ID = OSEE_PERMISSION_TABLE.addColumn("PERMISSION_ID", JDBCType.INTEGER);
        OSEE_PERMISSION_PERMISSION_NAME = OSEE_PERMISSION_TABLE.addVarCharColumn("PERMISSION_NAME", 50, false);
        OSEE_PERMISSION_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_PERMISSION_PERMISSION_ID});
        OSEE_ARTIFACT_ACL_TABLE = new SqlTable("osee_artifact_acl", "art_acl");
        OSEE_ARTIFACT_ACL_ART_ID = OSEE_ARTIFACT_ACL_TABLE.addColumn("ART_ID", JDBCType.BIGINT);
        OSEE_ARTIFACT_ACL_PRIVILEGE_ENTITY_ID = OSEE_ARTIFACT_ACL_TABLE.addColumn("PRIVILEGE_ENTITY_ID", JDBCType.BIGINT);
        OSEE_ARTIFACT_ACL_BRANCH_ID = OSEE_ARTIFACT_ACL_TABLE.addColumn("BRANCH_ID", JDBCType.BIGINT);
        OSEE_ARTIFACT_ACL_PERMISSION_ID = OSEE_ARTIFACT_ACL_TABLE.addColumn("PERMISSION_ID", JDBCType.INTEGER);
        OSEE_ARTIFACT_ACL_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_ARTIFACT_ACL_ART_ID, OSEE_ARTIFACT_ACL_PRIVILEGE_ENTITY_ID, OSEE_ARTIFACT_ACL_BRANCH_ID});
        OSEE_ARTIFACT_ACL_TABLE.setForeignKeyConstraint("ARTIFACT_ACL_PERM_FK", OSEE_ARTIFACT_ACL_PERMISSION_ID, OSEE_PERMISSION_TABLE, OSEE_PERMISSION_PERMISSION_ID);
        OSEE_BRANCH_ACL_TABLE = new SqlTable("osee_branch_acl", "br_acl");
        OSEE_BRANCH_ACL_BRANCH_ID = OSEE_BRANCH_ACL_TABLE.addColumn("BRANCH_ID", JDBCType.BIGINT);
        OSEE_BRANCH_ACL_PRIVILEGE_ENTITY_ID = OSEE_BRANCH_ACL_TABLE.addColumn("PRIVILEGE_ENTITY_ID", JDBCType.BIGINT);
        OSEE_BRANCH_ACL_PERMISSION_ID = OSEE_BRANCH_ACL_TABLE.addColumn("PERMISSION_ID", JDBCType.INTEGER);
        OSEE_BRANCH_ACL_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_BRANCH_ACL_BRANCH_ID, OSEE_BRANCH_ACL_PRIVILEGE_ENTITY_ID});
        OSEE_BRANCH_ACL_TABLE.setForeignKeyConstraintCascadeDelete("BRANCH_ACL_FK", OSEE_BRANCH_ACL_BRANCH_ID, BRANCH_TABLE, BRANCH_ID);
        OSEE_BRANCH_ACL_TABLE.setForeignKeyConstraint("BRANCH_ACL_PERM_FK", OSEE_BRANCH_ACL_PERMISSION_ID, OSEE_PERMISSION_TABLE, OSEE_PERMISSION_PERMISSION_ID);
        OSEE_SEARCH_TAGS_TABLE = new SqlTable("osee_search_tags", "srch_tgs");
        OSEE_SEARCH_TAGS_CODED_TAG_ID = OSEE_SEARCH_TAGS_TABLE.addColumn("CODED_TAG_ID", JDBCType.BIGINT);
        OSEE_SEARCH_TAGS_GAMMA_ID = OSEE_SEARCH_TAGS_TABLE.addColumn("GAMMA_ID", JDBCType.BIGINT);
        OSEE_SEARCH_TAGS_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_SEARCH_TAGS_CODED_TAG_ID, OSEE_SEARCH_TAGS_GAMMA_ID});
        OSEE_SEARCH_TAGS_TABLE.createIndex("OSEE_SEARCH_TAGS_C_IDX", true, new SqlColumn[]{OSEE_SEARCH_TAGS_CODED_TAG_ID});
        OSEE_SEARCH_TAGS_TABLE.createIndex("OSEE_SEARCH_TAGS_G_IDX", true, new SqlColumn[]{OSEE_SEARCH_TAGS_GAMMA_ID});
        OSEE_TAG_GAMMA_QUEUE_TABLE = new SqlTable("osee_tag_gamma_queue", "tg_gm_que");
        OSEE_TAG_GAMMA_QUEUE_QUERY_ID = OSEE_TAG_GAMMA_QUEUE_TABLE.addColumn("QUERY_ID", JDBCType.BIGINT);
        OSEE_TAG_GAMMA_QUEUE_GAMMA_ID = OSEE_TAG_GAMMA_QUEUE_TABLE.addColumn("GAMMA_ID", JDBCType.BIGINT);
        OSEE_TAG_GAMMA_QUEUE_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_TAG_GAMMA_QUEUE_QUERY_ID, OSEE_TAG_GAMMA_QUEUE_GAMMA_ID});
        OSEE_SEQUENCE_TABLE = new SqlTable("osee_sequence", "seq");
        OSEE_SEQUENCE_SEQUENCE_NAME = OSEE_SEQUENCE_TABLE.addVarCharColumn("SEQUENCE_NAME", 128, false);
        OSEE_SEQUENCE_LAST_SEQUENCE = OSEE_SEQUENCE_TABLE.addColumn("LAST_SEQUENCE", JDBCType.BIGINT);
        OSEE_SEQUENCE_TABLE.setUniqueKeyConstraint("SEQUENCE_ID_UN", OSEE_SEQUENCE_SEQUENCE_NAME.getName());
        OSEE_SEQUENCE_TABLE.addStatement(OSEE_SEQUENCE_TABLE.getInsertIntoSqlWithValues(new Object[]{"SKYNET_TRANSACTION_ID_SEQ", 1}));
        OSEE_INFO_TABLE = new SqlTable("osee_info", "inf");
        OSEE_INFO_OSEE_KEY = OSEE_INFO_TABLE.addVarCharColumn("OSEE_KEY", 50, false);
        OSEE_INFO_OSEE_VALUE = OSEE_INFO_TABLE.addVarCharColumn("OSEE_VALUE", 1000, false);
        OSEE_INFO_TABLE.setUniqueKeyConstraint("OSEE_INFO_KEY_UN_IDX", OSEE_INFO_OSEE_KEY.getName());
        OSEE_MERGE_TABLE = new SqlTable("osee_merge", "mrg");
        OSEE_MERGE_MERGE_BRANCH_ID = OSEE_MERGE_TABLE.addColumn("MERGE_BRANCH_ID", JDBCType.BIGINT);
        OSEE_MERGE_SOURCE_BRANCH_ID = OSEE_MERGE_TABLE.addColumn("SOURCE_BRANCH_ID", JDBCType.BIGINT);
        OSEE_MERGE_DEST_BRANCH_ID = OSEE_MERGE_TABLE.addColumn("DEST_BRANCH_ID", JDBCType.BIGINT);
        OSEE_MERGE_COMMIT_TRANSACTION_ID = OSEE_MERGE_TABLE.addColumn("COMMIT_TRANSACTION_ID", JDBCType.BIGINT);
        OSEE_MERGE_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_MERGE_MERGE_BRANCH_ID});
        OSEE_MERGE_TABLE.setForeignKeyConstraint("OSEE_MERGE__MBI_FK", OSEE_MERGE_MERGE_BRANCH_ID, BRANCH_TABLE, BRANCH_ID);
        OSEE_MERGE_TABLE.setForeignKeyConstraint("OSEE_MERGE__DBI_FK", OSEE_MERGE_DEST_BRANCH_ID, BRANCH_TABLE, BRANCH_ID);
        OSEE_CONFLICT_TABLE = new SqlTable("osee_conflict", "conf");
        OSEE_CONFLICT_MERGE_BRANCH_ID = OSEE_CONFLICT_TABLE.addColumn("MERGE_BRANCH_ID", JDBCType.BIGINT);
        OSEE_CONFLICT_SOURCE_GAMMA_ID = OSEE_CONFLICT_TABLE.addColumn("SOURCE_GAMMA_ID", JDBCType.BIGINT);
        OSEE_CONFLICT_CONFLICT_ID = OSEE_CONFLICT_TABLE.addColumn("CONFLICT_ID", JDBCType.BIGINT);
        OSEE_CONFLICT_DEST_GAMMA_ID = OSEE_CONFLICT_TABLE.addColumn("DEST_GAMMA_ID", JDBCType.BIGINT);
        OSEE_CONFLICT_CONFLICT_TYPE = OSEE_CONFLICT_TABLE.addColumn("CONFLICT_TYPE", JDBCType.SMALLINT);
        OSEE_CONFLICT_STATUS = OSEE_CONFLICT_TABLE.addColumn("STATUS", JDBCType.SMALLINT);
        OSEE_CONFLICT_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_CONFLICT_MERGE_BRANCH_ID, OSEE_CONFLICT_SOURCE_GAMMA_ID});
        OSEE_CONFLICT_TABLE.setForeignKeyConstraint("OSEE_CONFLICT__MBI_FK", OSEE_CONFLICT_MERGE_BRANCH_ID, OSEE_MERGE_TABLE, OSEE_MERGE_MERGE_BRANCH_ID);
        OSEE_JOIN_EXPORT_IMPORT_TABLE = new SqlTable("osee_join_export_import", "jn_ex_im");
        OSEE_JOIN_EXPORT_IMPORT_TABLE_QUERY_ID = OSEE_JOIN_EXPORT_IMPORT_TABLE.addColumn("QUERY_ID", JDBCType.BIGINT);
        OSEE_JOIN_EXPORT_IMPORT_ID1 = OSEE_JOIN_EXPORT_IMPORT_TABLE.addColumn("ID1", JDBCType.BIGINT);
        OSEE_JOIN_EXPORT_IMPORT_ID2 = OSEE_JOIN_EXPORT_IMPORT_TABLE.addColumn("ID2", JDBCType.BIGINT);
        OSEE_JOIN_EXPORT_IMPORT_TABLE.setTableExtras("TABLESPACE osee_join");
        OSEE_IMPORT_SOURCE_TABLE = new SqlTable("osee_import_source", "imp_src");
        OSEE_IMPORT_SOURCE_IMPORT_ID = OSEE_IMPORT_SOURCE_TABLE.addColumn("IMPORT_ID", JDBCType.INTEGER);
        OSEE_IMPORT_SOURCE_SOURCE_EXPORT_DATE = OSEE_IMPORT_SOURCE_TABLE.addColumn("SOURCE_EXPORT_DATE", JDBCType.TIMESTAMP);
        OSEE_IMPORT_SOURCE_DB_SOURCE_GUID = OSEE_IMPORT_SOURCE_TABLE.addVarCharColumn("DB_SOURCE_GUID", 28, false);
        OSEE_IMPORT_SOURCE_DATA_IMPORTED = OSEE_IMPORT_SOURCE_TABLE.addColumn("DATE_IMPORTED", JDBCType.TIMESTAMP);
        OSEE_IMPORT_SOURCE_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_IMPORT_SOURCE_IMPORT_ID});
        OSEE_IMPORT_SAVE_POINT_TABLE = new SqlTable("osee_import_save_point", "imp_sv_pt");
        OSEE_IMPORT_SAVE_POINT_IMPORT_ID = OSEE_IMPORT_SAVE_POINT_TABLE.addColumn("IMPORT_ID", JDBCType.INTEGER);
        OSEE_IMPORT_SAVE_POINT_STATE_ERROR = OSEE_IMPORT_SAVE_POINT_TABLE.addVarCharColumn("STATE_ERROR", 4000);
        OSEE_IMPORT_SAVE_POINT_STATUS = OSEE_IMPORT_SAVE_POINT_TABLE.addColumn("STATUS", JDBCType.INTEGER);
        OSEE_IMPORT_SAVE_POINT_SAVE_POINT_NAME = OSEE_IMPORT_SAVE_POINT_TABLE.addVarCharColumn("SAVE_POINT_NAME", 128, false);
        OSEE_IMPORT_SAVE_POINT_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_IMPORT_SAVE_POINT_IMPORT_ID, OSEE_IMPORT_SAVE_POINT_SAVE_POINT_NAME});
        OSEE_IMPORT_SAVE_POINT_TABLE.setForeignKeyConstraint("OSEE_IMP_SAVE_POINT_II_FK", OSEE_IMPORT_SAVE_POINT_IMPORT_ID, OSEE_IMPORT_SOURCE_TABLE, OSEE_IMPORT_SOURCE_IMPORT_ID);
        OSEE_IMPORT_MAP_TABLE = new SqlTable("osee_import_map", "imp_mp");
        OSEE_IMPORT_MAP_IMPORT_ID = OSEE_IMPORT_MAP_TABLE.addColumn("IMPORT_ID", JDBCType.INTEGER);
        OSEE_IMPORT_MAP_SEQUENCE_NAME = OSEE_IMPORT_MAP_TABLE.addVarCharColumn("SEQUENCE_NAME", 128, false);
        OSEE_IMPORT_MAP_SEQUENCE_ID = OSEE_IMPORT_MAP_TABLE.addColumn("SEQUENCE_ID", JDBCType.INTEGER);
        OSEE_IMPORT_MAP_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_IMPORT_MAP_SEQUENCE_ID});
        OSEE_IMPORT_MAP_TABLE.setForeignKeyConstraint("OSEE_IMPORT_MAP_II_FK", OSEE_IMPORT_MAP_IMPORT_ID, OSEE_IMPORT_SOURCE_TABLE, OSEE_IMPORT_SOURCE_IMPORT_ID);
        OSEE_IMPORT_INDEX_MAP_TABLE = new SqlTable("osee_import_index_map", "imp_mp");
        OSEE_IMPORT_INDEX_MAP_MAPPED_ID = OSEE_IMPORT_INDEX_MAP_TABLE.addColumn("MAPPED_ID", JDBCType.BIGINT);
        OSEE_IMPORT_INDEX_MAP_SEQUENCE_ID = OSEE_IMPORT_INDEX_MAP_TABLE.addColumn("SEQUENCE_ID", JDBCType.INTEGER);
        OSEE_IMPORT_INDEX_MAP_ORIGINAL_ID = OSEE_IMPORT_INDEX_MAP_TABLE.addColumn("ORIGINAL_ID", JDBCType.BIGINT);
        OSEE_IMPORT_INDEX_MAP_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_IMPORT_INDEX_MAP_SEQUENCE_ID, OSEE_IMPORT_INDEX_MAP_ORIGINAL_ID, OSEE_IMPORT_INDEX_MAP_MAPPED_ID});
        OSEE_IMPORT_INDEX_MAP_TABLE.setForeignKeyConstraint("OSEE_IMPORT_INDEX_MAP_II_FK", OSEE_IMPORT_INDEX_MAP_SEQUENCE_ID, OSEE_IMPORT_MAP_TABLE, OSEE_IMPORT_MAP_SEQUENCE_ID);
        OSEE_IMPORT_INDEX_MAP_TABLE.createIndex("OSEE_IMPORT_INDEX_MAP_IO_IDX", true, new SqlColumn[]{OSEE_IMPORT_INDEX_MAP_SEQUENCE_ID, OSEE_IMPORT_INDEX_MAP_ORIGINAL_ID});
        OSEE_IMPORT_INDEX_MAP_TABLE.createIndex("OSEE_IMPORT_INDEX_MAP_IM_IDX", true, new SqlColumn[]{OSEE_IMPORT_INDEX_MAP_SEQUENCE_ID, OSEE_IMPORT_INDEX_MAP_MAPPED_ID});
        OSEE_JOIN_ARTIFACT_TABLE = new SqlTable("osee_join_artifact", "jn_art");
        OSEE_JOIN_ARTIFACT_TABLE_QUERY_ID = OSEE_JOIN_ARTIFACT_TABLE.addColumn("QUERY_ID", JDBCType.BIGINT);
        OSEE_JOIN_ARTIFACT_TABLE_BRANCH_ID = OSEE_JOIN_ARTIFACT_TABLE.addColumn("BRANCH_ID", JDBCType.BIGINT);
        OSEE_JOIN_ARTIFACT_TABLE_ART_ID = OSEE_JOIN_ARTIFACT_TABLE.addColumn("ART_ID", JDBCType.BIGINT);
        OSEE_JOIN_ARTIFACT_TABLE_TRANSACTION_ID = OSEE_JOIN_ARTIFACT_TABLE.addColumn("TRANSACTION_ID", JDBCType.BIGINT, true);
        OSEE_JOIN_ARTIFACT_TABLE.createIndex("OSEE_JOIN_ART__Q_A_IDX", true, new SqlColumn[]{OSEE_JOIN_ARTIFACT_TABLE_QUERY_ID, OSEE_JOIN_ARTIFACT_TABLE_ART_ID});
        OSEE_JOIN_ARTIFACT_TABLE.setTableExtras("TABLESPACE osee_join");
        OSEE_JOIN_ID_TABLE = new SqlTable("osee_join_id", "jn_id");
        OSEE_JOIN_ID_TABLE_QUERY_ID = OSEE_JOIN_ID_TABLE.addColumn("QUERY_ID", JDBCType.BIGINT);
        OSEE_JOIN_ID_TABLE_ID = OSEE_JOIN_ID_TABLE.addColumn("ID", JDBCType.BIGINT, true);
        OSEE_JOIN_ID_TABLE.createIndex("OSEE_JOIN_ID__Q_I_IDX", true, new SqlColumn[]{OSEE_JOIN_ID_TABLE_QUERY_ID, OSEE_JOIN_ID_TABLE_ID});
        OSEE_JOIN_ID_TABLE.setTableExtras("TABLESPACE osee_join");
        OSEE_JOIN_CLEANUP_TABLE = new SqlTable("osee_join_cleanup", "jn_clup");
        OSEE_JOIN_CLEANUP_QUERY_ID = OSEE_JOIN_CLEANUP_TABLE.addColumn("QUERY_ID", JDBCType.BIGINT);
        OSEE_JOIN_CLEANUP_TABLE_NAME = OSEE_JOIN_CLEANUP_TABLE.addVarCharColumn("TABLE_NAME", 28, false);
        OSEE_JOIN_CLEANUP_ISSUED_AT = OSEE_JOIN_CLEANUP_TABLE.addColumn("ISSUED_AT", JDBCType.BIGINT);
        OSEE_JOIN_CLEANUP_EXPIRES_IN = OSEE_JOIN_CLEANUP_TABLE.addColumn("EXPIRES_IN", JDBCType.BIGINT);
        OSEE_JOIN_CLEANUP_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_JOIN_CLEANUP_QUERY_ID});
        OSEE_JOIN_CLEANUP_TABLE.setTableExtras("TABLESPACE osee_join");
        OSEE_JOIN_CHAR_ID_TABLE = new SqlTable("osee_join_char_id", "jn_chr_id");
        OSEE_JOIN_CHAR_ID_ID = OSEE_JOIN_CHAR_ID_TABLE.addVarCharColumn("ID", 4000, false);
        OSEE_JOIN_CHAR_ID_QUERY_ID = OSEE_JOIN_CHAR_ID_TABLE.addColumn("QUERY_ID", JDBCType.BIGINT);
        OSEE_JOIN_CHAR_ID_TABLE.createIndex("OSEE_JOIN_CHAR__Q_IDX", true, new SqlColumn[]{OSEE_JOIN_CHAR_ID_QUERY_ID});
        OSEE_JOIN_CHAR_ID_TABLE.setTableExtras("TABLESPACE osee_join");
        OSEE_JOIN_TRANSACTION_TABLE = new SqlTable("osee_join_transaction", "jn_trns");
        OSEE_JOIN_TRANSACTION_BRANCH_ID = OSEE_JOIN_TRANSACTION_TABLE.addColumn("BRANCH_ID", JDBCType.BIGINT, true);
        OSEE_JOIN_TRANSACTION_TRANSACTION_ID = OSEE_JOIN_TRANSACTION_TABLE.addColumn("TRANSACTION_ID", JDBCType.BIGINT);
        OSEE_JOIN_TRANSACTION_QUERY_ID = OSEE_JOIN_TRANSACTION_TABLE.addColumn("QUERY_ID", JDBCType.BIGINT);
        OSEE_JOIN_TRANSACTION_GAMMA_ID = OSEE_JOIN_TRANSACTION_TABLE.addColumn("GAMMA_ID", JDBCType.BIGINT);
        OSEE_JOIN_TRANSACTION_TABLE.createIndex("OSEE_JOIN_TRANSACTION_Q_IDX", true, new SqlColumn[]{OSEE_JOIN_TRANSACTION_QUERY_ID});
        OSEE_JOIN_TRANSACTION_TABLE.setTableExtras("TABLESPACE osee_join");
        LDAP_DETAILS_TABLE = new SqlTable("ldap_details", "ldap_det");
        LDAP_DETAILS_USER_NAME = LDAP_DETAILS_TABLE.addVarCharColumn("USER_NAME", 1000, false);
        LDAP_DETAILS_PASSWORD = LDAP_DETAILS_TABLE.addVarCharColumn("PASSWORD", 1000, false);
        LDAP_DETAILS_SERVER_NAME = LDAP_DETAILS_TABLE.addVarCharColumn("SERVER_NAME", 1000, false);
        LDAP_DETAILS_PORT = LDAP_DETAILS_TABLE.addColumn("PORT", JDBCType.INTEGER);
        LDAP_DETAILS_SEARCH_BASE = LDAP_DETAILS_TABLE.addVarCharColumn("SEARCH_BASE", 1000, false);
        LDAP_DETAILS_GROUP_SEARCH_FILTER = LDAP_DETAILS_TABLE.addVarCharColumn("GROUP_SEARCH_FILTER", 1000, false);
        BRANCH_CATEGORY = new SqlTable("osee_branch_category", "brc", 2);
        BRANCH_CATEGORY_BRANCH_ID = BRANCH_CATEGORY.addColumn("BRANCH_ID", JDBCType.BIGINT);
        BRANCH_CATEGORY_CATEGORY = BRANCH_CATEGORY.addColumn("CATEGORY", JDBCType.BIGINT);
        BRANCH_CATEGORY_GAMMA_ID = BRANCH_CATEGORY.addColumn("GAMMA_ID", JDBCType.BIGINT);
        BRANCH_CATEGORY.setPrimaryKeyConstraint(new SqlColumn[]{BRANCH_CATEGORY_CATEGORY, BRANCH_CATEGORY_BRANCH_ID});
        BRANCH_CATEGORY.createIndex("BRANCH_CATEGORY__G_IDX", false, new SqlColumn[]{BRANCH_CATEGORY_GAMMA_ID});
        TUPLE2 = new SqlTable("osee_tuple2", "tp2", ObjectType.TUPLE, 2);
        TUPLE2_TUPLE_TYPE = TUPLE2.addColumn("TUPLE_TYPE", JDBCType.BIGINT);
        TUPLE2_E1 = TUPLE2.addColumn("E1", JDBCType.BIGINT);
        TUPLE2_E2 = TUPLE2.addColumn("E2", JDBCType.BIGINT);
        TUPLE2_GAMMA_ID = TUPLE2.addColumn("GAMMA_ID", JDBCType.BIGINT);
        TUPLE2.setPrimaryKeyConstraint(new SqlColumn[]{TUPLE2_TUPLE_TYPE, TUPLE2_E1, TUPLE2_E2});
        TUPLE2.createIndex("OSEE_TUPLE2__G_IDX", false, new SqlColumn[]{TUPLE2_GAMMA_ID});
        TUPLE3 = new SqlTable("osee_tuple3", "tp3", ObjectType.TUPLE, 2);
        TUPLE3_TUPLE_TYPE = TUPLE3.addColumn("TUPLE_TYPE", JDBCType.BIGINT);
        TUPLE3_E1 = TUPLE3.addColumn("E1", JDBCType.BIGINT);
        TUPLE3_E2 = TUPLE3.addColumn("E2", JDBCType.BIGINT);
        TUPLE3_E3 = TUPLE3.addColumn("E3", JDBCType.BIGINT);
        TUPLE3_GAMMA_ID = TUPLE3.addColumn("GAMMA_ID", JDBCType.BIGINT);
        TUPLE3.setPrimaryKeyConstraint(new SqlColumn[]{TUPLE3_TUPLE_TYPE, TUPLE3_E1, TUPLE3_E2, TUPLE3_E3});
        TUPLE3.createIndex("OSEE_TUPLE3__G_IDX", false, new SqlColumn[]{TUPLE3_GAMMA_ID});
        TUPLE4 = new SqlTable("osee_tuple4", "tp4", ObjectType.TUPLE, 3);
        TUPLE4_TUPLE_TYPE = TUPLE4.addColumn("TUPLE_TYPE", JDBCType.BIGINT);
        TUPLE4_E1 = TUPLE4.addColumn("E1", JDBCType.BIGINT);
        TUPLE4_E2 = TUPLE4.addColumn("E2", JDBCType.BIGINT);
        TUPLE4_E3 = TUPLE4.addColumn("E3", JDBCType.BIGINT);
        TUPLE4_E4 = TUPLE4.addColumn("E4", JDBCType.BIGINT);
        TUPLE4_GAMMA_ID = TUPLE4.addColumn("GAMMA_ID", JDBCType.BIGINT);
        TUPLE4.setPrimaryKeyConstraint(new SqlColumn[]{TUPLE4_TUPLE_TYPE, TUPLE4_E1, TUPLE4_E2, TUPLE4_E3, TUPLE4_E4});
        TUPLE4.createIndex("OSEE_TUPLE4__G_IDX", false, new SqlColumn[]{TUPLE4_GAMMA_ID});
        OSEE_KEY_VALUE_TABLE = new SqlTable("osee_key_value", "key_val", 0);
        OSEE_KEY_VALUE_KEY = OSEE_KEY_VALUE_TABLE.addColumn("KEY", JDBCType.BIGINT);
        OSEE_KEY_VALUE_VALUE = OSEE_KEY_VALUE_TABLE.addVarCharColumn("VALUE", 4000);
        OSEE_KEY_VALUE_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_KEY_VALUE_KEY});
        OSEE_KEY_VALUE_TABLE.createIndex("OSEE_KEY_VALUE__V_IDX", false, new SqlColumn[]{OSEE_KEY_VALUE_VALUE});
        OSEE_KEY_VALUE_TABLE.setTableExtras("TABLESPACE osee_data\n\tPCTTHRESHOLD 20\n\tOVERFLOW TABLESPACE osee_data");
        OSEE_JOIN_ID4_TABLE = new SqlTable("osee_join_id4", "jn_id4", 2);
        OSEE_JOIN_ID4_QUERY_ID = OSEE_JOIN_ID4_TABLE.addColumn("QUERY_ID", JDBCType.BIGINT);
        OSEE_JOIN_ID4_ID1 = OSEE_JOIN_ID4_TABLE.addColumn("ID1", JDBCType.BIGINT);
        OSEE_JOIN_ID4_ID2 = OSEE_JOIN_ID4_TABLE.addColumn("ID2", JDBCType.BIGINT);
        OSEE_JOIN_ID4_ID3 = OSEE_JOIN_ID4_TABLE.addColumn("ID3", JDBCType.BIGINT);
        OSEE_JOIN_ID4_ID4 = OSEE_JOIN_ID4_TABLE.addColumn("ID4", JDBCType.BIGINT);
        OSEE_JOIN_ID4_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_JOIN_ID4_QUERY_ID, OSEE_JOIN_ID4_ID1, OSEE_JOIN_ID4_ID2, OSEE_JOIN_ID4_ID3, OSEE_JOIN_ID4_ID4});
        OSEE_JOIN_ID4_TABLE.createIndex("OSEE_JOIN_ID4__Q_IDX", false, new SqlColumn[]{OSEE_JOIN_ID4_QUERY_ID});
        OSEE_JOIN_ID4_TABLE.setTableExtras("TABLESPACE osee_join");
        OSEE_SERVER_LOOKUP_TABLE = new SqlTable("osee_server_lookup", "srvr_lkup");
        OSEE_SERVER_LOOKUP_SERVER_ID = OSEE_SERVER_LOOKUP_TABLE.addVarCharColumn("SERVER_ID", 40, false);
        OSEE_SERVER_LOOKUP_VERSION_ID = OSEE_SERVER_LOOKUP_TABLE.addVarCharColumn("VERSION_ID", 100, false);
        OSEE_SERVER_LOOKUP_SERVER_URI = OSEE_SERVER_LOOKUP_TABLE.addVarCharColumn("SERVER_URI", 255, false);
        OSEE_SERVER_LOOKUP_START_TIME = OSEE_SERVER_LOOKUP_TABLE.addColumn("START_TIME", JDBCType.TIMESTAMP);
        OSEE_SERVER_LOOKUP_ACCEPTS_REQUESTS = OSEE_SERVER_LOOKUP_TABLE.addColumn("ACCEPTS_REQUESTS", JDBCType.SMALLINT);
        OSEE_SERVER_LOOKUP_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_SERVER_LOOKUP_SERVER_URI, OSEE_SERVER_LOOKUP_VERSION_ID});
        OSEE_SESSION_TABLE = new SqlTable("osee_session", "sess");
        OSEE_SESSION_SESSION_ID = OSEE_SESSION_TABLE.addVarCharColumn("SESSION_ID", 28, false);
        OSEE_SESSION_USER_ID = OSEE_SESSION_TABLE.addVarCharColumn("USER_ID", 100, false);
        OSEE_SESSION_CLIENT_MACHINE_NAME = OSEE_SESSION_TABLE.addVarCharColumn("CLIENT_MACHINE_NAME", 100, false);
        OSEE_SESSION_CLIENT_ADDRESS = OSEE_SESSION_TABLE.addVarCharColumn("CLIENT_ADDRESS", 255, false);
        OSEE_SESSION_CLIENT_PORT = OSEE_SESSION_TABLE.addColumn("CLIENT_PORT", JDBCType.INTEGER);
        OSEE_SESSION_CLIENT_VERSION = OSEE_SESSION_TABLE.addVarCharColumn("CLIENT_VERSION", 100, false);
        OSEE_SESSION_CREATED_ON = OSEE_SESSION_TABLE.addColumn("CREATED_ON", JDBCType.TIMESTAMP);
        OSEE_SESSION_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_SESSION_SESSION_ID});
        OSEE_ACCOUNT_SESSION_TABLE = new SqlTable("osee_account_session", "acc_sess");
        OSEE_ACCOUNT_SESSION_ACCOUNT_ID = OSEE_ACCOUNT_SESSION_TABLE.addColumn("ACCOUNT_ID", JDBCType.BIGINT);
        OSEE_ACCOUNT_SESSION_SESSION_TOKEN = OSEE_ACCOUNT_SESSION_TABLE.addVarCharColumn("SESSION_TOKEN", 255, false);
        OSEE_ACCOUNT_SESSION_CREATED_ON = OSEE_ACCOUNT_SESSION_TABLE.addColumn("CREATED_ON", JDBCType.TIMESTAMP);
        OSEE_ACCOUNT_SESSION_LAST_ACCESSED_ON = OSEE_ACCOUNT_SESSION_TABLE.addColumn("LAST_ACCESSED_ON", JDBCType.TIMESTAMP);
        OSEE_ACCOUNT_SESSION_ACCESSED_FROM = OSEE_ACCOUNT_SESSION_TABLE.addVarCharColumn("ACCESSED_FROM", 255, false);
        OSEE_ACCOUNT_SESSION_ACCESS_DETAILS = OSEE_ACCOUNT_SESSION_TABLE.addVarCharColumn("ACCESS_DETAILS", 255, false);
        OSEE_ACCOUNT_SESSION_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_ACCOUNT_SESSION_ACCOUNT_ID, OSEE_ACCOUNT_SESSION_SESSION_TOKEN});
        OSEE_ACCOUNT_SESSION_TABLE.createIndex("OSEE_ACCOUNT_SESSION_T_IDX", false, new SqlColumn[]{OSEE_ACCOUNT_SESSION_SESSION_TOKEN});
        OSEE_ACTIVITY_TYPE_TABLE = new SqlTable("osee_activity_type", "acc_sess");
        OSEE_ACTIVITY_TYPE_TYPE_ID = OSEE_ACTIVITY_TYPE_TABLE.addColumn("TYPE_ID", JDBCType.BIGINT);
        OSEE_ACTIVITY_TYPE_MODULE = OSEE_ACTIVITY_TYPE_TABLE.addVarCharColumn("MODULE", 4000, true);
        OSEE_ACTIVITY_TYPE_MSG_FORMAT = OSEE_ACTIVITY_TYPE_TABLE.addVarCharColumn("MSG_FORMAT", 4000, true);
        OSEE_ACTIVITY_TYPE_LOG_LEVEL = OSEE_ACTIVITY_TYPE_TABLE.addColumn("CREATED_ON", JDBCType.TIMESTAMP);
        OSEE_ACTIVITY_TYPE_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_ACTIVITY_TYPE_TYPE_ID});
        OSEE_ACTIVITY_TABLE = new SqlTable("osee_activity", "act");
        OSEE_ACTIVITY_ENTRY_ID = OSEE_ACTIVITY_TABLE.addColumn("ENTRY_ID", JDBCType.BIGINT);
        OSEE_ACTIVITY_PARENT_ID = OSEE_ACTIVITY_TABLE.addColumn("PARENT_ID", JDBCType.BIGINT);
        OSEE_ACTIVITY_TYPE_ID = OSEE_ACTIVITY_TABLE.addColumn("TYPE_ID", JDBCType.BIGINT);
        OSEE_ACTIVITY_ACCOUNT_ID = OSEE_ACTIVITY_TABLE.addColumn("ACCOUNT_ID", JDBCType.BIGINT);
        OSEE_ACTIVITY_SERVER_ID = OSEE_ACTIVITY_TABLE.addColumn("SERVER_ID", JDBCType.BIGINT);
        OSEE_ACTIVITY_CLIENT_ID = OSEE_ACTIVITY_TABLE.addColumn("CLIENT_ID", JDBCType.BIGINT);
        OSEE_ACTIVITY_START_TIME = OSEE_ACTIVITY_TABLE.addColumn("START_TIMESTAMP", JDBCType.TIMESTAMP);
        OSEE_ACTIVITY_DURATION = OSEE_ACTIVITY_TABLE.addColumn("DURATION", JDBCType.BIGINT);
        OSEE_ACTIVITY_STATUS = OSEE_ACTIVITY_TABLE.addColumn("STATUS", JDBCType.SMALLINT);
        OSEE_ACTIVITY_MSG_ARGS = OSEE_ACTIVITY_TABLE.addVarCharColumn("MSG_ARGS", 4000, true);
        OSEE_ACTIVITY_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_ACTIVITY_ENTRY_ID});
        OSEE_ACTIVITY_TABLE.createIndex("OSEE_ACTIVITY__P_E_IDX", false, new SqlColumn[]{OSEE_ACTIVITY_PARENT_ID, OSEE_ACTIVITY_ENTRY_ID});
        OSEE_ACTIVITY_TABLE.createIndex("OSEE_ACTIVITY__ACCOUNT_IDX", false, new SqlColumn[]{OSEE_ACTIVITY_ACCOUNT_ID});
        OSEE_ACTIVITY_TABLE.createIndex("OSEE_ACTIVITY__TYPE_IDX", false, new SqlColumn[]{OSEE_ACTIVITY_TYPE_ID});
        OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE = new SqlTable("osee_oauth_client_credential", "oauth_cli_cred");
        OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_ID = OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE.addColumn("CLIENT_ID", JDBCType.BIGINT);
        OSEE_OAUTH_CLIENT_CREDENTIAL_APPLICATION_ID = OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE.addColumn("APPLICATION_ID", JDBCType.BIGINT);
        OSEE_OAUTH_CLIENT_CREDENTIAL_SUBJECT_ID = OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE.addColumn("SUBJECT_ID", JDBCType.BIGINT);
        OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_CERT = OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE.addVarCharColumn("CLIENT_CERT", 255, false);
        OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_SECRET = OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE.addVarCharColumn("CLIENT_SECRET", 255, false);
        OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_KEY = OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE.addVarCharColumn("CLIENT_KEY", 255, true);
        OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE.setPrimaryKeyConstraint("OSEE_OAUTH_CLIENT_CRED__U", new SqlColumn[]{OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_ID});
        OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE.createIndex("OSEE_OAUTH_CLIENT_CRED__CK_IDX", false, new SqlColumn[]{OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_KEY});
        OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE.createIndex("OSEE_OAUTH_CLIENT_CRED__AI_IDX", false, new SqlColumn[]{OSEE_OAUTH_CLIENT_CREDENTIAL_APPLICATION_ID});
        OSEE_OAUTH_AUTHORIZATION_TABLE = new SqlTable("osee_oauth_authorization", "oauth_auth");
        OSEE_OAUTH_AUTHORIZATION_AUDIENCE = OSEE_OAUTH_AUTHORIZATION_TABLE.addVarCharColumn("AUDIENCE", 512, true);
        OSEE_OAUTH_AUTHORIZATION_APPROVED_SCOPES = OSEE_OAUTH_AUTHORIZATION_TABLE.addVarCharColumn("APPROVED_SCOPES", 2000, true);
        OSEE_OAUTH_AUTHORIZATION_REDIRECT_URI = OSEE_OAUTH_AUTHORIZATION_TABLE.addVarCharColumn("REDIRECT_URI", 512, true);
        OSEE_OAUTH_AUTHORIZATION_EXPIRES_IN = OSEE_OAUTH_AUTHORIZATION_TABLE.addColumn("EXPIRES_IN", JDBCType.BIGINT);
        OSEE_OAUTH_AUTHORIZATION_ISSUED_AT = OSEE_OAUTH_AUTHORIZATION_TABLE.addColumn("ISSUED_AT", JDBCType.BIGINT);
        OSEE_OAUTH_AUTHORIZATION_VERIFIER = OSEE_OAUTH_AUTHORIZATION_TABLE.addVarCharColumn("VERIFIER", 512, true);
        OSEE_OAUTH_AUTHORIZATION_CLIENT_ID = OSEE_OAUTH_AUTHORIZATION_TABLE.addColumn("CLIENT_ID", JDBCType.BIGINT);
        OSEE_OAUTH_AUTHORIZATION_ID = OSEE_OAUTH_AUTHORIZATION_TABLE.addColumn("ID", JDBCType.BIGINT);
        OSEE_OAUTH_AUTHORIZATION_SUBJECT_ID = OSEE_OAUTH_AUTHORIZATION_TABLE.addColumn("SUBJECT_ID", JDBCType.BIGINT);
        OSEE_OAUTH_AUTHORIZATION_CODE = OSEE_OAUTH_AUTHORIZATION_TABLE.addVarCharColumn("CODE", 512, true);
        OSEE_OAUTH_AUTHORIZATION_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_OAUTH_AUTHORIZATION_ID});
        OSEE_OAUTH_AUTHORIZATION_TABLE.setForeignKeyConstraintCascadeDelete("OSEE_OAUTH_AUTH__CI_FK", OSEE_OAUTH_AUTHORIZATION_CLIENT_ID, OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE, OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_ID);
        OSEE_OAUTH_AUTHORIZATION_TABLE.createIndex("OSEE_OAUTH_AUTH__C_IDX", false, new SqlColumn[]{OSEE_OAUTH_AUTHORIZATION_CODE});
        OSEE_OAUTH_TOKEN_TABLE = new SqlTable("osee_oauth_token", "oauth_tk");
        OSEE_OAUTH_TOKEN_AUDIENCE = OSEE_OAUTH_TOKEN_TABLE.addVarCharColumn("AUDIENCE", 512, true);
        OSEE_OAUTH_TOKEN_EXPIRES_IN = OSEE_OAUTH_TOKEN_TABLE.addColumn("EXPIRES_IN", JDBCType.BIGINT);
        OSEE_OAUTH_TOKEN_ISSUED_AT = OSEE_OAUTH_TOKEN_TABLE.addColumn("ISSUED_AT", JDBCType.BIGINT);
        OSEE_OAUTH_TOKEN_TOKEN_KEY = OSEE_OAUTH_TOKEN_TABLE.addVarCharColumn("TOKEN_KEY", 512, true);
        OSEE_OAUTH_TOKEN_PARENT_TOKEN_ID = OSEE_OAUTH_TOKEN_TABLE.addColumn("PARENT_TOKEN_ID", JDBCType.BIGINT);
        OSEE_OAUTH_TOKEN_CLIENT_ID = OSEE_OAUTH_TOKEN_TABLE.addColumn("CLIENT_ID", JDBCType.BIGINT);
        OSEE_OAUTH_TOKEN_GRANT_TYPE = OSEE_OAUTH_TOKEN_TABLE.addVarCharColumn("GRANT_TYPE", 255, true);
        OSEE_OAUTH_TOKEN_ID = OSEE_OAUTH_TOKEN_TABLE.addColumn("ID", JDBCType.BIGINT);
        OSEE_OAUTH_TOKEN_SUBJECT_ID = OSEE_OAUTH_TOKEN_TABLE.addColumn("SUBJECT_ID", JDBCType.BIGINT);
        OSEE_OAUTH_TOKEN_PARENT_TYPE_ID = OSEE_OAUTH_TOKEN_TABLE.addColumn("TYPE_ID", JDBCType.SMALLINT);
        OSEE_OAUTH_TOKEN_TOKEN_TYPE = OSEE_OAUTH_TOKEN_TABLE.addVarCharColumn("TOKEN_TYPE", 255, true);
        OSEE_OAUTH_TOKEN_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_OAUTH_TOKEN_ID});
        OSEE_OAUTH_TOKEN_TABLE.setForeignKeyConstraintCascadeDelete("OSEE_OAUTH_TOKEN__CI_FK", OSEE_OAUTH_TOKEN_CLIENT_ID, OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE, OSEE_OAUTH_CLIENT_CREDENTIAL_CLIENT_ID);
        OSEE_OAUTH_TOKEN_TABLE.createIndex("OSEE_OAUTH_TOKEN__TK_IDX", false, new SqlColumn[]{OSEE_OAUTH_TOKEN_TOKEN_KEY});
        OSEE_VALIDATE_GAMMA_ID = new SqlTable("osee_validate_gamma_id", "vgi");
        OSEE_VALIDATE_GAMMA_ID_GAMMA_ID = OSEE_VALIDATE_GAMMA_ID.addColumn("GAMMA_ID", JDBCType.BIGINT);
        OSEE_VALIDATE_GAMMA_ID.setPrimaryKeyConstraint(new SqlColumn[]{OSEE_VALIDATE_GAMMA_ID_GAMMA_ID});
        API_KEY_TABLE = new SqlTable("osee_api_key", "api");
        API_KEY_ID = API_KEY_TABLE.addAutoIncrementColumn("KEY_UID", JDBCType.BIGINT);
        API_KEY_NAME = API_KEY_TABLE.addVarCharColumn("KEY_NAME", 20, false);
        API_KEY_VALUE = API_KEY_TABLE.addVarCharColumn("API_KEY_VALUE", 4000, false);
        API_KEY_SCOPES = API_KEY_TABLE.addVarCharColumn("SCOPES", 4000);
        API_KEY_CREATION_DATE = API_KEY_TABLE.addColumn("CREATION_DATE", JDBCType.TIMESTAMP);
        API_KEY_EXPIRATION_DATE = API_KEY_TABLE.addColumn("EXPIRATION_DATE", JDBCType.TIMESTAMP);
        API_KEY_USER_ARTIFACT_ID = API_KEY_TABLE.addColumn("USER_ART_ID", JDBCType.BIGINT);
        API_KEY_TABLE.setPrimaryKeyConstraint(new SqlColumn[]{API_KEY_ID});
        API_KEY_TABLE.createIndex("OSEE_API_KEY__API_KEY_NAME_IDX", true, new SqlColumn[]{API_KEY_NAME});
        API_KEY_TABLE.createIndex("API_KEYS_API_KEY_VALUE_IDX", true, new SqlColumn[]{API_KEY_VALUE});
        API_KEY_TABLE.createIndex("OSEE_API_KEY__EXPIRATION_DATE_IDX", true, new SqlColumn[]{API_KEY_EXPIRATION_DATE});
        API_KEY_TABLE.createIndex("OSEE_API_KEY__ARTIFACT_ID_IDX", true, new SqlColumn[]{API_KEY_USER_ARTIFACT_ID});
    }

    public static SqlTable getTxsTable(boolean isArchived) {
        return isArchived ? TXS_ARCHIVED_TABLE : TXS_TABLE;
    }
}

