/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.service.registry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicePair<T> {
    private BundleContext ctx;
    private ServiceReference ref;
    private T serviceObject;

    public ServicePair(BundleContext context, ServiceReference serviceRef) {
        this.ctx = context;
        this.ref = serviceRef;
    }

    public ServicePair(BundleContext context, ServiceReference serviceRef, T service) {
        this.ctx = context;
        this.ref = serviceRef;
        this.serviceObject = service;
    }

    public T get() {
        if (this.serviceObject == null && this.ref.getBundle() != null) {
            this.serviceObject = AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    return ServicePair.this.serviceObject = ServicePair.this.ctx.getService(ServicePair.this.ref);
                }
            });
        }
        return this.serviceObject;
    }

    public boolean isValid() {
        return this.ref.getBundle() != null;
    }

    public void unget() {
        if (this.serviceObject != null) {
            this.ctx.ungetService(this.ref);
            this.serviceObject = null;
        }
    }

    public ServiceReference getReference() {
        return this.ref;
    }
}

