/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.DispoSetData;
import org.eclipse.osee.disposition.model.DispoSetDescriptorData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.resources.DispoItemEndpoint;
import org.eclipse.osee.disposition.rest.resources.DispoSourceFileResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;
import org.eclipse.osee.framework.jdk.core.type.Id;

@Swagger
public class DispoSetEndpoint {
    private final DispoApi dispoApi;
    private final BranchId branch;

    public DispoSetEndpoint(DispoApi dispoApi, BranchId branch) {
        this.dispoApi = dispoApi;
        this.branch = branch;
    }

    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new Disposition Set given a DispoSetDescriptor")
    @Tags(value={@Tag(name="create"), @Tag(name="set")})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="OK. Created the Disposition Set"), @ApiResponse(responseCode="409", description="Conflict. Tried to create a Disposition Set with same name"), @ApiResponse(responseCode="400", description="Bad Request. Did not provide both a Name and a valid Import Path")})
    public Response postDispoSet(DispoSetDescriptorData descriptor, @Parameter(description="The Username", required=true) @QueryParam(value="userName") String userName) {
        Response response;
        String name = descriptor.getName();
        String importPath = descriptor.getImportPath();
        String dispoType = descriptor.getDispoType();
        if (!(name.isEmpty() || importPath.isEmpty() || dispoType.isEmpty())) {
            boolean isUniqueSetName = this.dispoApi.isUniqueSetName(this.branch, name);
            if (isUniqueSetName) {
                ArtifactId createdSetId = this.dispoApi.createDispoSet(this.branch, descriptor);
                DispoSet createdSet = this.dispoApi.getDispoSetById(this.branch, ArtifactId.valueOf((Id)createdSetId).getIdString());
                Response.Status status = Response.Status.CREATED;
                response = Response.status((Response.Status)status).entity((Object)createdSet).build();
            } else {
                Response.Status status = Response.Status.CONFLICT;
                response = Response.status((Response.Status)status).entity((Object)"Can't create sets with the same name").build();
            }
        } else {
            Response.Status status = Response.Status.BAD_REQUEST;
            response = Response.status((Response.Status)status).entity((Object)"The Set must have a name and import path").build();
        }
        return response;
    }

    @Path(value="{name}")
    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new Disposition Set given a name, dispoType, and path")
    @Tags(value={@Tag(name="create"), @Tag(name="set")})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="OK. Created the Disposition Set"), @ApiResponse(responseCode="409", description="Conflict. Tried to create a Disposition Set with same name"), @ApiResponse(responseCode="400", description="Bad Request. Did not provide both a Name and a valid Import Path")})
    public Response postDispoSetByName(@Parameter(description="String used to specify the directory to populate the set", required=true) @FormParam(value="path") String importPath, @Parameter(description="String used to name the Set", required=true) @PathParam(value="name") String name, @Parameter(description="String used to specify if using disposition vs coverage", required=true) @QueryParam(value="dispoType") String dispoType, @QueryParam(value="userName") String userName) {
        DispoSetDescriptorData descriptor = new DispoSetDescriptorData();
        descriptor.setName(name);
        descriptor.setImportPath(importPath);
        descriptor.setDispoType(dispoType);
        return this.postDispoSet(descriptor, userName);
    }

    @Path(value="{setId}")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a specific Disposition Set given a setId")
    @Tag(name="set")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Disposition Set"), @ApiResponse(responseCode="404", description="Not Found. Could not find any Disposition Sets")})
    public DispoSet getDispoSetById(@Parameter(description="The Id of the Disposition Set to search for", required=true) @PathParam(value="setId") String setId) {
        return this.dispoApi.getDispoSetById(this.branch, setId);
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get all Disposition Sets on the given branch")
    @Tag(name="sets")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Disposition Set"), @ApiResponse(responseCode="404", description="Not Found. Could not find any Disposition Sets")})
    public Iterable<DispoSet> getAllDispoSets(@Parameter(description="Dispo Set type", required=true) @QueryParam(value="type") String type) {
        List<DispoSet> allDispoSets = this.dispoApi.getDispoSets(this.branch, type);
        return allDispoSets;
    }

    @Path(value="toRerun")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the names of all items in a set that have \"Rerun?\" column checked")
    @Tag(name="rerun")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Disposition Set"), @ApiResponse(responseCode="404", description="Not Found. Could not find any Disposition Sets")})
    public List<String> getCheckedReruns(@Parameter(description="The Set name", required=true) @QueryParam(value="name") String setName) {
        String setId = this.dispoApi.getDispoSetIdByName(this.branch, setName);
        if (setId == null) {
            return null;
        }
        List<String> reruns = this.dispoApi.getCheckedReruns(this.branch, setId);
        return reruns;
    }

    @Path(value="getDispoSetId")
    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Operation(summary="Get Set ID given the Set name")
    @Tag(name="set")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Branch/Set ID"), @ApiResponse(responseCode="404", description="Not Found. Could not find any Branch/Set ID")})
    public String getDispoSetId(@Parameter(description="The Set name", required=true) @FormParam(value="name") String setName) {
        return this.dispoApi.getDispoSetIdByName(this.branch, setName);
    }

    @Path(value="importDispoSet")
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Update Disposition Set given the Set name")
    @Tags(value={@Tag(name="update"), @Tag(name="set")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Updated the Disposition Set"), @ApiResponse(responseCode="404", description="Not Found. Could not find any Disposition Sets to update"), @ApiResponse(responseCode="415", description="Unsupported Media Type")})
    public Response putDispoSetByName(@Parameter(description="The Set name", required=true) @FormParam(value="name") String setName) {
        DispoSetData newDispositionSet = new DispoSetData();
        newDispositionSet.setOperation("Import");
        String setId = this.dispoApi.getDispoSetIdByName(this.branch, setName);
        if (setId != null) {
            this.dispoApi.editDispoSet(this.branch, setId, newDispositionSet);
        }
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{setId}")
    @PUT
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Operation(summary="Edit a specific Disposition Set given a setId and new Disposition Set Data")
    @Tags(value={@Tag(name="update"), @Tag(name="set")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Edited the Disposition Set"), @ApiResponse(responseCode="404", description="Not Found. Could not find and edit any Disposition Sets")})
    public Response putDispoSet(@Parameter(description="The Id of the Disposition Set to search for", required=true) @PathParam(value="setId") String setId, DispoSetData newDispositionSet, @Parameter(description="The Username", required=true) @QueryParam(value="userName") String userName) {
        this.dispoApi.editDispoSet(this.branch, setId, newDispositionSet);
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{setId}/massDisposition")
    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Operation(summary="Edit a specific Disposition Set given a setId and new Disposition Set Data")
    @Tags(value={@Tag(name="edit"), @Tag(name="set")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Edited the Disposition Set"), @ApiResponse(responseCode="404", description="Not Found. Could not find and edit any Disposition Sets")})
    public Response runMassDisposition(@Parameter(description="The Id of the Disposition Set to search for", required=true) @PathParam(value="setId") String setId, @Parameter(description="The Resolution type", required=true) @QueryParam(value="resolutionType") String resolutionType, @Parameter(description="The Resolution", required=true) @QueryParam(value="resolution") String resolution, List<String> itemIds, @QueryParam(value="userName") String userName) {
        this.dispoApi.editMassDispositions(this.branch, setId, itemIds, resolutionType, resolution);
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{setId}")
    @RolesAllowed(value={"dispoAdmin"})
    @DELETE
    @Operation(summary="Delete a specific Disposition Set given a setId")
    @Tags(value={@Tag(name="delete"), @Tag(name="set")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Deleted the Disposition Set"), @ApiResponse(responseCode="404", description="Not Found. Could not find and delete any Disposition Sets")})
    public Response deleteDispoSet(@Parameter(description="The Id of the Disposition Set to search for", required=true) @PathParam(value="setId") String setId, @Parameter(description="The Username", required=true) @QueryParam(value="userName") String userName) {
        Response.Status status = Response.Status.NOT_FOUND;
        boolean wasDeleted = this.dispoApi.deleteDispoSet(this.branch, setId);
        status = wasDeleted ? Response.Status.OK : Response.Status.NOT_FOUND;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{setId}/file")
    @Operation(summary="Get Dispo source files given a Set ID")
    @Tag(name="source")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Retrieved DispoSourceFileResource"), @ApiResponse(responseCode="404", description="Not Found. Could not find any Disposition Sets")})
    public DispoSourceFileResource getDispoSourceFiles(@Parameter(description="The Id of the Disposition Set to search for", required=true) @PathParam(value="setId") String setId) {
        return new DispoSourceFileResource(this.dispoApi, this.branch, setId);
    }

    @Path(value="{setId}/item")
    @Operation(summary="Get Dispo Items given a Set ID")
    @Tag(name="items")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Retrieved Dispo Items"), @ApiResponse(responseCode="404", description="Not Found. Could not find any Disposition Sets")})
    public DispoItemEndpoint getDispositionableItems(@Parameter(description="The Id of the Disposition Set to search for", required=true) @PathParam(value="setId") String setId) {
        return new DispoItemEndpoint(this.dispoApi, this.branch, setId);
    }

    @Path(value="{setId}/search")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a specific Dispositionable Items given a key word within the Dispositions")
    @Tag(name="items")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Retrieved Dispo Items"), @ApiResponse(responseCode="404", description="Not Found. Could not find any Dispositionable Items")})
    public Iterable<DispoItem> getDispoItemsByAnnotationText(@Parameter(description="The Id of the Disposition Set to search for", required=true) @PathParam(value="setId") String setId, @Parameter(description="The Annotation text to search for", required=true) @QueryParam(value="value") String value, @Parameter(description="Is detailed", required=true) @QueryParam(value="isDetailed") boolean isDetailed) {
        Collection<DispoItem> foundItems = this.dispoApi.getDispoItemByAnnotationText(this.branch, setId, value, isDetailed);
        return foundItems;
    }
}

