/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.disposition.model.CopySetParamOption;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.report.FindReruns;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class DispoSetCopier {
    private final DispoConnector connector;
    private final List<DispoAnnotationData> needsRerun = new ArrayList<DispoAnnotationData>();
    String batchRunList = "";

    public DispoSetCopier(DispoConnector connector) {
        this.connector = connector;
    }

    public List<DispoItem> copyAllDispositionsSameSet(Map<String, Set<DispoItemData>> nameToDestItems, Collection<DispoItem> sourceItems, boolean isCoverageCopy, HashMap<String, String> reruns, OperationReport report) {
        return this.copyAllDispositions(nameToDestItems, sourceItems, isCoverageCopy, reruns, false, Collections.emptySet(), true, report);
    }

    public List<DispoItem> copyAllDispositions(Map<String, Set<DispoItemData>> nameToDestItems, Collection<DispoItem> sourceItems, boolean isCoverageCopy, HashMap<String, String> reruns, boolean allowOnlyValidResolutionTypes, Set<String> validResolutionsTypes, boolean isSameSet, OperationReport report) {
        ArrayList<DispoItem> modifiedItems = new ArrayList<DispoItem>();
        for (DispoItem sourceItem : sourceItems) {
            DispoItemData destItem = this.getCorrespondingDestItem(nameToDestItems, sourceItem);
            if (destItem.isValid().booleanValue()) {
                DispoItemData newItem;
                if (isSameSet) {
                    destItem.setGuid((String)sourceItem.getGuid());
                }
                if ((newItem = this.createNewItemWithCopiedAnnotations(destItem, sourceItem, isCoverageCopy, reruns, report, allowOnlyValidResolutionTypes, validResolutionsTypes)) == null || !newItem.isValid().booleanValue()) continue;
                modifiedItems.add((DispoItem)newItem);
                continue;
            }
            report.addEntry(sourceItem.getName(), "No matching item found in the Destination Set", DispoSummarySeverity.WARNING);
        }
        return modifiedItems;
    }

    private DispoItemData getCorrespondingDestItem(Map<String, Set<DispoItemData>> nameToDestItems, DispoItem sourceItem) {
        DispoItemData destItem = DispoItemData.SENTINEL;
        String name = sourceItem.getName();
        Set<DispoItemData> itemsWithSameName = nameToDestItems.get(name);
        if (itemsWithSameName != null) {
            if (itemsWithSameName.size() == 1) {
                destItem = itemsWithSameName.iterator().next();
            } else {
                for (DispoItemData itemWithSameName : itemsWithSameName) {
                    if (!itemWithSameName.getMethodNumber().equals(sourceItem.getMethodNumber()) || !itemWithSameName.getFileNumber().equals(sourceItem.getFileNumber())) continue;
                    destItem = itemWithSameName;
                }
            }
        }
        return destItem;
    }

    private DispoItemData createNewItemWithCopiedAnnotations(DispoItemData destItem, DispoItem sourceItem, boolean isCoverageCopy, HashMap<String, String> reruns, OperationReport report, boolean allowOnlyValidResolutionTypes, Set<String> validResolutionTypes) {
        DispoItemData toReturn = null;
        toReturn = this.buildNewItem(destItem, sourceItem, isCoverageCopy, reruns, report, allowOnlyValidResolutionTypes, validResolutionTypes);
        return toReturn;
    }

    private DispoItemData buildNewItem(DispoItemData destItem, DispoItem sourceItem, boolean isCoverageCopy, HashMap<String, String> reruns, OperationReport report, boolean allowOnlyValidResolutionTypes, Set<String> validResolutionTypes) {
        List sourceAnnotations = sourceItem.getAnnotationsList();
        Map<String, DispoAnnotationData> destAnnotationMap = this.getLocToAnnotationMap(destItem.getAnnotationsList());
        for (DispoAnnotationData sourceAnnotation : sourceAnnotations) {
            String sourceLocation = sourceAnnotation.getLocationRefs();
            if (sourceAnnotation.getGuid() == null) {
                sourceAnnotation.setId(String.valueOf(Lib.generateUuid()));
            }
            if (!destAnnotationMap.containsKey(sourceLocation)) continue;
            DispoAnnotationData destAnnotation = destAnnotationMap.get(sourceLocation);
            if (sourceAnnotation.getCustomerNotes() == null || destAnnotation.getCustomerNotes() == null) continue;
            if (!sourceAnnotation.getCustomerNotes().equals(destAnnotation.getCustomerNotes()) || allowOnlyValidResolutionTypes && !validResolutionTypes.contains(sourceAnnotation.getResolutionType())) {
                if (!DispoUtil.isDefaultAnotation(sourceAnnotation) && Strings.isValid((String)sourceAnnotation.getResolutionType())) continue;
                destItem.setNeedsRerun(true);
                this.needsRerun.add(sourceAnnotation);
                continue;
            }
            String sourceResolutionType = sourceAnnotation.getResolutionType();
            String sourceResolution = sourceAnnotation.getResolution();
            String sourceLastResolutionType = sourceAnnotation.getLastResolutionType();
            String sourceLastResolution = sourceAnnotation.getLastResolution();
            String sourceLastManualResolutionType = sourceAnnotation.getLastManualResolutionType();
            String sourceLastManualResolution = sourceAnnotation.getLastManualResolution();
            DispoAnnotationData newDestAnnot = new DispoAnnotationData();
            newDestAnnot = DispoUtil.isAnnotationValueBlank(sourceAnnotation) ? (DispoUtil.isAnnotationValueBlank(destAnnotation) && !sourceLastManualResolutionType.isEmpty() && !sourceLastManualResolutionType.isBlank() && sourceLastManualResolutionType != null ? new DispoAnnotationData(destAnnotation, sourceLastManualResolutionType, sourceLastManualResolution, sourceLastResolutionType, sourceLastResolution, sourceLastManualResolutionType, sourceLastManualResolution, true) : new DispoAnnotationData(destAnnotation, sourceLastResolutionType, sourceLastResolution, sourceLastManualResolutionType, sourceLastManualResolution)) : (DispoUtil.isDefaultAnotation(sourceAnnotation) ? (DispoUtil.isAnnotationValueBlank(destAnnotation) && !sourceLastManualResolutionType.isEmpty() && !sourceLastManualResolutionType.isBlank() && sourceLastManualResolutionType != null ? new DispoAnnotationData(destAnnotation, sourceLastManualResolutionType, sourceLastManualResolution, sourceResolutionType, sourceResolution, sourceLastManualResolutionType, sourceLastManualResolution, true) : new DispoAnnotationData(destAnnotation, sourceResolutionType, sourceResolution, sourceLastManualResolutionType, sourceLastManualResolution)) : (DispoUtil.isAnnotationValueBlank(destAnnotation) ? new DispoAnnotationData(destAnnotation, sourceResolutionType, sourceResolution, sourceLastResolutionType, sourceLastResolution, sourceLastManualResolutionType, sourceLastManualResolution, sourceAnnotation.getIsResolutionValid()) : new DispoAnnotationData(destAnnotation, sourceResolutionType, sourceResolution, sourceResolutionType, sourceResolution)));
            DispoUtil.addAnnotation(destItem.getAnnotationsList(), newDestAnnot);
        }
        if (destItem.getNeedsRerun() != null && destItem.getNeedsRerun().booleanValue()) {
            report.addEntry(destItem.getName(), "Needs Rerun", DispoSummarySeverity.UPDATE);
            if (reruns != null) {
                HashMap<String, String> tmpList = new FindReruns().createList(this.needsRerun);
                for (Map.Entry<String, String> entry : tmpList.entrySet()) {
                    reruns.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return destItem;
    }

    private Map<String, DispoAnnotationData> getLocToAnnotationMap(List<DispoAnnotationData> annotations) {
        HashMap<String, DispoAnnotationData> locToAnnotationMap = new HashMap<String, DispoAnnotationData>();
        if (annotations == null) {
            annotations = new ArrayList<DispoAnnotationData>();
        }
        for (DispoAnnotationData annotation : annotations) {
            locToAnnotationMap.put(annotation.getLocationRefs(), annotation);
        }
        return locToAnnotationMap;
    }

    public void copyCategories(Map<String, Set<DispoItemData>> destinationItems, Collection<DispoItem> sourceItems, Map<String, DispoItem> toEdit, CopySetParamOption option) {
        for (DispoItem sourceItem : sourceItems) {
            String newCategory;
            DispoItemData destItem = this.getCorrespondingDestItem(destinationItems, sourceItem);
            if (!destItem.isValid().booleanValue()) continue;
            String currentCategory = destItem.getCategory();
            String sourceCategory = sourceItem.getCategory();
            if (!Strings.isValid((String)sourceCategory)) continue;
            switch (option) {
                case OVERRIDE: {
                    newCategory = sourceCategory;
                    break;
                }
                case OVERRIDE_EMPTY: {
                    if (!Strings.isValid((String)currentCategory)) {
                        newCategory = sourceCategory;
                        break;
                    }
                    newCategory = currentCategory;
                    break;
                }
                case MERGE: {
                    if (!Strings.isValid((String)currentCategory)) {
                        newCategory = sourceCategory;
                        break;
                    }
                    newCategory = String.valueOf(currentCategory) + "::" + sourceCategory;
                    break;
                }
                default: {
                    newCategory = currentCategory;
                }
            }
            DispoItem matchingToEdit = toEdit.get(sourceItem.getName());
            if (matchingToEdit != null) {
                ((DispoItemData)matchingToEdit).setCategory(newCategory);
                continue;
            }
            DispoItemData newToEdit = new DispoItemData();
            newToEdit.setGuid((String)destItem.getGuid());
            newToEdit.setName(destItem.getName());
            newToEdit.setCategory(newCategory);
            toEdit.put(newToEdit.getName(), (DispoItem)newToEdit);
        }
    }

    public void copyAssignee(Map<String, Set<DispoItemData>> destinationItems, Collection<DispoItem> sourceItems, Map<String, DispoItem> toEdit, CopySetParamOption option) {
        for (DispoItem sourceItem : sourceItems) {
            String newAssignee;
            DispoItemData destItem = this.getCorrespondingDestItem(destinationItems, sourceItem);
            if (!destItem.isValid().booleanValue()) continue;
            String currentAssignee = destItem.getAssignee();
            String sourceAssignee = sourceItem.getAssignee();
            if (sourceAssignee.equalsIgnoreCase("UNASSIGNED")) continue;
            switch (option) {
                case OVERRIDE: {
                    newAssignee = sourceAssignee;
                    break;
                }
                case OVERRIDE_EMPTY: {
                    if (currentAssignee.equalsIgnoreCase("UNASSIGNED")) {
                        newAssignee = sourceAssignee;
                        break;
                    }
                    newAssignee = currentAssignee;
                    break;
                }
                default: {
                    newAssignee = currentAssignee;
                }
            }
            DispoItem matchingToEdit = toEdit.get(sourceItem.getName());
            if (matchingToEdit != null) {
                ((DispoItemData)matchingToEdit).setAssignee(newAssignee);
                continue;
            }
            DispoItemData newToEdit = new DispoItemData();
            newToEdit.setGuid((String)destItem.getGuid());
            newToEdit.setName(destItem.getName());
            newToEdit.setAssignee(newAssignee);
            toEdit.put(newToEdit.getName(), (DispoItem)newToEdit);
        }
    }

    public void copyNotes(Map<String, Set<DispoItemData>> destinationItems, Collection<DispoItem> sourceItems, Map<String, DispoItem> toEdit, CopySetParamOption option) {
        for (DispoItem sourceItem : sourceItems) {
            String newItemNotes;
            DispoItemData destItem = this.getCorrespondingDestItem(destinationItems, sourceItem);
            if (!destItem.isValid().booleanValue()) continue;
            String currentItemNotes = destItem.getItemNotes();
            String sourceItemNotes = sourceItem.getItemNotes();
            if (!Strings.isValid((String)sourceItemNotes)) continue;
            switch (option) {
                case OVERRIDE: {
                    newItemNotes = sourceItemNotes;
                    break;
                }
                case OVERRIDE_EMPTY: {
                    if (!Strings.isValid((String)currentItemNotes)) {
                        newItemNotes = sourceItemNotes;
                        break;
                    }
                    newItemNotes = currentItemNotes;
                    break;
                }
                case MERGE: {
                    if (!Strings.isValid((String)currentItemNotes)) {
                        newItemNotes = sourceItemNotes;
                        break;
                    }
                    newItemNotes = String.valueOf(currentItemNotes) + "::" + sourceItemNotes;
                    break;
                }
                default: {
                    newItemNotes = currentItemNotes;
                }
            }
            DispoItem matchingToEdit = toEdit.get(sourceItem.getName());
            if (matchingToEdit != null) {
                ((DispoItemData)matchingToEdit).setItemNotes(newItemNotes);
                continue;
            }
            DispoItemData newToEdit = new DispoItemData();
            newToEdit.setGuid((String)destItem.getGuid());
            newToEdit.setName(destItem.getName());
            newToEdit.setItemNotes(newItemNotes);
            toEdit.put(newToEdit.getName(), (DispoItem)newToEdit);
        }
    }
}

