/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.eclipse.osee.account.rest.model.AccountWebPreferences;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AccountUtil {
    public static String updateSinglePreference(AccountWebPreferences allPreferences, String key, String id, String newValue) {
        try {
            ObjectMapper OM = new ObjectMapper();
            JsonNode preferencesJObject = OM.readTree(allPreferences.toString());
            JsonNode singlePreferenceObject = OM.readTree(preferencesJObject.get(key).toString());
            HashMap<Object, JsonNode> jsonArray = new HashMap<Object, JsonNode>();
            if (!Strings.isValid((String)id)) {
                JsonNode newValueAsObject = AccountUtil.createNewPreference(newValue);
                jsonArray.put(newValueAsObject.get("id"), newValueAsObject);
            } else {
                JsonNode newValueAsObject = OM.readTree(newValue);
                if (newValueAsObject.toString().equals("{}")) {
                    jsonArray.remove(id);
                } else {
                    jsonArray.put(id, newValueAsObject);
                }
            }
            jsonArray.put(key, singlePreferenceObject);
            return preferencesJObject.toString();
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    private static JsonNode createNewPreference(String newValue) {
        String newId = GUID.create();
        try {
            ObjectMapper OM = new ObjectMapper();
            JsonNode newObject = OM.readTree(newValue);
            HashMap<String, String> jsonArray = new HashMap<String, String>();
            jsonArray.put("id", newId);
            return newObject;
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }
}

