/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.RelationTypeSide;

public class NodeTraceReportItem {
    ArtifactId id;
    String name;
    String artifactType;
    List<NodeTraceReportItem> relatedItems;

    public NodeTraceReportItem(ArtifactReadable art) {
        this(art, RelationTypeSide.SENTINEL);
    }

    public NodeTraceReportItem(ArtifactReadable art, RelationTypeSide relType) {
        this.id = ArtifactId.valueOf((Long)art.getId());
        this.name = art.getName();
        this.artifactType = art.getArtifactType().getName();
        this.relatedItems = relType.isValid() ? art.getRelated(relType).getList().stream().distinct().map(a -> new NodeTraceReportItem((ArtifactReadable)a)).collect(Collectors.toList()) : new LinkedList<NodeTraceReportItem>();
    }

    public ArtifactId getId() {
        return this.id;
    }

    public void setId(ArtifactId id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public List<NodeTraceReportItem> getRelatedItems() {
        return this.relatedItems;
    }

    public void setRelatedItems(List<NodeTraceReportItem> relatedItems) {
        this.relatedItems = relatedItems;
    }
}

