/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.mim.types.MimChangeSummaryItem;

public class MimChangeSummary {
    private final Map<ArtifactId, MimChangeSummaryItem> allChanges;
    private final Map<ArtifactId, MimChangeSummaryItem> nodes;
    private final Map<ArtifactId, MimChangeSummaryItem> connections;
    private final Map<ArtifactId, MimChangeSummaryItem> messages;
    private final Map<ArtifactId, MimChangeSummaryItem> subMessages;
    private final Map<ArtifactId, MimChangeSummaryItem> structures;

    public MimChangeSummary(Map<ArtifactId, MimChangeSummaryItem> allChanges) {
        this.allChanges = allChanges;
        this.nodes = new HashMap<ArtifactId, MimChangeSummaryItem>();
        this.connections = new HashMap<ArtifactId, MimChangeSummaryItem>();
        this.messages = new HashMap<ArtifactId, MimChangeSummaryItem>();
        this.subMessages = new HashMap<ArtifactId, MimChangeSummaryItem>();
        this.structures = new HashMap<ArtifactId, MimChangeSummaryItem>();
    }

    @JsonIgnore
    public Map<ArtifactId, MimChangeSummaryItem> getAll() {
        return this.allChanges;
    }

    public Map<ArtifactId, MimChangeSummaryItem> getNodes() {
        return this.nodes;
    }

    public Map<ArtifactId, MimChangeSummaryItem> getConnections() {
        return this.connections;
    }

    public Map<ArtifactId, MimChangeSummaryItem> getMessages() {
        return this.messages;
    }

    public Map<ArtifactId, MimChangeSummaryItem> getSubMessages() {
        return this.subMessages;
    }

    public Map<ArtifactId, MimChangeSummaryItem> getStructures() {
        return this.structures;
    }

    public MimChangeSummaryItem get(ArtifactReadable art) {
        return this.get(ArtifactId.valueOf((Long)art.getId()), art.getArtifactType());
    }

    public MimChangeSummaryItem get(ArtifactId artId, ArtifactTypeToken artType) {
        if (CoreArtifactTypes.InterfaceNode.equals(artType)) {
            return this.nodes.get(artId);
        }
        if (CoreArtifactTypes.InterfaceConnection.equals(artType)) {
            return this.connections.get(artId);
        }
        if (CoreArtifactTypes.InterfaceMessage.equals(artType)) {
            return this.messages.get(artId);
        }
        if (CoreArtifactTypes.InterfaceSubMessage.equals(artType)) {
            return this.subMessages.get(artId);
        }
        if (CoreArtifactTypes.InterfaceStructure.equals(artType)) {
            return this.structures.get(artId);
        }
        return null;
    }
}

