/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithGammas;
import org.eclipse.osee.accessor.types.AttributePojo;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class InterfaceUnitToken
extends ArtifactAccessorResultWithGammas {
    public static final InterfaceUnitToken SENTINEL = new InterfaceUnitToken();
    private AttributePojo<String> measurement = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceUnitMeasurement, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private ApplicabilityToken applicability;

    public InterfaceUnitToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceUnitToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.Name, (Object)"")));
        this.setMeasurement((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceUnitMeasurement, (Object)"")));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public InterfaceUnitToken(Long id, String name) {
        super(id, AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Name, (GammaId)GammaId.SENTINEL, (Object)name, (String)""));
        this.setMeasurement("");
        this.setApplicability(ApplicabilityToken.BASE);
    }

    public InterfaceUnitToken() {
    }

    public AttributePojo<String> getMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(String measurement) {
        this.measurement = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceUnitMeasurement, (GammaId)GammaId.SENTINEL, (Object)measurement, (String)"");
    }

    @JsonProperty
    public void setMeasurement(AttributePojo<String> measurement) {
        this.measurement = measurement;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public CreateArtifact createArtifact(String key, ApplicabilityId applicId) {
        HashMap<AttributeTypeString, String> values = new HashMap<AttributeTypeString, String>();
        values.put(CoreAttributeTypes.InterfaceUnitMeasurement, (String)this.getMeasurement().getValue());
        CreateArtifact art = new CreateArtifact();
        art.setName((String)this.getName().getValue());
        art.setTypeId(CoreArtifactTypes.InterfaceUnit.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.InterfaceUnit.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setApplicabilityId(applicId.getIdString());
        art.setkey(key);
        return art;
    }
}

