/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithGammas;
import org.eclipse.osee.accessor.types.AttributePojo;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.types.ElementArrayIndexOrder;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class InterfaceStructureElementToken
extends ArtifactAccessorResultWithGammas {
    public static final InterfaceStructureElementToken SENTINEL = new InterfaceStructureElementToken();
    private AttributePojo<String> enumLiteral = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementEnumLiteral, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private AttributePojo<Boolean> InterfaceElementAlterable = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementAlterable, (GammaId)GammaId.SENTINEL, (Object)false, (String)"");
    private AttributePojo<Boolean> interfaceElementArrayHeader = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayHeader, (GammaId)GammaId.SENTINEL, (Object)false, (String)"");
    private AttributePojo<Boolean> interfaceElementWriteArrayHeaderName = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementWriteArrayHeaderName, (GammaId)GammaId.SENTINEL, (Object)false, (String)"");
    private AttributePojo<String> interfaceElementArrayIndexOrder = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayIndexOrder, (GammaId)GammaId.SENTINEL, (Object)ElementArrayIndexOrder.OUTER_INNER.toString(), (String)"");
    private AttributePojo<String> interfaceElementArrayIndexDelimiterOne = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayIndexDelimiterOne, (GammaId)GammaId.SENTINEL, (Object)" ", (String)"");
    private AttributePojo<String> interfaceElementArrayIndexDelimiterTwo = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayIndexDelimiterTwo, (GammaId)GammaId.SENTINEL, (Object)" ", (String)"");
    private AttributePojo<String> Notes = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Notes, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private AttributePojo<String> Description = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Description, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private AttributePojo<Integer> InterfaceElementIndexStart = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexStart, (GammaId)GammaId.SENTINEL, (Object)0, (String)"");
    private AttributePojo<Integer> InterfaceElementIndexEnd = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexEnd, (GammaId)GammaId.SENTINEL, (Object)0, (String)"");
    private List<InterfaceStructureElementToken> arrayElements = new LinkedList<InterfaceStructureElementToken>();
    private InterfaceEnumerationSet arrayDescriptionSet = InterfaceEnumerationSet.SENTINEL;
    private AttributePojo<Boolean> interfaceElementBlockData = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementBlockData, (GammaId)GammaId.SENTINEL, (Object)false, (String)"");
    private Double beginByte = 0.0;
    private Double beginWord = 0.0;
    private ApplicabilityToken applicability = ApplicabilityToken.BASE;
    private AttributePojo<String> InterfaceDefaultValue = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceDefaultValue, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private boolean autogenerated = false;
    private boolean includedInCounts = true;
    private boolean isArrayChild = false;
    private boolean hasNegativeEndByteOffset = false;
    private PlatformTypeToken platformType = PlatformTypeToken.SENTINEL;
    private boolean shouldValidate = false;
    private int validationSize = 8;

    public InterfaceStructureElementToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceStructureElementToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.Name, (Object)"")));
        this.setInterfaceElementAlterable((AttributePojo<Boolean>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceElementAlterable, (Object)false)));
        this.setInterfaceElementArrayHeader((AttributePojo<Boolean>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayHeader, (Object)false)));
        this.setInterfaceElementWriteArrayHeaderName((AttributePojo<Boolean>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceElementWriteArrayHeaderName, (Object)false)));
        this.setInterfaceElementIndexStart((AttributePojo<Integer>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexStart, (Object)0)));
        this.setInterfaceElementIndexEnd((AttributePojo<Integer>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexEnd, (Object)0)));
        this.setNotes((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.Notes, (Object)"")));
        this.setDescription((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.Description, (Object)"")));
        this.setEnumLiteral((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceElementEnumLiteral, (Object)"")));
        this.setInterfaceDefaultValue((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceDefaultValue, (Object)"")));
        this.setInterfaceElementArrayIndexOrder((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayIndexOrder, (Object)ElementArrayIndexOrder.OUTER_INNER.toString())));
        this.setInterfaceElementArrayIndexDelimiterOne((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayIndexDelimiterOne, (Object)"")));
        this.setInterfaceElementArrayIndexDelimiterTwo((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayIndexDelimiterTwo, (Object)"")));
        this.setInterfaceElementBlockData((AttributePojo<Boolean>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceElementBlockData, (Object)false)));
        ArtifactReadable pTypeArt = (ArtifactReadable)art.getRelated(CoreRelationTypes.InterfaceElementPlatformType_PlatformType).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
        if (!(!pTypeArt.isValid() || pTypeArt.getExistingAttributeTypes().isEmpty() || this.getInterfaceElementArrayHeader().isValid() && ((Boolean)this.getInterfaceElementArrayHeader().getValue()).booleanValue())) {
            PlatformTypeToken pType = new PlatformTypeToken(pTypeArt);
            this.setPlatformType(pType);
            if (pType.getEnumSet().isValid()) {
                this.setEnumLiteral(pType.getEnumSet().getDescription());
            }
            if (this.getInterfaceDefaultValue().isValid() && ((String)this.getInterfaceDefaultValue().getValue()).isEmpty() || this.getInterfaceDefaultValue().isInvalid()) {
                this.setInterfaceDefaultValue(pType.getInterfaceDefaultValue() != null & pType.getInterfaceDefaultValue().isValid() ? (String)pType.getInterfaceDefaultValue().getValue() : "");
            }
        } else if (this.getInterfaceElementArrayHeader().isValid() && ((Boolean)this.getInterfaceElementArrayHeader().getValue()).booleanValue()) {
            PlatformTypeToken arrayHeaderType = new PlatformTypeToken(0L, "Element Array Header", "", "0", "", "", "");
            arrayHeaderType.setDescription("");
            arrayHeaderType.setInterfaceDefaultValue("");
            arrayHeaderType.setInterfacePlatformType2sComplement(false);
            arrayHeaderType.setInterfacePlatformTypeAnalogAccuracy("");
            arrayHeaderType.setInterfacePlatformTypeBitsResolution("");
            arrayHeaderType.setInterfacePlatformTypeCompRate("");
            arrayHeaderType.setInterfacePlatformTypeMsbValue("");
            this.setPlatformType(arrayHeaderType);
            this.setInterfaceDefaultValue((String)arrayHeaderType.getInterfaceDefaultValue().getValue());
        } else {
            this.setPlatformType(PlatformTypeToken.SENTINEL);
            this.setInterfaceDefaultValue("");
            this.getPlatformType().setDescription("");
        }
        this.setArrayElements(art.getRelated(CoreRelationTypes.InterfaceElementArrayElement_ArrayElement).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceStructureElementToken((ArtifactReadable)a)).collect(Collectors.toList()));
        ArtifactReadable arrayDescptionSetArt = (ArtifactReadable)art.getRelated(CoreRelationTypes.InterfaceElementArrayIndexDescriptionSet_Set).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (arrayDescptionSetArt.isValid() && !arrayDescptionSetArt.getExistingAttributeTypes().isEmpty()) {
            this.setArrayDescriptionSet(new InterfaceEnumerationSet(arrayDescptionSetArt));
        }
    }

    public InterfaceStructureElementToken(String name, String description, Double beginByte, Double beginWord, Integer size) {
        this(name, description, beginByte, beginWord, size, false);
    }

    public InterfaceStructureElementToken(String name, String description, Double beginByte, Double beginWord, Integer size, boolean offset) {
        super(Long.valueOf(-1L), AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Name, (GammaId)GammaId.SENTINEL, (Object)name, (String)""));
        this.setId(-1L);
        this.setName(name);
        this.setDescription(description);
        this.setInterfaceElementAlterable(false);
        this.setInterfaceElementIndexStart(0);
        this.setInterfaceElementIndexEnd(size - 1);
        this.setNotes("");
        this.setBeginByte(beginByte);
        this.setBeginWord(beginWord);
        this.setApplicability(ApplicabilityToken.BASE);
        this.setInterfaceDefaultValue("");
        this.setAutogenerated(true);
        this.setIncludedInCounts(false);
        this.setHasNegativeEndByteOffset(offset);
        this.getPlatformType().setDescription("Autogenerated upon page load");
        this.setEnumLiteral("");
        this.setInterfaceElementArrayHeader(false);
    }

    public InterfaceStructureElementToken(Long id, String name, ApplicabilityToken applicability, PlatformTypeToken pType) {
        super(id, AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Name, (GammaId)GammaId.SENTINEL, (Object)name, (String)""));
        this.setDescription("");
        this.setNotes("");
        this.setInterfaceElementAlterable(false);
        this.setInterfaceElementIndexStart(0);
        this.setInterfaceElementIndexEnd(0);
        this.setApplicability(applicability);
        this.setPlatformType(pType);
        this.setAutogenerated(true);
        this.getPlatformType().setDescription("Autogenerated upon page load");
        this.setEnumLiteral("");
        this.setInterfaceElementArrayHeader(false);
    }

    public InterfaceStructureElementToken(Long id, String name) {
        super(id, AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Name, (GammaId)GammaId.SENTINEL, (Object)name, (String)""));
    }

    public InterfaceStructureElementToken() {
    }

    public AttributePojo<String> getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Description, (GammaId)GammaId.SENTINEL, (Object)description, (String)"");
    }

    @JsonProperty
    public void setDescription(AttributePojo<String> description) {
        this.Description = description;
    }

    public AttributePojo<String> getNotes() {
        return this.Notes;
    }

    public void setNotes(String notes) {
        this.Notes = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Notes, (GammaId)GammaId.SENTINEL, (Object)notes, (String)"");
    }

    @JsonProperty
    public void setNotes(AttributePojo<String> notes) {
        this.Notes = notes;
    }

    public AttributePojo<Boolean> getInterfaceElementAlterable() {
        return this.InterfaceElementAlterable;
    }

    public void setInterfaceElementAlterable(Boolean interfaceElementAlterable) {
        this.InterfaceElementAlterable = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementAlterable, (GammaId)GammaId.SENTINEL, (Object)interfaceElementAlterable, (String)"");
    }

    @JsonProperty
    public void setInterfaceElementAlterable(AttributePojo<Boolean> interfaceElementAlterable) {
        this.InterfaceElementAlterable = interfaceElementAlterable;
    }

    public AttributePojo<Boolean> getInterfaceElementArrayHeader() {
        return this.interfaceElementArrayHeader;
    }

    public void setInterfaceElementArrayHeader(Boolean interfaceElementArrayHeader) {
        this.interfaceElementArrayHeader = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayHeader, (GammaId)GammaId.SENTINEL, (Object)interfaceElementArrayHeader, (String)"");
    }

    @JsonProperty
    public void setInterfaceElementArrayHeader(AttributePojo<Boolean> interfaceElementArrayHeader) {
        this.interfaceElementArrayHeader = interfaceElementArrayHeader;
    }

    public AttributePojo<Boolean> getInterfaceElementWriteArrayHeaderName() {
        return this.interfaceElementWriteArrayHeaderName;
    }

    public void setInterfaceElementWriteArrayHeaderName(Boolean interfaceElementWriteArrayHeaderName) {
        this.interfaceElementWriteArrayHeaderName = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementWriteArrayHeaderName, (GammaId)GammaId.SENTINEL, (Object)interfaceElementWriteArrayHeaderName, (String)"");
    }

    @JsonProperty
    public void setInterfaceElementWriteArrayHeaderName(AttributePojo<Boolean> interfaceElementWriteArrayHeaderName) {
        this.interfaceElementWriteArrayHeaderName = interfaceElementWriteArrayHeaderName;
    }

    public AttributePojo<String> getInterfaceElementArrayIndexDelimiterOne() {
        return this.interfaceElementArrayIndexDelimiterOne;
    }

    public void setInterfaceElementArrayIndexDelimiterOne(String interfaceElementArrayIndexDelimiterOne) {
        this.interfaceElementArrayIndexDelimiterOne = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayIndexDelimiterOne, (GammaId)GammaId.SENTINEL, (Object)interfaceElementArrayIndexDelimiterOne, (String)"");
    }

    @JsonProperty
    public void setInterfaceElementArrayIndexDelimiterOne(AttributePojo<String> interfaceElementArrayIndexDelimiterOne) {
        this.interfaceElementArrayIndexDelimiterOne = interfaceElementArrayIndexDelimiterOne;
    }

    public AttributePojo<String> getInterfaceElementArrayIndexDelimiterTwo() {
        return this.interfaceElementArrayIndexDelimiterTwo;
    }

    public void setInterfaceElementArrayIndexDelimiterTwo(String interfaceElementArrayIndexDelimiterTwo) {
        this.interfaceElementArrayIndexDelimiterTwo = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayIndexDelimiterTwo, (GammaId)GammaId.SENTINEL, (Object)interfaceElementArrayIndexDelimiterTwo, (String)"");
    }

    @JsonProperty
    public void setInterfaceElementArrayIndexDelimiterTwo(AttributePojo<String> interfaceElementArrayIndexDelimiterTwo) {
        this.interfaceElementArrayIndexDelimiterTwo = interfaceElementArrayIndexDelimiterTwo;
    }

    public AttributePojo<String> getInterfaceElementArrayIndexOrder() {
        return this.interfaceElementArrayIndexOrder;
    }

    public void setInterfaceElementArrayIndexOrder(String interfaceElementArrayIndexOrder) {
        this.interfaceElementArrayIndexOrder = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayIndexOrder, (GammaId)GammaId.SENTINEL, (Object)interfaceElementArrayIndexOrder, (String)"");
    }

    @JsonProperty
    public void setInterfaceElementArrayIndexOrder(AttributePojo<String> interfaceElementArrayIndexOrder) {
        this.interfaceElementArrayIndexOrder = interfaceElementArrayIndexOrder;
    }

    public void setInterfaceElementArrayIndexOrder(ElementArrayIndexOrder interfaceElementArrayIndexOrder) {
        this.interfaceElementArrayIndexOrder = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementArrayIndexOrder, (GammaId)GammaId.SENTINEL, (Object)interfaceElementArrayIndexOrder.toString(), (String)"");
    }

    public AttributePojo<Integer> getInterfaceElementIndexStart() {
        return this.InterfaceElementIndexStart;
    }

    public void setInterfaceElementIndexStart(Integer interfaceElementIndexStart) {
        this.InterfaceElementIndexStart = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexStart, (GammaId)GammaId.SENTINEL, (Object)interfaceElementIndexStart, (String)"");
    }

    @JsonProperty
    public void setInterfaceElementIndexStart(AttributePojo<Integer> interfaceElementIndexStart) {
        this.InterfaceElementIndexStart = interfaceElementIndexStart;
    }

    public AttributePojo<Integer> getInterfaceElementIndexEnd() {
        return this.InterfaceElementIndexEnd;
    }

    public void setInterfaceElementIndexEnd(Integer interfaceElementIndexEnd) {
        this.InterfaceElementIndexEnd = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexEnd, (GammaId)GammaId.SENTINEL, (Object)interfaceElementIndexEnd, (String)"");
    }

    @JsonProperty
    public void setInterfaceElementIndexEnd(AttributePojo<Integer> interfaceElementIndexEnd) {
        this.InterfaceElementIndexEnd = interfaceElementIndexEnd;
    }

    public Double getBeginByte() {
        return this.beginByte;
    }

    public void setBeginByte(Double beginByte) {
        this.beginByte = beginByte;
    }

    public Double getEndByte() {
        return Math.max(0.0, (this.beginByte + this.getElementSizeInBytes() - 1.0) % (double)(this.getValidationSize() / 2));
    }

    public Double getBeginWord() {
        return this.beginWord;
    }

    public void setBeginWord(Double beginWord) {
        this.beginWord = beginWord;
    }

    public Double getEndWord() {
        return Math.max(0.0, Math.ceil((this.getBeginWord() * (double)(this.getValidationSize() / 2) + this.getBeginByte() + this.getElementSizeInBytes()) / (double)(this.getValidationSize() / 2)) - 1.0);
    }

    @JsonIgnore
    public Double getEndingByteNoReset() {
        return this.getEndWord() * (double)(this.getValidationSize() / 2);
    }

    @JsonIgnore
    public Double getEndingBitNoReset() {
        return this.getEndingByteNoReset() * 8.0;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public AttributePojo<String> getInterfaceDefaultValue() {
        return this.InterfaceDefaultValue;
    }

    public void setInterfaceDefaultValue(String interfaceDefaultValue) {
        this.InterfaceDefaultValue = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceDefaultValue, (GammaId)GammaId.SENTINEL, (Object)interfaceDefaultValue, (String)"");
    }

    @JsonProperty
    public void setInterfaceDefaultValue(AttributePojo<String> interfaceDefaultValue) {
        this.InterfaceDefaultValue = interfaceDefaultValue;
    }

    public boolean isAutogenerated() {
        return this.autogenerated;
    }

    public void setAutogenerated(boolean autogenerated) {
        this.autogenerated = autogenerated;
    }

    @JsonIgnore
    public boolean isIncludedInCounts() {
        return this.includedInCounts;
    }

    @JsonIgnore
    public void setIncludedInCounts(boolean includedInCounts) {
        this.includedInCounts = includedInCounts;
    }

    @JsonIgnore
    public double getInterfacePlatformTypeBitSize() {
        return Double.parseDouble((String)this.platformType.getInterfacePlatformTypeBitSize().getValue());
    }

    @JsonIgnore
    public double getInterfacePlatformTypeByteSize() {
        return Double.parseDouble((String)this.platformType.getInterfacePlatformTypeBitSize().getValue()) / 8.0;
    }

    @JsonIgnore
    public double getInterfacePlatformTypeWordSize() {
        return Math.floor(this.getInterfacePlatformTypeByteSize() / (double)(this.getValidationSize() / 2));
    }

    @JsonIgnore
    public int getArrayLength() {
        return (Integer)this.getInterfaceElementIndexEnd().getValue() - (Integer)this.getInterfaceElementIndexStart().getValue() + 1;
    }

    public double getElementSizeInBits() {
        if (this.getInterfaceElementArrayHeader().isValid() && ((Boolean)this.getInterfaceElementArrayHeader().getValue()).booleanValue()) {
            return (double)this.getArrayLength() * this.getArrayElements().stream().filter(e -> e.isIncludedInCounts()).collect(Collectors.summingDouble(InterfaceStructureElementToken::getElementSizeInBits));
        }
        return (double)this.getArrayLength() * this.getInterfacePlatformTypeBitSize();
    }

    public double getElementSizeInBytes() {
        if (this.getInterfaceElementArrayHeader().isValid() && ((Boolean)this.getInterfaceElementArrayHeader().getValue()).booleanValue() && this.getArrayElements().size() > 0) {
            return (double)this.getArrayLength() * this.getArrayElements().stream().filter(e -> e.isIncludedInCounts()).collect(Collectors.summingDouble(InterfaceStructureElementToken::getElementSizeInBytes));
        }
        return (double)this.getArrayLength() * this.getInterfacePlatformTypeBitSize() / 8.0;
    }

    @JsonIgnore
    public boolean isHasNegativeEndByteOffset() {
        return this.hasNegativeEndByteOffset;
    }

    @JsonIgnore
    public void setHasNegativeEndByteOffset(boolean hasNegativeEndByteOffset) {
        this.hasNegativeEndByteOffset = hasNegativeEndByteOffset;
    }

    public PlatformTypeToken getPlatformType() {
        return this.platformType;
    }

    public void setPlatformType(PlatformTypeToken platformType) {
        this.platformType = platformType;
    }

    public List<InterfaceStructureElementToken> getArrayElements() {
        return this.arrayElements;
    }

    public void setArrayElements(List<InterfaceStructureElementToken> arrayElements) {
        this.arrayElements = arrayElements;
    }

    public AttributePojo<String> getEnumLiteral() {
        return this.enumLiteral;
    }

    public void setEnumLiteral(String enumLiteral) {
        this.enumLiteral = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementEnumLiteral, (GammaId)GammaId.SENTINEL, (Object)enumLiteral, (String)"");
    }

    @JsonProperty
    public void setEnumLiteral(AttributePojo<String> enumLiteral) {
        this.enumLiteral = enumLiteral;
    }

    @JsonIgnore
    public int getValidationSize() {
        return this.validationSize;
    }

    @JsonIgnore
    public void setValidationSize(int validationSize) {
        this.validationSize = validationSize;
    }

    @JsonIgnore
    public boolean isShouldValidate() {
        return this.shouldValidate;
    }

    @JsonIgnore
    public void setShouldValidate(boolean shouldValidate) {
        this.shouldValidate = shouldValidate;
    }

    @JsonIgnore
    public boolean isArrayChild() {
        return this.isArrayChild;
    }

    public void setArrayChild(boolean isArrayChild) {
        this.isArrayChild = isArrayChild;
    }

    @JsonIgnore
    public InterfaceEnumerationSet getArrayDescriptionSet() {
        return this.arrayDescriptionSet;
    }

    public void setArrayDescriptionSet(InterfaceEnumerationSet arrayDescriptionSet) {
        this.arrayDescriptionSet = arrayDescriptionSet;
    }

    public AttributePojo<Boolean> isInterfaceElementBlockData() {
        return this.interfaceElementBlockData;
    }

    public AttributePojo<Boolean> getInterfaceElementBlockData() {
        return this.interfaceElementBlockData;
    }

    public void setInterfaceElementBlockData(Boolean interfaceElementBlockData) {
        this.interfaceElementBlockData = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceElementBlockData, (GammaId)GammaId.SENTINEL, (Object)interfaceElementBlockData, (String)"");
    }

    @JsonProperty
    public void setInterfaceElementBlockData(AttributePojo<Boolean> interfaceElementBlockData) {
        this.interfaceElementBlockData = interfaceElementBlockData;
    }

    public CreateArtifact createArtifact(String key, ApplicabilityId applicId) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.Description, (String)this.getDescription().getValue());
        values.put(CoreAttributeTypes.InterfaceDefaultValue, (String)this.getInterfaceDefaultValue().getValue());
        values.put(CoreAttributeTypes.InterfaceElementAlterable, ((Boolean)this.getInterfaceElementAlterable().getValue()).toString());
        values.put(CoreAttributeTypes.Notes, (String)this.getNotes().getValue());
        values.put(CoreAttributeTypes.InterfaceElementEnumLiteral, (String)this.getEnumLiteral().getValue());
        values.put(CoreAttributeTypes.InterfaceElementIndexStart, ((Integer)this.getInterfaceElementIndexStart().getValue()).toString());
        values.put(CoreAttributeTypes.InterfaceElementIndexEnd, ((Integer)this.getInterfaceElementIndexEnd().getValue()).toString());
        CreateArtifact art = new CreateArtifact();
        art.setName((String)this.getName().getValue());
        art.setTypeId(CoreArtifactTypes.InterfaceDataElement.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.InterfaceDataElement.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setApplicabilityId(applicId.getIdString());
        art.setkey(key);
        return art;
    }
}

