/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;

public class ConnectionValidationResult {
    private final BranchId branch;
    private final ArtifactId viewId;
    private final String connectionName;
    private final Map<ArtifactId, String> structureByteAlignmentErrors = new HashMap<ArtifactId, String>();
    private final Map<ArtifactId, String> structureWordAlignmentErrors = new HashMap<ArtifactId, String>();
    private final Map<ArtifactId, String> duplicateStructureNameErrors = new HashMap<ArtifactId, String>();
    private final Map<ArtifactId, String> messageTypeErrors = new HashMap<ArtifactId, String>();

    public ConnectionValidationResult() {
        this.branch = BranchId.SENTINEL;
        this.viewId = ArtifactId.SENTINEL;
        this.connectionName = "";
    }

    public ConnectionValidationResult(BranchId branch, ArtifactId viewId, String connectionName) {
        this.branch = branch;
        this.viewId = viewId;
        this.connectionName = connectionName;
    }

    public String getBranch() {
        return this.branch.getIdString();
    }

    public ArtifactId getViewId() {
        return this.viewId;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public boolean isPassed() {
        return this.structureByteAlignmentErrors.isEmpty() && this.structureWordAlignmentErrors.isEmpty() && this.duplicateStructureNameErrors.isEmpty() && this.messageTypeErrors.isEmpty();
    }

    public Map<ArtifactId, String> getStructureByteAlignmentErrors() {
        return this.structureByteAlignmentErrors;
    }

    public Map<ArtifactId, String> getDuplicateStructureNameErrors() {
        return this.duplicateStructureNameErrors;
    }

    public Map<ArtifactId, String> getMessageTypeErrors() {
        return this.messageTypeErrors;
    }

    public Map<ArtifactId, String> getStructureWordAlignmentErrors() {
        return this.structureWordAlignmentErrors;
    }
}

