/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.internal;

import java.net.URI;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.account.rest.internal.AccountActiveResource;
import org.eclipse.osee.account.rest.internal.AccountOps;
import org.eclipse.osee.account.rest.internal.AccountPreferencesResource;
import org.eclipse.osee.account.rest.internal.AccountSessionsResource;
import org.eclipse.osee.account.rest.model.AccountDetailsData;
import org.eclipse.osee.framework.core.data.ArtifactId;

public class AccountResource {
    private final AccountOps accountOps;
    private final ArtifactId accountId;

    public AccountResource(AccountOps accountOps, ArtifactId accountId) {
        this.accountOps = accountOps;
        this.accountId = accountId;
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    public Response deleteAccount() {
        this.accountOps.deleteAccount(this.accountId);
        return Response.ok().build();
    }

    @GET
    @RolesAllowed(value={"authenticated"})
    @Produces(value={"application/json", "application/xml"})
    public AccountDetailsData getAccountDetailsData() {
        return this.accountOps.getAccountDetailsData(this.accountId);
    }

    @RolesAllowed(value={"authenticated"})
    @Path(value="subscriptions")
    @GET
    public Response getSubscriptions(@Context UriInfo uriInfo) {
        URI requestUri = uriInfo.getRequestUri();
        URI uri = UriBuilder.fromUri((URI)requestUri).path("../../../").path("subscriptions").path("for-account").path("{account-id}").build(new Object[]{this.accountId.getIdString()});
        return Response.seeOther((URI)uri).build();
    }

    @Path(value="preferences")
    public AccountPreferencesResource getAccountSettingsData() {
        return new AccountPreferencesResource(this.accountOps, this.accountId);
    }

    @Path(value="active")
    public AccountActiveResource active() {
        return new AccountActiveResource(this.accountOps, this.accountId);
    }

    @Path(value="sessions")
    public AccountSessionsResource sessions() {
        return new AccountSessionsResource(this.accountOps, this.accountId);
    }
}

