/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class VersionInformationToken
extends ArtifactAccessorResultWithoutGammas {
    public static final VersionInformationToken SENTINEL = new VersionInformationToken();
    private String versionInfo;
    private String versionUnit;
    private boolean underTest;

    public VersionInformationToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public VersionInformationToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setVersionInfo(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.VersionInfo, ""));
        this.setVersionUnit(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.VersionUnit, ""));
        this.setUnderTest((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UnderTest, (Object)false));
    }

    public VersionInformationToken(Long id, String name) {
        super(id, name);
        this.setVersionInfo("");
        this.setVersionUnit("");
        this.setUnderTest(false);
    }

    public VersionInformationToken() {
    }

    public String getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(String versionInfo) {
        this.versionInfo = versionInfo;
    }

    public String getVersionUnit() {
        return this.versionUnit;
    }

    public void setVersionUnit(String versionUnit) {
        this.versionUnit = versionUnit;
    }

    public boolean isUnderTest() {
        return this.underTest;
    }

    public void setUnderTest(boolean underTest) {
        this.underTest = underTest;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.VersionInfo, this.getVersionInfo());
        values.put(CoreAttributeTypes.VersionUnit, this.getVersionUnit());
        values.put(CoreAttributeTypes.UnderTest, Boolean.toString(this.isUnderTest()));
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.VersionInformation.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.VersionInformation.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

