/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.testscript.TestPointApi;
import org.eclipse.osee.testscript.TestPointEndpoint;
import org.eclipse.osee.testscript.internal.TestPointToken;

public class TestPointEndpointImpl
implements TestPointEndpoint {
    private final TestPointApi testPointTypeApi;
    private final BranchId branch;

    public TestPointEndpointImpl(BranchId branch, TestPointApi testPointTypeApi) {
        this.testPointTypeApi = testPointTypeApi;
        this.branch = branch;
    }

    @Override
    public Collection<TestPointToken> getAllTestPointTypes(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.testPointTypeApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.testPointTypeApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public TestPointToken getTestPointType(ArtifactId testPointTypeId) {
        return this.testPointTypeApi.get(this.branch, testPointTypeId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.testPointTypeApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

