/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class ScriptLogToken
extends ArtifactAccessorResultWithoutGammas {
    public static final ScriptLogToken SENTINEL = new ScriptLogToken();
    private String logLevel;
    private String logger;
    private String logMessage;
    private String logThrowable;

    public ScriptLogToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public ScriptLogToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setLogLevel(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.LogLevel, ""));
        this.setLogger(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Logger, ""));
        this.setLogMessage(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.LogMessage, ""));
        this.setLogThrowable(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.LogThrowable, ""));
    }

    public ScriptLogToken(Long id, String name) {
        super(id, name);
    }

    public ScriptLogToken() {
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogger() {
        return this.logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    public String getLogThrowable() {
        return this.logThrowable;
    }

    public void setLogThrowable(String logThrowable) {
        this.logThrowable = logThrowable;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<AttributeTypeString, String> values = new HashMap<AttributeTypeString, String>();
        values.put(CoreAttributeTypes.Logger, this.getLogger());
        values.put(CoreAttributeTypes.LogLevel, this.getLogLevel());
        values.put(CoreAttributeTypes.LogMessage, this.getLogMessage());
        values.put(CoreAttributeTypes.LogThrowable, this.getLogThrowable());
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.ScriptLog.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.ScriptLog.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

