/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.FollowRelation;
import org.eclipse.osee.testscript.ScriptDefApi;
import org.eclipse.osee.testscript.ScriptDefEndpoint;
import org.eclipse.osee.testscript.internal.ScriptDefToken;

public class ScriptDefEndpointImpl
implements ScriptDefEndpoint {
    private final ScriptDefApi scriptDefApi;
    private final BranchId branch;

    public ScriptDefEndpointImpl(BranchId branch, ScriptDefApi scriptDefTypeApi) {
        this.scriptDefApi = scriptDefTypeApi;
        this.branch = branch;
    }

    @Override
    public Collection<ScriptDefToken> getAllScriptDefs(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.scriptDefApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.scriptDefApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public Collection<ScriptDefToken> getScriptDefBySet(ArtifactId scriptSetId, long pageNum, long pageSize) {
        try {
            String filter = scriptSetId.getIdString();
            if (scriptSetId.isValid()) {
                return this.scriptDefApi.getAllByFilter(this.branch, filter, FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.TestScriptDefToTestScriptResults_TestScriptResults}), pageNum, pageSize, (AttributeTypeId)CoreAttributeTypes.Name, Arrays.asList(CoreAttributeTypes.SetId));
            }
            return List.of();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    @Override
    public int getCountForSet(ArtifactId scriptSetId, ArtifactId viewId) {
        try {
            String filter = scriptSetId.getIdString();
            if (scriptSetId.isValid()) {
                return this.scriptDefApi.getAllByFilterAndCount(this.branch, filter, FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.TestScriptDefToTestScriptResults_TestScriptResults}), Arrays.asList(CoreAttributeTypes.SetId), viewId);
            }
            return 0;
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    @Override
    public ScriptDefToken getScriptDefType(ArtifactId scriptDefTypeId) {
        return this.scriptDefApi.get(this.branch, scriptDefTypeId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.scriptDefApi.getCountWithFilter(this.branch, viewId, filter, Arrays.asList(CoreAttributeTypes.Name));
    }
}

