/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.testscript.internal.ScriptBatchToken;

public class ScriptBatchStreamingOutput
implements StreamingOutput {
    private final File[] tmoFiles;
    private final ScriptBatchToken batch;

    public ScriptBatchStreamingOutput(File[] tmoFiles, ScriptBatchToken batch) {
        this.tmoFiles = tmoFiles;
        this.batch = batch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(OutputStream os) {
        ZipOutputStream zipOut = new ZipOutputStream(os);
        try {
            File[] fileArray = this.tmoFiles;
            int n = this.tmoFiles.length;
            int n2 = 0;
            while (true) {
                block18: {
                    if (n2 >= n) {
                        zipOut.putNextEntry(new ZipEntry("runId.txt"));
                        zipOut.write(new String(this.batch.getTestEnvBatchId()).getBytes(Charset.forName("UTF-8")));
                        zipOut.closeEntry();
                        zipOut.close();
                        return;
                    }
                    File tmo = fileArray[n2];
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try {
                        FileInputStream fis = new FileInputStream(tmo);
                        try {
                            try (ZipInputStream zis = new ZipInputStream(fis);){
                                ZipEntry tmoEntry = zis.getNextEntry();
                                if (tmoEntry != null) {
                                    zipOut.putNextEntry(new ZipEntry(tmoEntry.getName()));
                                    zis.transferTo(zipOut);
                                    zipOut.closeEntry();
                                }
                            }
                            if (fis == null) break block18;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (fis == null) throw throwable;
                            fis.close();
                            throw throwable;
                        }
                        fis.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }
}

