/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSaxHandler;
import org.eclipse.osee.testscript.internal.AttentionLocationToken;
import org.eclipse.osee.testscript.internal.ErrorEntryToken;
import org.eclipse.osee.testscript.internal.InfoGroupToken;
import org.eclipse.osee.testscript.internal.InfoToken;
import org.eclipse.osee.testscript.internal.LoggingSummaryToken;
import org.eclipse.osee.testscript.internal.ScriptDefToken;
import org.eclipse.osee.testscript.internal.ScriptLogToken;
import org.eclipse.osee.testscript.internal.ScriptResultToken;
import org.eclipse.osee.testscript.internal.StackTraceToken;
import org.eclipse.osee.testscript.internal.TestCaseToken;
import org.eclipse.osee.testscript.internal.TestPointToken;
import org.eclipse.osee.testscript.internal.TraceToken;
import org.eclipse.osee.testscript.internal.VersionInformationToken;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FullTmoReader {
    private TMO_LEVEL currentLevel = TMO_LEVEL.TESTSCRIPT;
    private boolean inAttention = false;
    private boolean inExecutedBy = false;
    private boolean inOteLog = false;
    private boolean inRuntimeVersions;
    private boolean inTracability = false;
    private boolean inVersionInformation = false;
    private boolean inWitnesses = false;
    private ScriptDefToken currentScript;
    private ScriptResultToken currentScriptResult;
    private TestCaseToken currentTestCase;
    private Stack<TestPointToken> currentTestPoints;
    private AttentionLocationToken currentAttentionLocation;
    private StackTraceToken currentStackTrace;
    private ScriptLogToken currentOteLog;
    private TraceToken currentTrace;
    private LoggingSummaryToken currentLoggingSummary;
    private ErrorEntryToken currentErrorEntry;
    private InfoToken currentInfo;
    private InfoGroupToken currentInfoGroup;
    private final SimpleDateFormat executionDateFormat = new SimpleDateFormat("MMMM dd, yyyy hh:mm:ss a z", Locale.ENGLISH);
    private final SimpleDateFormat timeSummaryDateFormat = new SimpleDateFormat("EEE MMM dd kk:mm:ss z yyyy", Locale.ENGLISH);

    public ScriptDefToken getScriptDefinition(InputStream stream) {
        this.currentScript = new ScriptDefToken(-1L, "");
        this.currentScriptResult = new ScriptResultToken(-1L, "");
        this.currentScript.getScriptResults().add(this.currentScriptResult);
        this.currentTestPoints = new Stack();
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(stream, (DefaultHandler)((Object)new TmoHandler()));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            System.out.println(ex);
        }
        return this.currentScript;
    }

    private static enum TMO_LEVEL {
        TESTSCRIPT,
        TESTCASE,
        TESTPOINT;

    }

    private class TmoHandler
    extends AbstractSaxHandler {
        private final Map<String, AbstractTmoHandler> handlers = new HashMap<String, AbstractTmoHandler>();

        public TmoHandler() {
            this.handlers.put("Actual", new ActualHandler());
            this.handlers.put("Attention", new AttentionHandler());
            this.handlers.put("CheckGroup", new CheckGroupHandler());
            this.handlers.put("CheckPoint", new TestPointHandler());
            this.handlers.put("Config", new ConfigHandler());
            this.handlers.put("CurrentProcessor", new CurrentProcessorHandler());
            this.handlers.put("ElapsedTime", new ElapsedTimeHandler());
            this.handlers.put("Environment", new EnvironmentHandler());
            this.handlers.put("ExecutedBy", new ExecutedByHandler());
            this.handlers.put("ExecutionDate", new ExecutionDateHandler());
            this.handlers.put("Expected", new ExpectedHandler());
            this.handlers.put("GroupName", new GroupNameHandler());
            this.handlers.put("Info", new InfoHandler());
            this.handlers.put("InfoGroup", new InfoGroupHandler());
            this.handlers.put("isInteractive", new isInteractiveHandler());
            this.handlers.put("Location", new LocationHandler());
            this.handlers.put("Message", new MessageHandler());
            this.handlers.put("Name", new NameHandler());
            this.handlers.put("Number", new NumberHandler());
            this.handlers.put("NumberOfTransmissions", new NumberOfTransmissionsHandler());
            this.handlers.put("OteLog", new OteLogHandler());
            this.handlers.put("Qualification", new QualificationHandler());
            this.handlers.put("Result", new ResultHandler());
            this.handlers.put("RetryGroup", new RetryGroupHandler());
            this.handlers.put("RuntimeVersions", new RuntimeVersionsHandler());
            this.handlers.put("ScriptInit", new ScriptInitHandler());
            this.handlers.put("ScriptName", new ScriptNameHandler());
            this.handlers.put("ScriptResult", new NoOpHandler());
            this.handlers.put("ScriptVersion", new ScriptVersionHandler());
            this.handlers.put("SoftKeyInfoGroup", new InfoGroupHandler());
            this.handlers.put("Stacktrace", new StackTraceHandler());
            this.handlers.put("Summary", new SummaryHandler());
            this.handlers.put("SystemInfo", new SystemInfoHandler());
            this.handlers.put("TestCase", new TestCaseHandler());
            this.handlers.put("TestPoint", new TestPointHandler());
            this.handlers.put("TestPointName", new NameHandler());
            this.handlers.put("TestPointResults", new TestPointResultsHandler());
            this.handlers.put("TestScript", new TestScriptHandler());
            this.handlers.put("Throwable", new ThrowableHandler());
            this.handlers.put("Time", new TimeHandler());
            this.handlers.put("TimeSummary", new TimeSummaryHandler());
            this.handlers.put("Tracability", new TracabilityHandler());
            this.handlers.put("User", new UserHandler());
            this.handlers.put("UutErrorEntry", new UutErrorEntryHandler());
            this.handlers.put("UutLoggingInfo", new NoOpHandler());
            this.handlers.put("Version", new VersionHandler());
            this.handlers.put("VersionInformation", new VersionInformationHandler());
            this.handlers.put("Witnesses", new WitnessesHandler());
        }

        public void startElementFound(String uri, String localName, String qName, Attributes attributes) throws Exception {
            AbstractTmoHandler handler = this.handlers.get(qName);
            if (handler != null) {
                handler.startElementFound(uri, localName, qName, attributes);
            } else {
                System.out.println("No handler for: " + qName);
            }
        }

        public void endElementFound(String uri, String localName, String qName) throws Exception {
            AbstractTmoHandler handler = this.handlers.get(qName);
            if (handler != null) {
                handler.endElementFound(uri, localName, qName, this.getContents().trim());
            }
        }

        private abstract class AbstractTmoHandler {
            private AbstractTmoHandler() {
            }

            public abstract void startElementFound(String var1, String var2, String var3, Attributes var4);

            public abstract void endElementFound(String var1, String var2, String var3, String var4);
        }

        private class ActualHandler
        extends AbstractTmoHandler {
            private ActualHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setActual(content);
                }
            }
        }

        private class AttentionHandler
        extends AbstractTmoHandler {
            private AttentionHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inAttention = true;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation = new AttentionLocationToken();
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTSCRIPT)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.getAttentionMessages().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation);
                } else if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTCASE)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase.getAttentionMessages().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation);
                }
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation = null;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inAttention = false;
            }
        }

        private class CheckGroupHandler
        extends AbstractTmoHandler {
            private CheckGroupHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTPOINT;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.push(new TestPointToken(-1L, ""));
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setGroupType("CheckGroup");
                String mode = attributes.getValue("Mode");
                if (Strings.isValid((String)mode)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setGroupOperator(mode);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                TestPointToken testPoint = ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.pop();
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.size() > 0) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().getSubTestPoints().add(testPoint);
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTPOINT;
                } else {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase.getTestPoints().add(testPoint);
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTCASE;
                }
            }
        }

        private class ConfigHandler
        extends AbstractTmoHandler {
            private ConfigHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String machineName = attributes.getValue("machineName");
                if (Strings.isValid((String)machineName)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setMachineName(machineName);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class CurrentProcessorHandler
        extends AbstractTmoHandler {
            private CurrentProcessorHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String proc = attributes.getValue("proc");
                if (Strings.isValid((String)proc)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setProcessorId(proc);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class ElapsedTimeHandler
        extends AbstractTmoHandler {
            private ElapsedTimeHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setElapsedTime(Integer.parseInt(content));
                }
            }
        }

        private class EnvironmentHandler
        extends AbstractTmoHandler {
            private EnvironmentHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScript.setExecutionEnvironment(content);
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setExecutionEnvironment(content);
                }
            }
        }

        private class ExecutedByHandler
        extends AbstractTmoHandler {
            private ExecutedByHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inExecutedBy = true;
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inExecutedBy = false;
            }
        }

        private class ExecutionDateHandler
        extends AbstractTmoHandler {
            private ExecutionDateHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                try {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setExecutionDate(((TmoHandler)TmoHandler.this).FullTmoReader.this.executionDateFormat.parse(content));
                }
                catch (ParseException ex) {
                    System.out.println("Could not parse Execution Date");
                    System.out.println(ex);
                }
            }
        }

        private class ExpectedHandler
        extends AbstractTmoHandler {
            private ExpectedHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setExpected(content);
                }
            }
        }

        private class GroupNameHandler
        extends AbstractTmoHandler {
            private GroupNameHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setGroupName(content);
            }
        }

        private class InfoGroupHandler
        extends AbstractTmoHandler {
            private InfoGroupHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentInfoGroup = new InfoGroupToken(-1L, "");
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentInfoGroup.setGroupType(qName);
                String title = attributes.getValue("title");
                if (Strings.isValid((String)title)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentInfoGroup.setName(title);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().getInfoGroups().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentInfoGroup);
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentInfoGroup = null;
            }
        }

        private class InfoHandler
        extends AbstractTmoHandler {
            private InfoHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentInfo = new InfoToken(-1L, "");
                String title = attributes.getValue("title");
                if (Strings.isValid((String)title)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentInfo.setName(title);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentInfoGroup.getInfo().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentInfo);
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentInfo = null;
            }
        }

        private class LocationHandler
        extends AbstractTmoHandler {
            private LocationHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation = new AttentionLocationToken(-1L, "");
                String id = attributes.getValue("id");
                if (Strings.isValid((String)id)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation.setLocationId(id);
                }
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inAttention = true;
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().getLocations().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation);
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation = null;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inAttention = false;
            }
        }

        private class MessageHandler
        extends AbstractTmoHandler {
            private MessageHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.inAttention) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation.setAttentionMessage(content);
                    return;
                }
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.inOteLog) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentOteLog.setLogMessage(content);
                    return;
                }
            }
        }

        private class NameHandler
        extends AbstractTmoHandler {
            private NameHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.inExecutedBy) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setExecutedBy(content);
                    return;
                }
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.inWitnesses) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.getWitnesses().add(content);
                    return;
                }
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTCASE)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase.setName(content);
                    return;
                }
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTPOINT)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setName(content);
                }
            }
        }

        private class NoOpHandler
        extends AbstractTmoHandler {
            private NoOpHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class NumberHandler
        extends AbstractTmoHandler {
            private NumberHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                double number = Double.parseDouble(content);
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTCASE)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase.setTestNumber(number);
                }
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTPOINT)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setTestNumber(number);
                }
            }
        }

        private class NumberOfTransmissionsHandler
        extends AbstractTmoHandler {
            private NumberOfTransmissionsHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setTransmissionCount(Integer.parseInt(content));
                }
            }
        }

        private class OteLogHandler
        extends AbstractTmoHandler {
            private OteLogHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inOteLog = true;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentOteLog = new ScriptLogToken(-1L, "Script Log");
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentOteLog.setLogLevel(attributes.getValue("Level"));
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentOteLog.setLogger(attributes.getValue("Logger"));
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.inTracability) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTrace.getLogs().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentOteLog);
                } else if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTSCRIPT)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.getLogs().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentOteLog);
                } else if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTCASE)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase.getLogs().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentOteLog);
                }
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentOteLog = null;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inOteLog = false;
            }
        }

        private class QualificationHandler
        extends AbstractTmoHandler {
            private QualificationHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setQualificationLevel(attributes.getValue("Level"));
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class ResultHandler
        extends AbstractTmoHandler {
            private ResultHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTPOINT)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setResult(content);
                }
            }
        }

        private class RetryGroupHandler
        extends AbstractTmoHandler {
            private RetryGroupHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTPOINT;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.push(new TestPointToken(-1L, ""));
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setGroupType("RetryGroup");
                String mode = attributes.getValue("Mode");
                if (Strings.isValid((String)mode)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setGroupOperator(mode);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                TestPointToken testPoint = ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.pop();
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.size() > 0) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().getSubTestPoints().add(testPoint);
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTPOINT;
                } else {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase.getTestPoints().add(testPoint);
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTCASE;
                }
            }
        }

        private class RuntimeVersionsHandler
        extends AbstractTmoHandler {
            private RuntimeVersionsHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inRuntimeVersions = true;
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inRuntimeVersions = false;
            }
        }

        private class ScriptInitHandler
        extends AbstractTmoHandler {
            private ScriptInitHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTCASE;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase = new TestCaseToken(-1L, "");
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase.setInitial(true);
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.getTestCases().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase);
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase = null;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTSCRIPT;
            }
        }

        private class ScriptNameHandler
        extends AbstractTmoHandler {
            private ScriptNameHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    String[] split = content.split("\\.");
                    String name = content;
                    if (split.length > 1) {
                        name = split[split.length - 1];
                    }
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScript.setName(name);
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScript.setFullScriptName(content);
                }
            }
        }

        private class ScriptVersionHandler
        extends AbstractTmoHandler {
            private ScriptVersionHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String revision = attributes.getValue("revision");
                String repositoryType = attributes.getValue("repositoryType");
                String lastAuthor = attributes.getValue("lastAuthor");
                String lastModified = attributes.getValue("lastModified");
                String modifiedFlag = attributes.getValue("modifiedFlag");
                String url = attributes.getValue("url");
                if (Strings.isValid((String)revision)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScript.setRevision(revision);
                }
                if (Strings.isValid((String)repositoryType)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScript.setRepositoryType(repositoryType);
                }
                if (Strings.isValid((String)lastAuthor)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScript.setLastAuthor(lastAuthor);
                }
                if (Strings.isValid((String)lastModified)) {
                    System.out.println("LAST MODIFIED: " + ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScript.getName());
                }
                if (Strings.isValid((String)modifiedFlag)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScript.setModifiedFlag(modifiedFlag);
                }
                if (Strings.isValid((String)url)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScript.setRepositoryUrl(url);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class StackTraceHandler
        extends AbstractTmoHandler {
            private StackTraceHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentStackTrace = new StackTraceToken(-1L, "");
                String source = attributes.getValue("source");
                String line = attributes.getValue("line");
                if (Strings.isValid((String)source)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentStackTrace.setSource(source);
                }
                if (Strings.isValid((String)line)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentStackTrace.setLine(line);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.inAttention) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation.getStackTraces().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentStackTrace);
                }
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentStackTrace = null;
            }
        }

        private class SummaryHandler
        extends AbstractTmoHandler {
            private SummaryHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary = new LoggingSummaryToken(-1L, "");
                String nodeId = attributes.getValue("NODE_ID");
                String startNumber = attributes.getValue("START_NUMBER");
                String informationalCount = attributes.getValue("INFORMATIONAL_COUNT");
                String minorCount = attributes.getValue("MINOR_COUNT");
                String seriousCount = attributes.getValue("SERIOUS_COUNT");
                String criticalCount = attributes.getValue("CRITICAL_COUNT");
                String exceptionCount = attributes.getValue("EXCEPTION_COUNT");
                if (Strings.isValid((String)nodeId)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary.setSummaryId(Integer.parseInt(nodeId));
                }
                if (Strings.isValid((String)startNumber)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary.setStartNumber(Integer.parseInt(startNumber));
                }
                if (Strings.isValid((String)informationalCount)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary.setInformationalCount(Integer.parseInt(informationalCount));
                }
                if (Strings.isValid((String)minorCount)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary.setMinorCount(Integer.parseInt(minorCount));
                }
                if (Strings.isValid((String)seriousCount)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary.setSeriousCount(Integer.parseInt(seriousCount));
                }
                if (Strings.isValid((String)criticalCount)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary.setCriticalCount(Integer.parseInt(criticalCount));
                }
                if (Strings.isValid((String)exceptionCount)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary.setExceptionCount(Integer.parseInt(exceptionCount));
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.getLoggingSummaries().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary);
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary = null;
            }
        }

        private class SystemInfoHandler
        extends AbstractTmoHandler {
            private SystemInfoHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String osName = attributes.getValue("osName");
                String osVersion = attributes.getValue("osVersion");
                String osArch = attributes.getValue("osArch");
                String oseeVersion = attributes.getValue("oseeVersion");
                String javaVersion = attributes.getValue("javaVersion");
                String oseeServerTitle = attributes.getValue("oseeServerTitle");
                if (Strings.isValid((String)osName)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setOsName(osName);
                }
                if (Strings.isValid((String)osVersion)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setOsVersion(osVersion);
                }
                if (Strings.isValid((String)osArch)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setOsArchitecture(osArch);
                }
                if (Strings.isValid((String)oseeVersion)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setOseeVersion(oseeVersion);
                }
                if (Strings.isValid((String)javaVersion)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setJavaVersion(javaVersion);
                }
                if (Strings.isValid((String)oseeServerTitle)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setOseeServer(oseeServerTitle);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class TestCaseHandler
        extends AbstractTmoHandler {
            private TestCaseHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTCASE;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase = new TestCaseToken(-1L, "");
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.getTestCases().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase);
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase = null;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTSCRIPT;
            }
        }

        private class TestPointHandler
        extends AbstractTmoHandler {
            private TestPointHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTPOINT;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.push(new TestPointToken(-1L, ""));
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                TestPointToken testPoint = ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.pop();
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.size() > 0) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().getSubTestPoints().add(testPoint);
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTPOINT;
                } else {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase.getTestPoints().add(testPoint);
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTCASE;
                }
            }
        }

        private class TestPointResultsHandler
        extends AbstractTmoHandler {
            private TestPointResultsHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String pass = attributes.getValue("pass");
                String fail = attributes.getValue("fail");
                String aborted = attributes.getValue("aborted");
                if (Strings.isValid((String)pass)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setPassedCount(Integer.parseInt(pass));
                }
                if (Strings.isValid((String)fail)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setFailedCount(Integer.parseInt(fail));
                }
                if (Strings.isValid((String)aborted)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setScriptAborted(Boolean.parseBoolean(aborted));
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class TestScriptHandler
        extends AbstractTmoHandler {
            private TestScriptHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel = TMO_LEVEL.TESTSCRIPT;
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class ThrowableHandler
        extends AbstractTmoHandler {
            private ThrowableHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.inOteLog) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentOteLog.setLogThrowable(content);
                    return;
                }
            }
        }

        private class TimeHandler
        extends AbstractTmoHandler {
            private TimeHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.inAttention) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentAttentionLocation.setLocationTime(content);
                }
            }
        }

        private class TimeSummaryHandler
        extends AbstractTmoHandler {
            private TimeSummaryHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String milliseconds = attributes.getValue("milliseconds");
                String startDate = attributes.getValue("startDate");
                String endDate = attributes.getValue("endDate");
                if (Strings.isValid((String)milliseconds)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setElapsedTime(Integer.parseInt(milliseconds));
                    try {
                        ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setStartDate(((TmoHandler)TmoHandler.this).FullTmoReader.this.timeSummaryDateFormat.parse(startDate));
                    }
                    catch (ParseException ex) {
                        System.out.println("Could not parse Start Date");
                        System.out.println(ex);
                    }
                    try {
                        ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setEndDate(((TmoHandler)TmoHandler.this).FullTmoReader.this.timeSummaryDateFormat.parse(endDate));
                    }
                    catch (ParseException ex) {
                        System.out.println("Could not parse End Date");
                        System.out.println(ex);
                    }
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class TracabilityHandler
        extends AbstractTmoHandler {
            private TracabilityHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTrace = new TraceToken(-1L, "");
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inTracability = true;
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTCASE)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestCase.getTrace().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTrace);
                }
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTrace = null;
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inTracability = false;
            }
        }

        private class UserHandler
        extends AbstractTmoHandler {
            private UserHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String name = attributes.getValue("name");
                String email = attributes.getValue("email");
                String id = attributes.getValue("id");
                if (Strings.isValid((String)name)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setUserName(name);
                }
                if (Strings.isValid((String)email)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setEmail(email);
                }
                if (Strings.isValid((String)id)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.setUserId(id);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class UutErrorEntryHandler
        extends AbstractTmoHandler {
            private UutErrorEntryHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentErrorEntry = new ErrorEntryToken(-1L, "");
                String nodeId = attributes.getValue("NODE_ID");
                String severity = attributes.getValue("severity");
                String version = attributes.getValue("version");
                String count = attributes.getValue("count");
                if (Strings.isValid((String)nodeId)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentErrorEntry.setSummaryId(Integer.parseInt(nodeId));
                }
                if (Strings.isValid((String)severity)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentErrorEntry.setErrorSeverity(severity);
                }
                if (Strings.isValid((String)version)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentErrorEntry.setErrorVersion(version);
                }
                if (Strings.isValid((String)count)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentErrorEntry.setErrorCount(Integer.parseInt(count));
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLoggingSummary.getErrorEntries().add(((TmoHandler)TmoHandler.this).FullTmoReader.this.currentErrorEntry);
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentErrorEntry = null;
            }
        }

        private class VersionHandler
        extends AbstractTmoHandler {
            private VersionHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.inVersionInformation) {
                    VersionInformationToken versionToken = new VersionInformationToken(-1L, "");
                    String name = attributes.getValue("name");
                    String version = attributes.getValue("version");
                    String versionUnit = attributes.getValue("versionUnit");
                    String underTest = attributes.getValue("underTest");
                    if (Strings.isValid((String)name)) {
                        versionToken.setName(name);
                    }
                    if (Strings.isValid((String)version)) {
                        versionToken.setVersionInfo(version);
                    }
                    if (Strings.isValid((String)versionUnit)) {
                        versionToken.setVersionUnit(versionUnit);
                    }
                    if (Strings.isValid((String)underTest)) {
                        versionToken.setUnderTest(Boolean.parseBoolean(underTest));
                    }
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.getVersionInformation().add(versionToken);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.inRuntimeVersions && Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentScriptResult.getRuntimeVersions().add(content);
                }
            }
        }

        private class VersionInformationHandler
        extends AbstractTmoHandler {
            private VersionInformationHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inVersionInformation = true;
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inVersionInformation = false;
            }
        }

        private class WitnessesHandler
        extends AbstractTmoHandler {
            private WitnessesHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inWitnesses = true;
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).FullTmoReader.this.inWitnesses = false;
            }
        }

        private class isInteractiveHandler
        extends AbstractTmoHandler {
            private isInteractiveHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).FullTmoReader.this.currentLevel.equals((Object)TMO_LEVEL.TESTPOINT)) {
                    ((TmoHandler)TmoHandler.this).FullTmoReader.this.currentTestPoints.peek().setInteractive(Boolean.parseBoolean(content));
                }
            }
        }
    }
}

